/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.execution;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.logging.CurrentContext;

public class DefaultExecutionContext
implements ExecutionContext {
    private final ClassLoader configurationClassLoader;
    private volatile int installs;
    private Map<Thread, ClassLoader> previousLoaders = new WeakHashMap<Thread, ClassLoader>();
    final String key;

    public DefaultExecutionContext(String key, ClassLoader loader) {
        this.configurationClassLoader = loader;
        this.key = key;
    }

    public synchronized void installLoader() {
        ++this.installs;
        if (this.configurationClassLoader != null && Thread.currentThread().getContextClassLoader() != this.configurationClassLoader) {
            this.previousLoaders.put(Thread.currentThread(), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(this.configurationClassLoader);
        }
    }

    public synchronized Object execute(ExecutionContext.Command c) {
        try {
            CurrentContext.push(this.key);
            this.installLoader();
            Object object = c.execute();
            return object;
        }
        finally {
            this.uninstallLoader();
            CurrentContext.pop();
        }
    }

    public synchronized void uninstallLoader() {
        --this.installs;
        if (this.installs == 0) {
            ClassLoader cl = this.previousLoaders.get(Thread.currentThread());
            if (this.configurationClassLoader != null && Thread.currentThread().getContextClassLoader() != this.configurationClassLoader) {
                String out = NLS.bind((String)ConsoleMessages.DefaultExecutionContext_existing_classloader, (Object)Thread.currentThread().getContextClassLoader(), (Object)this.configurationClassLoader);
                throw new IllegalStateException(out);
            }
            if (cl != null) {
                this.previousLoaders.remove(Thread.currentThread());
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

