/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal;

import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.AbstractJpaProject;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;

public class HibernateJpaProject
extends AbstractJpaProject {
    private Boolean cachedNamingStrategyEnable;

    public HibernateJpaProject(JpaProject.Config config) throws CoreException {
        super(config);
    }

    public NamingStrategy getNamingStrategy() {
        ConsoleConfiguration cc;
        String ccName = this.getDefaultConsoleConfigurationName();
        if ((ccName != null || "".equals(ccName)) && (cc = KnownConfigurations.getInstance().find(ccName)) != null && cc.getConfiguration() != null) {
            Configuration config = cc.getConfiguration();
            return config.getNamingStrategy();
        }
        return null;
    }

    public String getDefaultConsoleConfigurationName() {
        ProjectScope scope = new ProjectScope(this.getProject());
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            return node.get("default.configuration", this.getName());
        }
        return null;
    }

    public boolean isNamingStrategyEnabled() {
        if (this.cachedNamingStrategyEnable == null) {
            ProjectScope scope = new ProjectScope(this.getProject());
            IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
            this.cachedNamingStrategyEnable = node != null ? Boolean.valueOf(node.getBoolean("namingStrategy.enabled", true)) : Boolean.valueOf(true);
        }
        return this.cachedNamingStrategyEnable;
    }
}

