/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsAdapter;
import org.hibernate.console.KnownConfigurationsListener;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.osgi.framework.BundleContext;

public class HibernateJptPlugin
extends Plugin {
    public static final String ID = "org.jboss.tools.hibernate.jpt.core";
    private static HibernateJptPlugin inst = null;

    public static HibernateJptPlugin getDefault() {
        if (inst == null) {
            inst = new HibernateJptPlugin();
        }
        return inst;
    }

    private static void log(int severity, String message, Throwable e) {
        HibernateJptPlugin.getDefault().getLog().log((IStatus)new Status(severity, ID, message, e));
    }

    public static void logException(Throwable e) {
        HibernateJptPlugin.log(4, e.getMessage(), e);
    }

    public static void logException(String message, Throwable e) {
        HibernateJptPlugin.log(4, message, e);
    }

    public static void logError(String message) {
        HibernateJptPlugin.log(4, message, null);
    }

    public static void logWarning(String message) {
        HibernateJptPlugin.log(2, message, null);
    }

    public static void logInfo(String message) {
        HibernateJptPlugin.log(1, message, null);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        KnownConfigurations.getInstance().addConsoleConfigurationListener((KnownConfigurationsListener)new KnownConfigurationsAdapter(){

            private void revalidateProjects(ConsoleConfiguration ccfg) {
                try {
                    Iterator jpaProjects = JpaModelManager.instance().getJpaModel().jpaProjects();
                    while (jpaProjects.hasNext()) {
                        JpaProject jpaProject = (JpaProject)jpaProjects.next();
                        if (!(jpaProject instanceof HibernateJpaProject)) continue;
                        String ccName = ((HibernateJpaProject)jpaProject).getDefaultConsoleConfigurationName();
                        if (!ccfg.getName().equals(ccName)) continue;
                        HibernateJptPlugin.this.rebuildJpaProject(jpaProject.getJavaProject().getProject());
                    }
                }
                catch (CoreException e) {
                    HibernateJptPlugin.logException(e);
                }
            }

            public void configurationBuilt(ConsoleConfiguration ccfg) {
                if (ccfg.getConfiguration() == null || ccfg.getConfiguration().getNamingStrategy() == null) {
                    return;
                }
                this.revalidateProjects(ccfg);
            }

            public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
                if (forUpdate || root.getConfiguration() == null || root.getConfiguration().getNamingStrategy() == null) {
                    return;
                }
                this.revalidateProjects(root);
            }
        });
    }

    private void rebuildJpaProject(final IProject project) {
        try {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JpaModelManager.instance().rebuildJpaProject(project);
                    project.build(6, monitor);
                }
            };
            try {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            throw new RuntimeException(te);
        }
    }
}

