/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import java.util.ListIterator;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.HibernateBasic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJpaProperties
extends AbstractModel {
    private PersistenceUnit persistenceUnit;
    private BasicHibernateProperties basicHibernateProperties;
    private ListValueModel<PersistenceUnit.Property> propertiesAdapter;
    private ListValueModel<PersistenceUnit.Property> propertyListAdapter;

    public HibernateJpaProperties(PersistenceUnit parent) {
        this.initialize(parent);
    }

    protected void initialize(PersistenceUnit parent) {
        this.persistenceUnit = parent;
        SimplePropertyValueModel persistenceUnitHolder = new SimplePropertyValueModel((Object)this.persistenceUnit);
        this.propertiesAdapter = this.buildPropertiesAdapter((PropertyValueModel<PersistenceUnit>)persistenceUnitHolder);
        this.propertyListAdapter = this.buildPropertyListAdapter(this.propertiesAdapter);
        this.basicHibernateProperties = this.buildBasicProperties();
    }

    private ListValueModel<PersistenceUnit.Property> buildPropertyListAdapter(ListValueModel<PersistenceUnit.Property> propertiesAdapter) {
        return new ItemPropertyListValueModelAdapter(propertiesAdapter, new String[]{"value", "name"});
    }

    private ListValueModel<PersistenceUnit.Property> buildPropertiesAdapter(PropertyValueModel<PersistenceUnit> subjectHolder) {
        return new ListAspectAdapter<PersistenceUnit, PersistenceUnit.Property>(subjectHolder, new String[]{"properties"}){

            protected ListIterator<PersistenceUnit.Property> listIterator_() {
                return ((PersistenceUnit)this.subject).properties();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).propertiesSize();
            }
        };
    }

    public BasicHibernateProperties getBasicHibernate() {
        return this.basicHibernateProperties;
    }

    private BasicHibernateProperties buildBasicProperties() {
        return new HibernateBasic(this.persistenceUnit(), this.propertyListAdapter());
    }

    public ListValueModel<PersistenceUnit.Property> propertyListAdapter() {
        return this.propertyListAdapter;
    }

    public PersistenceUnit persistenceUnit() {
        return this.persistenceUnit;
    }

    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }
}

