/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.jboss.tools.hibernate.jpt.core.internal.context.PersistenceUnitProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.PersistenceUnitPropertyListListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernatePersistenceUnitProperties
extends AbstractModel
implements PersistenceUnitProperties {
    private PersistenceUnit persistenceUnit;
    private PersistenceUnitPropertyListListener propertyListListener;
    private Map<String, String> propertyNames;

    protected HibernatePersistenceUnitProperties(PersistenceUnit parent, ListValueModel<PersistenceUnit.Property> propertyListAdapter) {
        this.initialize(parent, propertyListAdapter);
    }

    protected void initialize(PersistenceUnit parent, ListValueModel<PersistenceUnit.Property> propertyListAdapter) {
        this.persistenceUnit = parent;
        this.propertyListListener = new PersistenceUnitPropertyListListener(this);
        propertyListAdapter.addListChangeListener("list values", (ListChangeListener)this.propertyListListener);
        this.initializePropertyNames();
        this.initializeProperties();
    }

    protected void initializePropertyNames() {
        this.propertyNames = new HashMap<String, String>();
        this.addPropertyNames(this.propertyNames);
    }

    protected abstract void initializeProperties();

    @Override
    public PersistenceUnit persistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    public PersistenceUnitPropertyListListener propertyListListener() {
        return this.propertyListListener;
    }

    private Map<String, String> propertyNames() {
        return this.propertyNames;
    }

    protected abstract void addPropertyNames(Map<String, String> var1);

    @Override
    public boolean itemIsProperty(PersistenceUnit.Property item) {
        if (item == null) {
            throw new IllegalArgumentException("Property is null");
        }
        return this.propertyNames().keySet().contains(item.getName());
    }

    @Override
    public String propertyIdFor(PersistenceUnit.Property property) {
        String propertyId = this.propertyNames().get(property.getName());
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
        return propertyId;
    }

    protected String hibernateKeyFor(String propertyId) {
        for (String hibernateKey : this.propertyNames().keySet()) {
            if (!this.propertyNames().get(hibernateKey).equals(propertyId)) continue;
            return hibernateKey;
        }
        throw new IllegalArgumentException("Illegal property: " + propertyId);
    }

    protected String getStringValue(String key) {
        return this.getStringValue(key, null);
    }

    protected String getStringValue(String key, String keySuffix) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (this.persistenceUnit().getProperty(elKey) != null) {
            return this.persistenceUnit().getProperty(elKey).getValue();
        }
        return null;
    }

    protected void putStringValue(String key, String keySuffix, String newValue, boolean allowDuplicate) {
        String elKey;
        String string = elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        if (newValue == null) {
            this.persistenceUnit().removeProperty(elKey);
        } else {
            this.persistenceUnit().setProperty(elKey, newValue, allowDuplicate);
        }
    }

    protected void putProperty(String key, Object value) {
        String elKey = this.hibernateKeyFor(key);
        if (value == null) {
            this.removeProperty(elKey);
        } else {
            this.putProperty_(elKey, value);
        }
    }

    private void putProperty_(String key, Object value) {
        this.persistenceUnit().setProperty(key, value.toString(), false);
    }

    protected void removeProperty(String key) {
        if (this.persistenceUnit().getProperty(key) != null) {
            this.persistenceUnit().removeProperty(key);
        }
    }
}

