/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.GenericJavaIdMapping;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.context.Index;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaIdMapping;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaGenericGenerator;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.IndexAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaIdMappingImpl
extends GenericJavaIdMapping
implements HibernateJavaIdMapping {
    protected JavaGenericGenerator genericGenerator;
    protected Index index;

    public HibernateJavaIdMappingImpl(JavaPersistentAttribute parent) {
        super(parent);
    }

    public Iterator<String> supportingAnnotationNames() {
        return new CompositeIterator(super.supportingAnnotationNames(), (Object)"org.hibernate.annotations.Index");
    }

    protected HibernateJpaFactory getJpaFactory() {
        return (HibernateJpaFactory)super.getJpaFactory();
    }

    protected void initialize() {
        super.initialize();
        this.initializeGenericGenerator();
        this.initializeIndex();
    }

    public void update() {
        super.update();
        this.updateGenericGenerator();
        this.updateIndex();
    }

    public HibernateJavaColumn getColumn() {
        return (HibernateJavaColumn)this.column;
    }

    public String getPrimaryKeyColumnName() {
        return this.getColumn().getDBColumnName();
    }

    protected void initializeGenericGenerator() {
        GenericGeneratorAnnotation genericGeneratorResource = this.getResourceGenericGenerator();
        if (genericGeneratorResource != null) {
            this.genericGenerator = this.buildGenericGenerator(genericGeneratorResource);
        }
    }

    protected GenericGeneratorAnnotation getResourceGenericGenerator() {
        return (GenericGeneratorAnnotation)this.getResourcePersistentAttribute().getSupportingAnnotation("org.hibernate.annotations.GenericGenerator");
    }

    protected JavaGenericGenerator buildGenericGenerator(GenericGeneratorAnnotation genericGeneratorResource) {
        JavaGenericGenerator generator = this.getJpaFactory().buildJavaGenericGenerator((JavaJpaContextNode)this);
        generator.initialize(genericGeneratorResource);
        return generator;
    }

    public Iterator<JavaGenerator> generators() {
        return new CompositeIterator(new Iterator[]{super.generators(), this.getGenericGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getGenericGenerator())});
    }

    @Override
    public JavaGenericGenerator addGenericGenerator(int index) {
        if (this.getGenericGenerator() != null) {
            throw new IllegalStateException("genericGenerator already exists");
        }
        this.genericGenerator = this.getJpaFactory().buildJavaGenericGenerator((JavaJpaContextNode)this);
        GenericGeneratorAnnotation genericGeneratorResource = (GenericGeneratorAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation("org.hibernate.annotations.GenericGenerator");
        this.genericGenerator.initialize(genericGeneratorResource);
        this.firePropertyChanged("genericGenerators", null, this.genericGenerator);
        return this.genericGenerator;
    }

    private JavaGenericGenerator getGenericGenerator() {
        return this.genericGenerator;
    }

    private void removeGenericGenerator() {
        if (this.getGenericGenerator() == null) {
            throw new IllegalStateException("genericGenerator does not exist, cannot be removed");
        }
        JavaGenericGenerator oldGenericGenerator = this.genericGenerator;
        this.genericGenerator = null;
        this.getResourcePersistentAttribute().removeSupportingAnnotation("org.hibernate.annotations.GenericGenerator");
        this.firePropertyChanged("genericGenerators", oldGenericGenerator, null);
    }

    private void setGenericGenerator(JavaGenericGenerator newGenericGenerator) {
        JavaGenericGenerator oldGenericGenerator = this.genericGenerator;
        this.genericGenerator = newGenericGenerator;
        this.firePropertyChanged("genericGenerators", oldGenericGenerator, newGenericGenerator);
    }

    protected void updateGenericGenerator() {
        GenericGeneratorAnnotation genericGeneratorResource = this.getResourceGenericGenerator();
        if (genericGeneratorResource == null) {
            if (this.getGenericGenerator() != null) {
                this.setGenericGenerator(null);
            }
        } else if (this.getGenericGenerator() == null) {
            this.setGenericGenerator(this.buildGenericGenerator(genericGeneratorResource));
        } else {
            this.getGenericGenerator().update(genericGeneratorResource);
        }
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateGenericGenerator(messages, reporter, astRoot);
    }

    private void validateGenericGenerator(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.genericGenerator != null) {
            this.genericGenerator.validate(messages, reporter, astRoot);
        }
    }

    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.getGenericGenerator() != null && (result = this.getGenericGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        return null;
    }

    public ListIterator<GenericGenerator> genericGenerators() {
        return this.genericGenerator == null ? EmptyListIterator.instance() : new SingleElementListIterator((Object)this.genericGenerator);
    }

    @Override
    public int genericGeneratorsSize() {
        return this.genericGenerator == null ? 0 : 1;
    }

    @Override
    public void moveGenericGenerator(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeGenericGenerator(int index) {
        if (this.genericGeneratorsSize() < index + 1) {
            throw new IndexOutOfBoundsException();
        }
        this.removeGenericGenerator();
    }

    @Override
    public void removeGenericGenerator(GenericGenerator generator) {
        if (this.genericGenerator == generator) {
            this.removeGenericGenerator();
        }
    }

    protected void initializeIndex() {
        IndexAnnotation indexResource = this.getResourceIndex();
        if (indexResource != null) {
            this.index = this.buildIndex(indexResource);
        }
    }

    protected void updateIndex() {
        IndexAnnotation indexResource = this.getResourceIndex();
        if (indexResource == null) {
            if (this.getIndex() != null) {
                this.setIndex(null);
            }
        } else if (this.getIndex() == null) {
            this.setIndex(this.buildIndex(indexResource));
        } else {
            this.getIndex().update(indexResource);
        }
    }

    @Override
    public Index addIndex() {
        if (this.getIndex() != null) {
            throw new IllegalStateException("index already exists");
        }
        this.index = this.getJpaFactory().buildIndex((JavaJpaContextNode)this);
        IndexAnnotation indexResource = (IndexAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation("org.hibernate.annotations.Index");
        this.index.initialize(indexResource);
        this.firePropertyChanged("index", null, this.index);
        return this.index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    protected void setIndex(Index newIndex) {
        Index oldIndex = this.index;
        this.index = newIndex;
        this.firePropertyChanged("index", oldIndex, newIndex);
    }

    @Override
    public void removeIndex() {
        if (this.getIndex() == null) {
            throw new IllegalStateException("index does not exist, cannot be removed");
        }
        Index oldIndex = this.index;
        this.index = null;
        this.getResourcePersistentAttribute().removeSupportingAnnotation("org.hibernate.annotations.Index");
        this.firePropertyChanged("index", oldIndex, null);
    }

    protected Index buildIndex(IndexAnnotation indexResource) {
        Index index = this.getJpaFactory().buildIndex((JavaJpaContextNode)this);
        index.initialize(indexResource);
        return index;
    }

    protected IndexAnnotation getResourceIndex() {
        return (IndexAnnotation)this.getResourcePersistentAttribute().getSupportingAnnotation("org.hibernate.annotations.Index");
    }
}

