/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.GenericJavaJoinColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.NamingStrategyMappingTools;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaJoinColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJavaJoinColumnImpl
extends GenericJavaJoinColumn
implements HibernateJavaJoinColumn {
    public HibernateJavaJoinColumnImpl(JavaJpaContextNode parent, JavaJoinColumn.Owner owner) {
        super(parent, owner);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    protected String buildDefaultName() {
        return NamingStrategyMappingTools.buildJoinColumnDefaultName(this);
    }

    @Override
    public PersistentAttribute getReferencedPersistentAttribute() {
        Iterator attributes;
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (this.getOwner().joinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = this.getOwner().getTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        PersistentAttribute pAttr = null;
        Iterator stream = attributes = targetEntity.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            PersistentAttribute attribute = (PersistentAttribute)stream.next();
            String name = attribute.getPrimaryKeyColumnName();
            if (name == null) continue;
            if (pAttr == null) {
                pAttr = attribute;
                continue;
            }
            return null;
        }
        return pAttr;
    }

    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getDBColumnName());
    }

    @Override
    public String getDBColumnName() {
        return this.getSpecifiedDBColumnName() != null ? this.getSpecifiedDBColumnName() : this.getDefaultDBColumnName();
    }

    @Override
    public String getDefaultDBColumnName() {
        return this.getDefaultName();
    }

    @Override
    public String getSpecifiedDBColumnName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getSpecifiedName();
    }

    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedDBColumnName());
    }

    @Override
    public String getReferencedDBColumnName() {
        return this.getReferencedSpecifiedDBColumnName() != null ? this.getReferencedSpecifiedDBColumnName() : this.getReferencedDefaultDBColumnName();
    }

    @Override
    public String getReferencedDefaultDBColumnName() {
        return this.defaultReferencedColumnName;
    }

    @Override
    public String getReferencedSpecifiedDBColumnName() {
        if (this.specifiedReferencedColumnName == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.specifiedReferencedColumnName);
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.specifiedReferencedColumnName;
    }

    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.isResolved() && this.getDbTable() != null) {
            if (this.getDBColumnName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_UNRESOLVED_NAME", (String[])new String[]{this.getDBColumnName()}, (Object)this, (TextRange)this.getNameTextRange(astRoot)));
            } else if (this.getOwner().joinColumnsSize() > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", (Object)this, (TextRange)this.getNameTextRange(astRoot)));
            }
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.isReferencedColumnResolved() && this.getReferencedColumnDbTable() != null) {
            if (this.getReferencedDBColumnName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", (String[])new String[]{this.getReferencedDBColumnName(), this.getDBColumnName()}, (Object)this, (TextRange)this.getReferencedColumnNameTextRange(astRoot)));
            } else if (this.getOwner().joinColumnsSize() > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", (Object)this, (TextRange)this.getNameTextRange(astRoot)));
            }
        }
    }
}

