/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.hibernate.cfg.NamingStrategy;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateOrmTableImpl
extends GenericOrmTable
implements HibernateOrmTable {
    protected String defaultDBTableName;

    public HibernateOrmTableImpl(OrmEntity parent) {
        super(parent);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public void initialize(XmlEntity xmlEntity) {
        super.initialize(xmlEntity);
        this.defaultDBTableName = this.buildDefaultDBTableName();
    }

    public void update(XmlEntity xmlEntity) {
        super.update(xmlEntity);
        this.setDefaultDBTableName(this.buildDefaultDBTableName());
    }

    public org.eclipse.jpt.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    protected void setDefaultDBTableName(String name) {
        String old = this.defaultDBTableName;
        this.defaultDBTableName = name;
        this.firePropertyChanged("defaultDBName", old, name);
    }

    protected String buildDefaultDBTableName() {
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.classToTableName(this.getDefaultName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getDefaultName();
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName() != null ? this.getSpecifiedDBTableName() : this.getDefaultDBTableName();
    }

    @Override
    public String getDefaultDBTableName() {
        return this.defaultDBTableName;
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        NamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                HibernatePersistenceUnit.LocalMessage m = new HibernatePersistenceUnit.LocalMessage(1, "NAMING_STRATEGY_EXCEPTION", new String[0], null);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                if (t instanceof HibernateTable) {
                    return ((HibernateTable)t).getDBTableName();
                }
                return t.getName();
            }
        };
    }

    protected void validateAgainstDatabase(List<IMessage> messages) {
        if (!this.hasResolvedCatalog()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"TABLE_UNRESOLVED_CATALOG", (String[])new String[]{this.getCatalog(), this.getDBTableName()}, (Object)this, (TextRange)this.getCatalogTextRange()));
            return;
        }
        if (!this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"TABLE_UNRESOLVED_SCHEMA", (String[])new String[]{this.getSchema(), this.getDBTableName()}, (Object)this, (TextRange)this.getSchemaTextRange()));
            return;
        }
        if (!this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage((int)1, (String)"TABLE_UNRESOLVED_NAME", (String[])new String[]{this.getDBTableName()}, (Object)this, (TextRange)this.getNameTextRange()));
            return;
        }
    }
}

