/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.ForeignKeyAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyAnnotationImpl
extends SourceAnnotation<Member>
implements ForeignKeyAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.ForeignKey");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = ForeignKeyAnnotationImpl.buildDeclarationAnnotationAdapter("name");
    private final AnnotationElementAdapter<String> nameAdapter = this.buildElementAdapter(NAME_ADAPTER);
    private String name;
    private static final DeclarationAnnotationElementAdapter<String> INVERSE_NAME_ADAPTER = ForeignKeyAnnotationImpl.buildDeclarationAnnotationAdapter("inverseName");
    private final AnnotationElementAdapter<String> inverseNameAdapter = this.buildElementAdapter(INVERSE_NAME_ADAPTER);
    private String inverseName;

    protected ForeignKeyAnnotationImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.ForeignKey";
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.inverseName = this.buildInverseName(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setInverseName(this.buildInverseName(astRoot));
    }

    @Override
    public String getInverseName() {
        return this.inverseName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String old = this.name;
        this.name = newName;
        this.nameAdapter.setValue((Object)newName);
        this.firePropertyChanged("name", old, newName);
    }

    @Override
    public void setInverseName(String newInverseName) {
        if (this.attributeValueHasNotChanged(this.inverseName, newInverseName)) {
            return;
        }
        String old = this.inverseName;
        this.inverseName = newInverseName;
        this.inverseNameAdapter.setValue((Object)newInverseName);
        this.firePropertyChanged("inverseName", old, newInverseName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    private String buildInverseName(CompilationUnit astRoot) {
        return (String)this.inverseNameAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildDeclarationAnnotationAdapter(String property) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)property, (boolean)true);
    }

    AnnotationElementAdapter<String> buildElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.member, daea);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public TextRange getInverseNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(INVERSE_NAME_ADAPTER, astRoot);
    }

    public static class ForeignKeyAnnotationDefinition
    implements AnnotationDefinition {
        private static final ForeignKeyAnnotationDefinition INSTANCE = new ForeignKeyAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private ForeignKeyAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ForeignKeyAnnotationImpl((JavaResourceNode)parent, member);
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.ForeignKey";
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember arg0, IAnnotation arg1) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent) {
            throw new UnsupportedOperationException();
        }
    }
}

