/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import org.hibernate.MappingException;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.EntityModelDetector;

public class InstrumentationDetector
extends EntityModelDetector {
    private boolean cglibEnabled;
    private boolean javassistEnabled;

    public String getName() {
        return "instrument";
    }

    public void initialize(Configuration cfg, Settings settings) {
        super.initialize(cfg, settings);
        this.cglibEnabled = false;
        this.javassistEnabled = false;
        if (Environment.getBytecodeProvider() instanceof BytecodeProviderImpl) {
            this.cglibEnabled = true;
        } else if (Environment.getBytecodeProvider() instanceof org.hibernate.bytecode.javassist.BytecodeProviderImpl) {
            this.javassistEnabled = true;
        }
    }

    public void visit(Configuration cfg, PersistentClass clazz, IssueCollector collector) {
        Class mappedClass;
        try {
            mappedClass = clazz.getMappedClass();
        }
        catch (MappingException me) {
            return;
        }
        if (clazz.isLazy()) {
            try {
                mappedClass.getConstructor(new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                collector.reportIssue(new Issue("LAZY_NO_DEFAULT_CONSTRUCTOR", 50, "lazy='true' set for '" + clazz.getEntityName() + "', but class has no default constructor."));
                return;
            }
        } else if (this.cglibEnabled || this.javassistEnabled) {
            Class<?>[] interfaces = mappedClass.getInterfaces();
            boolean cglib = false;
            boolean javaassist = false;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intface = interfaces[i];
                if (intface.getName().equals("net.sf.cglib.transform.impl.InterceptFieldEnabled")) {
                    cglib = true;
                    continue;
                }
                if (!intface.getName().equals("org.hibernate.bytecode.javassist.FieldHandled")) continue;
                javaassist = true;
            }
            if (this.cglibEnabled && !cglib) {
                collector.reportIssue(new Issue("LAZY_NOT_INSTRUMENTED", 100, "'" + clazz.getEntityName() + "' has lazy='false', but its class '" + mappedClass.getName() + "' has not been instrumented with cglib"));
                return;
            }
            if (this.javassistEnabled && !javaassist) {
                collector.reportIssue(new Issue("LAZY_NOT_INSTRUMENTED", 100, "'" + clazz.getEntityName() + "' has lazy='false', but its class '" + mappedClass.getName() + "' has not been instrumented with javaassist"));
                return;
            }
        }
    }
}

