/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal.project.facet;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.StateManagerType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.IJBossWebUtil;
import org.jboss.tools.portlet.core.IPortletConstants;
import org.jboss.tools.portlet.core.JBossWebUtil;
import org.jboss.tools.portlet.core.JBossWebUtil25;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.libprov.AbstractLibraryProviderInstallOperationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFPortletFacetInstallDelegate
implements IDelegate {
    private static final String JST_SEAM_FACET = "jst.seam";
    private static final String ORG_JBOSS_PORTLET_STATE_MANAGER = "org.jboss.portletbridge.application.PortletStateManager";
    private static final String ORG_JBOSS_PORTLET_VIEW_HANDLER = "org.jboss.portletbridge.application.PortletViewHandler";

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg == null) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.JSFPortletFacetInstallDelegate_Missing_configuration));
            }
            config = (IDataModel)cfg;
            IModelProvider provider = PortletCoreActivator.getModelProvider(project);
            if (provider == null) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.JSFPortletFacetInstallDelegate_Cannot_configure_web_module_for_JBoss_JSF_Portlet_Facet));
            }
            if (!provider.validateEdit(null, null).isOK() && !provider.validateEdit(null, null).isOK()) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.JSFPortletFacetInstallDelegate_The_web_xml_file_is_not_updateable));
            }
            this.configureFacesConfig(project, monitor, config);
            ((LibraryInstallDelegate)config.getProperty("JSFPORTLET_LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
            this.configureWebApp(project, monitor, config);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void configureFacesConfig(IProject project, IProgressMonitor monitor, IDataModel config) {
        FacesConfigArtifactEdit facesConfigEdit;
        String facesConfigString = this.getFacesConfigFile(project, monitor);
        if (facesConfigString == null || facesConfigString.trim().length() <= 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(facesConfigString, ",");
        ArrayList<String> facesConfigs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            facesConfigs.add(tokenizer.nextToken().trim());
        }
        FacesState state = this.checkState(project, facesConfigs);
        if (state.applicationExists && state.viewHandlerExists && state.stateManagerExists) {
            return;
        }
        if (!state.applicationExists) {
            facesConfigEdit = null;
            try {
                facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)((String)facesConfigs.get(0)));
                FacesConfigType facesConfig = facesConfigEdit.getFacesConfig();
                facesConfig.getApplication();
                ApplicationType application = FacesConfigFactory.eINSTANCE.createApplicationType();
                state.application = application;
                state.facesConfigString = (String)facesConfigs.get(0);
                facesConfig.getApplication().add((Object)application);
                facesConfigEdit.save(monitor);
            }
            finally {
                if (facesConfigEdit != null) {
                    facesConfigEdit.dispose();
                }
            }
        }
        facesConfigEdit = null;
        try {
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)state.facesConfigString);
            facesConfigEdit.getFacesConfig();
            if (!state.viewHandlerExists) {
                ViewHandlerType viewHandler = FacesConfigFactory.eINSTANCE.createViewHandlerType();
                viewHandler.setTextContent(ORG_JBOSS_PORTLET_VIEW_HANDLER);
                state.application.getViewHandler().add((Object)viewHandler);
            }
            if (!state.stateManagerExists) {
                StateManagerType stateManager = FacesConfigFactory.eINSTANCE.createStateManagerType();
                stateManager.setTextContent(ORG_JBOSS_PORTLET_STATE_MANAGER);
                state.application.getStateManager().add((Object)stateManager);
            }
            facesConfigEdit.save(monitor);
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
            }
        }
    }

    private FacesState checkState(IProject project, List<String> facesConfigs) {
        FacesState facesState = new FacesState();
        for (String facesConfigString : facesConfigs) {
            FacesConfigArtifactEdit facesConfigEdit = null;
            try {
                facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)facesConfigString);
                FacesConfigType facesConfig = facesConfigEdit.getFacesConfig();
                EList applications = facesConfig.getApplication();
                if (applications.size() <= 0) continue;
                facesState.applicationExists = true;
                facesState.application = (ApplicationType)applications.get(0);
                facesState.facesConfigString = facesConfigString;
                for (ApplicationType application : applications) {
                    EList viewHandlers = application.getViewHandler();
                    for (ViewHandlerType viewHandler : viewHandlers) {
                        if (!ORG_JBOSS_PORTLET_VIEW_HANDLER.equals(viewHandler.getTextContent())) continue;
                        facesState.viewHandlerExists = true;
                    }
                }
                for (ApplicationType application : applications) {
                    EList stateManagers = application.getStateManager();
                    for (StateManagerType stateManager : stateManagers) {
                        if (!ORG_JBOSS_PORTLET_STATE_MANAGER.equals(stateManager.getTextContent())) continue;
                        facesState.stateManagerExists = true;
                    }
                }
                if (!facesState.applicationExists || !facesState.viewHandlerExists || !facesState.stateManagerExists) continue;
                break;
            }
            finally {
                if (facesConfigEdit != null) {
                    facesConfigEdit.dispose();
                }
            }
        }
        return facesState;
    }

    private String getFacesConfigFile(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = PortletCoreActivator.getModelProvider(project);
        if (this.isWebApp25(provider.getModelObject())) {
            return new JBossWebUtil25().getFacesConfig(project, monitor);
        }
        return new JBossWebUtil().getFacesConfig(project, monitor);
    }

    private void configureWebApp(final IProject project, final IProgressMonitor monitor, final IDataModel config) {
        final IModelProvider provider = PortletCoreActivator.getModelProvider(project);
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (this.isWebApp25(provider.getModelObject()) && !exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        provider.modify(new Runnable(){

            public void run() {
                IJBossWebUtil util = null;
                util = JSFPortletFacetInstallDelegate.this.isWebApp25(provider.getModelObject()) ? new JBossWebUtil25() : new JBossWebUtil();
                if (JSFPortletFacetInstallDelegate.this.addRichfacesLibraries(config, project)) {
                    String name = "org.ajax4jsf.VIEW_HANDLERS";
                    String value = "org.jboss.portletbridge.application.FaceletPortletViewHandler";
                    String description = null;
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "javax.portlet.faces.renderPolicy";
                    value = "ALWAYS_DELEGATE";
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "org.richfaces.LoadStyleStrategy";
                    value = "NONE";
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "org.richfaces.LoadScriptStrategy";
                    value = "NONE";
                    util.configureContextParam(project, monitor, name, value, description);
                    name = "org.ajax4jsf.RESOURCE_URI_PREFIX";
                    value = "rfRes";
                    util.configureContextParam(project, monitor, name, value, description);
                    String displayName = "Ajax4jsf Filter";
                    String filterName = "ajax4jsf";
                    String className = "org.ajax4jsf.Filter";
                    util.configureFilter(project, monitor, filterName, className, displayName, description);
                    String servletName = util.findJsfServlet(provider.getModelObject());
                    if (servletName == null) {
                        RuntimeException e = new RuntimeException(Messages.JSFPortletFacetInstallDelegate_Cannot_find_the_JSF_servlet);
                        PortletCoreActivator.log(e);
                        throw e;
                    }
                    util.configureFilterMapping(project, monitor, filterName, servletName);
                } else {
                    String name = "javax.portlet.faces.renderPolicy";
                    String value = "NEVER_DELEGATE";
                    String description = null;
                    util.configureContextParam(project, monitor, name, value, description);
                }
            }
        }, modelPath);
    }

    private boolean addRichfacesLibraries(IDataModel config, IProject project) {
        ILibraryProvider libraryProvider;
        String providerId;
        LibraryInstallDelegate libraryDelegate = (LibraryInstallDelegate)config.getProperty("JSFPORTLET_LIBRARY_PROVIDER_DELEGATE");
        if (libraryDelegate != null && ("jsfportletbridge-library-provider".equals(providerId = (libraryProvider = libraryDelegate.getLibraryProvider()).getId()) || "jsfportlet-library-provider".equals(providerId))) {
            AbstractLibraryProviderInstallOperationConfig libraryConfig = (AbstractLibraryProviderInstallOperationConfig)libraryDelegate.getLibraryProviderOperationConfig(libraryProvider);
            boolean isSeamFacet = false;
            try {
                isSeamFacet = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)JST_SEAM_FACET);
            }
            catch (CoreException e) {
                PortletCoreActivator.log(e);
            }
            if (isSeamFacet) {
                return true;
            }
            if (libraryConfig.isAddRichfacesCapabilities()) {
                return true;
            }
        }
        return false;
    }

    private void configureClassPath(IProject project, IProgressMonitor monitor, IDataModel config) throws JavaModelException {
        String implementationLibrary = config.getStringProperty("implementationLibrary");
        if (IPortletConstants.LIBRARIES_PROVIDED_BY_PORTLETBRIDGE.equals(implementationLibrary)) {
            this.addLibrariesFromPortletBridgeRuntime(project, monitor, config);
        } else if (IPortletConstants.LIBRARIES_PROVIDED_BY_SERVER_RUNTIME.equals(implementationLibrary)) {
            this.addLibrariesFromServerRuntime(project, monitor, config);
        } else if (IPortletConstants.USER_LIBRARY.equals(implementationLibrary)) {
            this.addUserLibrary(project, monitor, config);
        }
    }

    private void addUserLibrary(IProject project, IProgressMonitor monitor, IDataModel config) throws JavaModelException {
        String userLibraryName = config.getStringProperty("userLibraryName");
        IPath containerPath = new Path("org.eclipse.jdt.USER_LIBRARY").append(userLibraryName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathAttribute dependencyAttribute = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
        IClasspathEntry[] oldClasspathEntries = javaProject.getRawClasspath();
        IClasspathEntry[] newClasspathEntries = null;
        int i = 0;
        while (i < oldClasspathEntries.length) {
            IClasspathEntry entry = oldClasspathEntries[i];
            if (entry.getEntryKind() == 5 && containerPath.equals((Object)entry.getPath())) {
                LinkedHashMap<String, IClasspathAttribute> attrs = new LinkedHashMap<String, IClasspathAttribute>();
                IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
                int n = iClasspathAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathAttribute attr = iClasspathAttributeArray[n2];
                    attrs.put(attr.getName(), attr);
                    ++n2;
                }
                attrs.put(dependencyAttribute.getName(), dependencyAttribute);
                IClasspathAttribute[] newAttrs = attrs.values().toArray(new IClasspathAttribute[attrs.size()]);
                oldClasspathEntries[i] = entry = JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttrs, (boolean)entry.isExported());
                newClasspathEntries = oldClasspathEntries;
                break;
            }
            ++i;
        }
        if (newClasspathEntries == null) {
            IClasspathEntry newClasspath;
            newClasspathEntries = new IClasspathEntry[oldClasspathEntries.length + 1];
            i = 0;
            while (i < oldClasspathEntries.length) {
                newClasspathEntries[i] = oldClasspathEntries[i];
                ++i;
            }
            newClasspathEntries[oldClasspathEntries.length] = newClasspath = JavaCore.newContainerEntry((IPath)containerPath, null, (IClasspathAttribute[])new IClasspathAttribute[]{dependencyAttribute}, (boolean)true);
        }
        javaProject.setRawClasspath(newClasspathEntries, monitor);
    }

    private void addLibrariesFromServerRuntime(IProject project, IProgressMonitor monitor, IDataModel config) {
        IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)config.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = fpwc.getPrimaryRuntime();
        IRuntime runtime = PortletCoreActivator.getRuntime(facetRuntime);
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            IPath portletLib = configPath.append("deploy/jboss-portal.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
            File portletLibFile = portletLib.toFile();
            String[] files = this.getPortletbridgeLibraries(portletLibFile);
            if (files == null) {
                portletLib = configPath.append("deploy/jboss-portal-ha.sar/portal-identity.sar/portal-identity.war/WEB-INF/lib");
                portletLibFile = portletLib.toFile();
                files = this.getPortletbridgeLibraries(portletLibFile);
            }
            if (files != null) {
                try {
                    ArrayList<File> filesToImport = new ArrayList<File>();
                    int i = 0;
                    while (i < files.length) {
                        filesToImport.add(new File(portletLibFile, files[i]));
                        ++i;
                    }
                    IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                    IVirtualFile libVirtualFile = component.getRootFolder().getFile("WEB-INF/lib");
                    IFile folder = libVirtualFile.getUnderlyingFile();
                    File sourceFolder = new File(portletLib.toOSString());
                    ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)sourceFolder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                    importOperation.setCreateContainerStructure(false);
                    importOperation.run(monitor);
                }
                catch (Exception e) {
                    PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
                }
            }
        }
    }

    private String[] getPortletbridgeLibraries(File file) {
        if (file != null && file.isDirectory()) {
            String[] list = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return "portletbridge-api.jar".equals(name) || "portletbridge-impl.jar".equals(name);
                }
            });
            return list;
        }
        return null;
    }

    private void addLibrariesFromPortletBridgeRuntime(IProject project, IProgressMonitor monitor, IDataModel config) {
        try {
            File pbFolder;
            String pbRuntime = config.getStringProperty("PORTLET_BRIDGE_RUNTIME");
            if (pbRuntime != null && pbRuntime.trim().length() > 0 && (pbFolder = new File(pbRuntime = pbRuntime.trim())).exists() && pbFolder.isDirectory()) {
                String[] fileList = pbFolder.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("portletbridge") || name.endsWith(".jar");
                    }
                });
                ArrayList<File> filesToImport = new ArrayList<File>();
                int i = 0;
                while (i < fileList.length) {
                    filesToImport.add(new File(pbRuntime, fileList[i]));
                    ++i;
                }
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualFile libVirtualFile = component.getRootFolder().getFile("WEB-INF/lib");
                IFile folder = libVirtualFile.getUnderlyingFile();
                ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)pbFolder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
                importOperation.setCreateContainerStructure(false);
                importOperation.run(monitor);
            }
        }
        catch (Exception e) {
            PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
        }
    }

    private boolean isWebApp25(Object webApp) {
        return webApp instanceof WebApp && ((WebApp)webApp).getVersion() == WebAppVersionType._25_LITERAL;
    }

    private class FacesState {
        private boolean applicationExists = false;
        private boolean viewHandlerExists = false;
        private boolean stateManagerExists = false;
        private ApplicationType application = null;
        private String facesConfigString = null;

        private FacesState() {
        }
    }
}

