/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.operations;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaEEArtifactClassOperation;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.jboss.tools.portlet.core.JBossWebUtil;
import org.jboss.tools.portlet.core.JBossWebUtil25;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.operations.NewPortletClassOperation;
import org.jboss.tools.portlet.ui.PortletUIActivator;
import org.jboss.tools.portlet.ui.internal.wizard.action.xpl.AddWebClassOperationEx;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AddPortletOperation
extends AddWebClassOperationEx {
    public static final IOverwriteQuery OVERWRITE_NO_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "NOALL";
        }
    };

    public AddPortletOperation(IDataModel dataModel) {
        super(dataModel);
    }

    protected NewJavaEEArtifactClassOperation getNewClassOperation() {
        boolean isJSFPortlet = this.model.getBooleanProperty("NewPortletClassDataModel.IS_JSF_PORTLET");
        boolean isSeamPortlet = this.model.getBooleanProperty("NewPortletClassDataModel.IS_SEAM_PORTLET");
        if (!isJSFPortlet && !isSeamPortlet) {
            return new NewPortletClassOperation(this.getDataModel());
        }
        NewJavaEEArtifactClassOperation op = new NewJavaEEArtifactClassOperation(this.getDataModel()){

            protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
            }

            public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }
        };
        return op;
    }

    protected void generateMetaData(IDataModel aModel, String qualifiedClassName) {
        boolean configureGateIn;
        boolean copyJSFTemplates;
        boolean isPortletProject = PortletUIActivator.isPortletProject(aModel);
        if (!isPortletProject) {
            return;
        }
        this.updatePortletXml(aModel);
        boolean addPortlet = this.model.getBooleanProperty("NewPortletClassDataModel.ADD_PORTLET");
        if (addPortlet) {
            this.updatePortletInstance(aModel);
            this.updatePortletObject(aModel);
        }
        boolean isJSFPortlet = this.model.getBooleanProperty("NewPortletClassDataModel.IS_JSF_PORTLET");
        boolean isSeamPortlet = this.model.getBooleanProperty("NewPortletClassDataModel.IS_SEAM_PORTLET");
        if (!isJSFPortlet && !isSeamPortlet) {
            return;
        }
        if (addPortlet) {
            boolean addJBossPortlet;
            boolean addJBossApp = this.model.getBooleanProperty("NewPortletClassDataModel.ADD_JBOSS_APP");
            if (addJBossApp) {
                this.updateJBossApp(aModel);
            }
            if (addJBossPortlet = this.model.getBooleanProperty("NewPortletClassDataModel.ADD_JBOSS_PORTLET")) {
                this.updateJBossPortlet(aModel);
            }
        }
        if (copyJSFTemplates = this.model.getBooleanProperty("NewPortletClassDataModel.COPY_JSF_TEMPLATES")) {
            try {
                this.copyJSFTemplates(aModel);
            }
            catch (Exception e) {
                PortletUIActivator.log(e);
            }
        }
        if (configureGateIn = this.model.getBooleanProperty("NewPortletClassDataModel.CONFIGURE_GATEIN_PARAMETERS")) {
            this.configureGateInParameters(aModel);
        }
    }

    private void configureGateInParameters(IDataModel aModel) {
        final IProject project = this.getTargetProject();
        final IModelProvider provider = PortletCoreActivator.getModelProvider((IProject)project);
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (this.isWebApp25(provider.getModelObject()) && !exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        provider.modify(new Runnable(){

            public void run() {
                Object util = null;
                util = AddPortletOperation.this.isWebApp25(provider.getModelObject()) ? new JBossWebUtil25() : new JBossWebUtil();
                String name = "org.jboss.portletbridge.WRAP_SCRIPTS";
                String value = "true";
                String description = null;
                util.configureContextParam(project, (IProgressMonitor)new NullProgressMonitor(), name, value, description);
            }
        }, modelPath);
    }

    private boolean isWebApp25(Object webApp) {
        return webApp instanceof WebApp && ((WebApp)webApp).getVersion() == WebAppVersionType._25_LITERAL;
    }

    private void updateJBossPortlet(IDataModel model) {
        IFile portletFile;
        block13: {
            IProject project = this.getTargetProject();
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFile portletVirtualFile = component.getRootFolder().getFile("WEB-INF/jboss-portlet.xml");
            if (!portletVirtualFile.getUnderlyingFile().exists()) {
                try {
                    PortletCoreActivator.createJBossPortlet((IProject)project, (IFile)portletVirtualFile.getUnderlyingFile());
                }
                catch (Exception e) {
                    PortletCoreActivator.log((Throwable)e);
                    return;
                }
            }
            portletFile = portletVirtualFile.getUnderlyingFile();
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(portletFile);
                    IDOMDocument document = domModel.getDocument();
                    Element element = document.getDocumentElement();
                    String name = model.getStringProperty("NewPortletClassDataModel.NAME");
                    Element portlet = this.addNode((Document)document, element, "portlet", null);
                    this.addNode((Document)document, portlet, "portlet-name", name);
                    this.addNode((Document)document, portlet, "header-content", null);
                    domModel.save();
                }
                catch (Exception e) {
                    PortletCoreActivator.getDefault();
                    PortletCoreActivator.log((Throwable)e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
                throw throwable;
            }
            if (domModel != null) {
                domModel.releaseFromEdit();
            }
        }
        try {
            new FormatProcessorXML().formatFile(portletFile);
        }
        catch (Exception exception) {}
    }

    private void copyJSFTemplates(IDataModel model) throws Exception {
        IProject project = this.getTargetProject();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder jsfFolder = component.getRootFolder().getFolder("jsf");
        if (!jsfFolder.exists()) {
            jsfFolder.create(1, (IProgressMonitor)new NullProgressMonitor());
        }
        IContainer folder = jsfFolder.getUnderlyingFolder();
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.portlet.ui");
        URL jsfURL = bundle.getEntry("/resources/jsf");
        String jsfFolderName = FileLocator.toFileURL((URL)jsfURL).getFile();
        File source = new File(jsfFolderName);
        File[] files = source.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        List<File> filesToImport = Arrays.asList(files);
        ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)source, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_NO_QUERY, filesToImport);
        importOperation.setCreateContainerStructure(false);
        NullProgressMonitor monitor = new NullProgressMonitor();
        importOperation.run((IProgressMonitor)monitor);
    }

    private void updateJBossApp(IDataModel model) {
        IFile portletFile;
        block14: {
            IProject project = this.getTargetProject();
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFile portletVirtualFile = component.getRootFolder().getFile("WEB-INF/jboss-app.xml");
            if (!portletVirtualFile.getUnderlyingFile().exists()) {
                try {
                    PortletCoreActivator.createJBossApp((IProject)project, (IFile)portletVirtualFile.getUnderlyingFile());
                }
                catch (Exception e) {
                    PortletCoreActivator.log((Throwable)e);
                    return;
                }
            }
            portletFile = portletVirtualFile.getUnderlyingFile();
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(portletFile);
                    IDOMDocument document = domModel.getDocument();
                    Element element = document.getDocumentElement();
                    NodeList appNameNodes = element.getElementsByTagName("app-name");
                    if (appNameNodes.getLength() <= 0) {
                        String appName = model.getStringProperty("NewPortletClassDataModel.JBOSS_APP");
                        this.addNode((Document)document, element, "app-name", appName);
                        domModel.save();
                    }
                }
                catch (Exception e) {
                    PortletCoreActivator.getDefault();
                    PortletCoreActivator.log((Throwable)e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
                throw throwable;
            }
            if (domModel != null) {
                domModel.releaseFromEdit();
            }
        }
        try {
            new FormatProcessorXML().formatFile(portletFile);
        }
        catch (Exception exception) {}
    }

    private void updatePortletObject(IDataModel model) {
        IFile portletFile;
        block15: {
            String instanceId = model.getStringProperty("NewPortletClassDataModel.INSTANCE_NAME");
            String windowName = model.getStringProperty("NewPortletClassDataModel.WINDOW_NAME");
            String pageName = model.getStringProperty("NewPortletClassDataModel.PAGE_NAME");
            String ifExists = model.getStringProperty("NewPortletClassDataModel.IF_EXISTS");
            String parent = model.getStringProperty("NewPortletClassDataModel.PARENT_PORTAL");
            String region = model.getStringProperty("NewPortletClassDataModel.PAGE_REGION");
            String height = model.getStringProperty("NewPortletClassDataModel.PORTLET_HEIGHT");
            String initialWindowState = model.getStringProperty("NewPortletClassDataModel.INITIAL_WINDOW_STATE");
            IProject project = this.getTargetProject();
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFile portletVirtualFile = component.getRootFolder().getFile("WEB-INF/default-object.xml");
            if (!portletVirtualFile.getUnderlyingFile().exists()) {
                try {
                    PortletCoreActivator.createPortletObject((IProject)project, (IFile)portletVirtualFile.getUnderlyingFile());
                }
                catch (Exception e) {
                    PortletCoreActivator.log((Throwable)e);
                    return;
                }
            }
            portletFile = portletVirtualFile.getUnderlyingFile();
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(portletFile);
                    IDOMDocument document = domModel.getDocument();
                    Element element = document.getDocumentElement();
                    Element deployment = document.createElement("deployment");
                    element.appendChild(deployment);
                    this.addNode((Document)document, deployment, "parent-ref", parent);
                    this.addNode((Document)document, deployment, "if-exists", ifExists);
                    Element page = null;
                    if (pageName != null && pageName.trim().length() > 0) {
                        page = this.addNode((Document)document, deployment, "page", null);
                        this.addNode((Document)document, page, "page-name", pageName);
                    } else {
                        page = deployment;
                    }
                    Element window = this.addNode((Document)document, page, "window", null);
                    this.addNode((Document)document, window, "window-name", windowName);
                    this.addNode((Document)document, window, "instance-ref", instanceId);
                    this.addNode((Document)document, window, "region", region);
                    this.addNode((Document)document, window, "height", height);
                    this.addNode((Document)document, window, "initial-window-state", initialWindowState);
                    domModel.save();
                }
                catch (Exception e) {
                    PortletCoreActivator.getDefault();
                    PortletCoreActivator.log((Throwable)e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
                throw throwable;
            }
            if (domModel != null) {
                domModel.releaseFromEdit();
            }
        }
        try {
            new FormatProcessorXML().formatFile(portletFile);
        }
        catch (Exception exception) {}
    }

    private void updatePortletInstance(IDataModel model) {
        IFile portletFile;
        block13: {
            String name = model.getStringProperty("NewPortletClassDataModel.NAME");
            String instanceId = model.getStringProperty("NewPortletClassDataModel.INSTANCE_NAME");
            IProject project = this.getTargetProject();
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFile portletVirtualFile = component.getRootFolder().getFile("WEB-INF/portlet-instances.xml");
            if (!portletVirtualFile.getUnderlyingFile().exists()) {
                try {
                    PortletCoreActivator.createPortletInstances((IProject)project, (IFile)portletVirtualFile.getUnderlyingFile());
                }
                catch (Exception e) {
                    PortletCoreActivator.log((Throwable)e);
                    return;
                }
            }
            portletFile = portletVirtualFile.getUnderlyingFile();
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(portletFile);
                    IDOMDocument document = domModel.getDocument();
                    Element element = document.getDocumentElement();
                    Element deployment = document.createElement("deployment");
                    element.appendChild(deployment);
                    Element instance = this.addNode((Document)document, deployment, "instance", null);
                    this.addNode((Document)document, instance, "instance-id", instanceId);
                    this.addNode((Document)document, instance, "portlet-ref", name);
                    domModel.save();
                }
                catch (Exception e) {
                    PortletCoreActivator.getDefault();
                    PortletCoreActivator.log((Throwable)e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
                throw throwable;
            }
            if (domModel != null) {
                domModel.releaseFromEdit();
            }
        }
        try {
            new FormatProcessorXML().formatFile(portletFile);
        }
        catch (Exception exception) {}
    }

    private void updatePortletXml(IDataModel aModel) {
        IFile portletFile;
        block18: {
            String displayName = aModel.getStringProperty("NewServletClassDataModel.DISPLAY_NAME");
            String name = aModel.getStringProperty("NewPortletClassDataModel.NAME");
            String title = aModel.getStringProperty("NewPortletClassDataModel.TITLE");
            String description = aModel.getStringProperty("NewServletClassDataModel.DESCRIPTION");
            String className = aModel.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject project = this.getTargetProject();
            portletFile = PortletUIActivator.getPortletXmlFile(project);
            if (portletFile == null) {
                return;
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(portletFile);
                    IDOMDocument document = domModel.getDocument();
                    Element element = document.getDocumentElement();
                    Element portlet = document.createElement("portlet");
                    element.appendChild(portlet);
                    if (description != null && description.trim().length() > 0) {
                        this.addNode((Document)document, portlet, "description", description);
                    }
                    this.addNode((Document)document, portlet, "portlet-name", name);
                    if (displayName != null && displayName.trim().length() > 0) {
                        this.addNode((Document)document, portlet, "display-name", displayName);
                    }
                    this.addNode((Document)document, portlet, "portlet-class", className);
                    List initParamList = (List)aModel.getProperty("NewServletClassDataModel.INIT_PARAM");
                    if (initParamList != null) {
                        for (String[] arrayString : initParamList) {
                            Element initParam = this.addNode((Document)document, portlet, "init-param", null);
                            this.addNode((Document)document, initParam, "name", arrayString[0]);
                            this.addNode((Document)document, initParam, "value", arrayString[1]);
                            if (arrayString[2] == null || arrayString[2].length() <= 0) continue;
                            this.addNode((Document)document, initParam, "description", arrayString[2]);
                        }
                    }
                    Element supports = this.addNode((Document)document, portlet, "supports", null);
                    this.addNode((Document)document, supports, "mime-type", "text/html");
                    if (aModel.getBooleanProperty("NewPortletClassDataModel.VIEW_MODE")) {
                        this.addNode((Document)document, supports, "portlet-mode", "VIEW");
                    }
                    if (aModel.getBooleanProperty("NewPortletClassDataModel.EDIT_MODE")) {
                        this.addNode((Document)document, supports, "portlet-mode", "EDIT");
                    }
                    if (aModel.getBooleanProperty("NewPortletClassDataModel.HELP_MODE")) {
                        this.addNode((Document)document, supports, "portlet-mode", "HELP");
                    }
                    Element portletInfo = this.addNode((Document)document, portlet, "portlet-info", null);
                    this.addNode((Document)document, portletInfo, "title", title);
                    domModel.save();
                }
                catch (Exception e) {
                    PortletCoreActivator.getDefault();
                    PortletCoreActivator.log((Throwable)e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
                throw throwable;
            }
            if (domModel != null) {
                domModel.releaseFromEdit();
            }
        }
        try {
            new FormatProcessorXML().formatFile(portletFile);
        }
        catch (Exception exception) {}
    }

    private Element addNode(Document document, Element element, String tagName, String value) {
        Element node = document.createElement(tagName);
        if (value != null) {
            Text text = document.createTextNode(value);
            node.appendChild(text);
        }
        element.appendChild(node);
        return node;
    }
}

