/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.ui.internal.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.jboss.tools.portlet.ui.IPortletUIConstants;
import org.jboss.tools.portlet.ui.PortletUIActivator;

public class AddJBossPortletWizardPage
extends DataModelWizardPage {
    private Combo ifExistsCombo;
    private Text instanceNameText;
    private Text pageNameText;
    private Text windowNameText;
    private Text parentReferenceText;
    private Text regionText;
    private Text heightText;
    private Combo initialWindowStateCombo;
    private Button addPortlet;

    public AddJBossPortletWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IPortletUIConstants.ADD_JBOSS_PORTLET_WIZARD_PAGE_DESC);
        this.setTitle(IPortletUIConstants.ADD_JBOSS_PORTLET_WIZARD_PAGE_TITLE);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"NewPortletClassDataModel.INSTANCE_NAME", "NewPortletClassDataModel.WINDOW_NAME"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.createComponents(composite);
        IStatus projectStatus = this.validateProjectName();
        if (!projectStatus.isOK()) {
            this.setErrorMessage(projectStatus.getMessage());
            composite.setEnabled(false);
        }
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected IStatus validateProjectName() {
        if (this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME") == null || this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").trim().length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)IWebWizardConstants.NO_WEB_PROJECTS);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected void createComponents(Composite parent) {
        GridData gd;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        boolean isJBossPortal = PortletUIActivator.isJBossPortalRuntime(this.model);
        this.model.setBooleanProperty("NewPortletClassDataModel.ADD_PORTLET", isJBossPortal);
        boolean isGateIn = PortletUIActivator.isGateIn(this.model);
        if (isGateIn) {
            this.model.setBooleanProperty("NewPortletClassDataModel.ADD_JBOSS_APP", false);
            this.model.setBooleanProperty("NewPortletClassDataModel.ADD_JBOSS_PORTLET", false);
        }
        if (isJBossPortal) {
            this.addPortlet = new Button(composite, 32);
            this.addPortlet.setText(IPortletUIConstants.ADD_PORTLET_LABEL);
            gd = new GridData(32);
            gd.horizontalSpan = 2;
            this.addPortlet.setLayoutData((Object)gd);
            this.synchHelper.synchCheckbox(this.addPortlet, "NewPortletClassDataModel.ADD_PORTLET", null);
            Label ifExistsLabel = new Label(composite, 16384);
            ifExistsLabel.setText(IPortletUIConstants.IF_EXISTS_LABEL);
            ifExistsLabel.setLayoutData((Object)new GridData(32));
            this.ifExistsCombo = new Combo(composite, 8);
            this.ifExistsCombo.setLayoutData((Object)new GridData(768));
            this.ifExistsCombo.setItems(new String[]{"overwrite", "keep"});
            this.synchHelper.synchCombo(this.ifExistsCombo, "NewPortletClassDataModel.IF_EXISTS", null);
            Label instanceNameLabel = new Label(composite, 16384);
            instanceNameLabel.setText(IPortletUIConstants.INSTANCE_NAME_LABEL);
            instanceNameLabel.setLayoutData((Object)new GridData(32));
            this.instanceNameText = new Text(composite, 2052);
            this.instanceNameText.setLayoutData((Object)new GridData(768));
            this.synchHelper.synchText(this.instanceNameText, "NewPortletClassDataModel.INSTANCE_NAME", null);
            Label pageNameLabel = new Label(composite, 16384);
            pageNameLabel.setText(IPortletUIConstants.PAGE_NAME_LABEL);
            pageNameLabel.setLayoutData((Object)new GridData(32));
            this.pageNameText = new Text(composite, 2052);
            this.pageNameText.setLayoutData((Object)new GridData(768));
            this.synchHelper.synchText(this.pageNameText, "NewPortletClassDataModel.PAGE_NAME", null);
            Label windowNameLabel = new Label(composite, 16384);
            windowNameLabel.setText(IPortletUIConstants.WINDOW_NAME_LABEL);
            windowNameLabel.setLayoutData((Object)new GridData(32));
            this.windowNameText = new Text(composite, 2052);
            this.windowNameText.setLayoutData((Object)new GridData(768));
            this.synchHelper.synchText(this.windowNameText, "NewPortletClassDataModel.WINDOW_NAME", null);
            Label parentReferenceLabel = new Label(composite, 16384);
            parentReferenceLabel.setText(IPortletUIConstants.PARENT_PORTAL_LABEL);
            parentReferenceLabel.setLayoutData((Object)new GridData(32));
            this.parentReferenceText = new Text(composite, 2052);
            this.parentReferenceText.setLayoutData((Object)new GridData(768));
            this.synchHelper.synchText(this.parentReferenceText, "NewPortletClassDataModel.PARENT_PORTAL", null);
            Label regionLabel = new Label(composite, 16384);
            regionLabel.setText(IPortletUIConstants.PAGE_REGION_LABEL);
            regionLabel.setLayoutData((Object)new GridData(32));
            this.regionText = new Text(composite, 2052);
            this.regionText.setLayoutData((Object)new GridData(768));
            this.synchHelper.synchText(this.regionText, "NewPortletClassDataModel.PAGE_REGION", null);
            Label heightLabel = new Label(composite, 16384);
            heightLabel.setText(IPortletUIConstants.PORTLET_HEIGHT_LABEL);
            heightLabel.setLayoutData((Object)new GridData(32));
            this.heightText = new Text(composite, 2052);
            this.heightText.setLayoutData((Object)new GridData(768));
            this.synchHelper.synchText(this.heightText, "NewPortletClassDataModel.PORTLET_HEIGHT", null);
            Label initialWindowStateLabel = new Label(composite, 16384);
            initialWindowStateLabel.setText(IPortletUIConstants.INITIAL_WINDOW_STATE_LABEL);
            initialWindowStateLabel.setLayoutData((Object)new GridData(32));
            this.initialWindowStateCombo = new Combo(composite, 8);
            this.initialWindowStateCombo.setLayoutData((Object)new GridData(768));
            this.initialWindowStateCombo.setItems(new String[]{"maximized", "minimized", "normal"});
            this.synchHelper.synchCombo(this.initialWindowStateCombo, "NewPortletClassDataModel.INITIAL_WINDOW_STATE", null);
            this.addPortlet.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddJBossPortletWizardPage.this.enableJBossProperties();
                }
            });
            this.enableJBossProperties();
            if (this.isJSFPortlet() || this.isSeamPortlet()) {
                final Button addJBossApp = new Button(composite, 32);
                addJBossApp.setText(IPortletUIConstants.ADD_JBOSS_APP_LABEL);
                gd = new GridData(32);
                gd.horizontalSpan = 2;
                addJBossApp.setLayoutData((Object)gd);
                this.synchHelper.synchCheckbox(addJBossApp, "NewPortletClassDataModel.ADD_JBOSS_APP", null);
                Label jbossAppLabel = new Label(composite, 16384);
                jbossAppLabel.setText(IPortletUIConstants.JBOSS_APP_LABEL);
                jbossAppLabel.setLayoutData((Object)new GridData(32));
                final Text jbossAppText = new Text(composite, 2052);
                jbossAppText.setLayoutData((Object)new GridData(768));
                this.synchHelper.synchText(jbossAppText, "NewPortletClassDataModel.JBOSS_APP", null);
                addJBossApp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean enable = addJBossApp.getSelection();
                        jbossAppText.setEnabled(enable);
                    }
                });
                addJBossApp.setSelection(isJBossPortal);
                jbossAppText.setEnabled(addJBossApp.getSelection());
                Button addJBossPortlet = new Button(composite, 32);
                addJBossPortlet.setText(IPortletUIConstants.ADD_JBOSS_PORTLET_LABEL);
                gd = new GridData(32);
                gd.horizontalSpan = 2;
                addJBossPortlet.setLayoutData((Object)gd);
                this.synchHelper.synchCheckbox(addJBossPortlet, "NewPortletClassDataModel.ADD_JBOSS_PORTLET", null);
            }
        }
        Button copyJSFTemplates = new Button(composite, 32);
        copyJSFTemplates.setText(IPortletUIConstants.COPY_JSF_TEMPLATES_LABEL);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        copyJSFTemplates.setLayoutData((Object)gd);
        this.synchHelper.synchCheckbox(copyJSFTemplates, "NewPortletClassDataModel.COPY_JSF_TEMPLATES", null);
        this.model.setBooleanProperty("NewPortletClassDataModel.CONFIGURE_GATEIN_PARAMETERS", isGateIn);
        Button configureGateIn = new Button(composite, 32);
        configureGateIn.setText("Configure GateIn parameters");
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        configureGateIn.setLayoutData((Object)gd);
        this.synchHelper.synchCheckbox(configureGateIn, "NewPortletClassDataModel.CONFIGURE_GATEIN_PARAMETERS", null);
    }

    public boolean canFlipToNextPage() {
        if (this.model.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    protected boolean isJSFPortlet() {
        return this.model.getBooleanProperty("NewPortletClassDataModel.IS_JSF_PORTLET");
    }

    protected boolean isSeamPortlet() {
        return this.model.getBooleanProperty("NewPortletClassDataModel.IS_SEAM_PORTLET");
    }

    private void enableJBossProperties() {
        boolean enable = this.addPortlet.getSelection();
        this.ifExistsCombo.setEnabled(enable);
        this.instanceNameText.setEnabled(enable);
        this.windowNameText.setEnabled(enable);
        this.parentReferenceText.setEnabled(enable);
        this.regionText.setEnabled(enable);
        this.heightText.setEnabled(enable);
        this.initialWindowStateCombo.setEnabled(enable);
        this.pageNameText.setEnabled(enable);
    }
}

