/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.ui.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.NameValuePair;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryInputModel;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.utils.QLFormatHelper;
import org.hibernate.eclipse.console.viewers.xpl.MTreeViewer;
import org.hibernate.eclipse.console.views.KnownConfigurationsProvider;
import org.hibernate.eclipse.console.workbench.LazySessionFactory;
import org.hibernate.eclipse.console.workbench.xpl.AnyAdaptableLabelProvider;
import org.hibernate.eclipse.hqleditor.HQLEditorDocumentSetupParticipant;
import org.hibernate.eclipse.hqleditor.HQLSourceViewerConfiguration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.type.Type;
import org.jboss.tools.birt.oda.impl.HibernateDriver;
import org.jboss.tools.birt.oda.ui.Activator;
import org.jboss.tools.birt.oda.ui.Messages;
import org.jboss.tools.birt.oda.ui.impl.HibernateDSDragSource;
import org.jboss.tools.birt.oda.ui.impl.HibernateDSDropSource;
import org.jboss.tools.birt.oda.ui.impl.TextMenuManager;

public class CustomDataSetWizardPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = Messages.CustomDataSetWizardPage_Define_the_query_text_for_the_data_set;
    private StyledText styledText;
    private SourceViewer sourceViewer;
    private IHandlerService fService;
    private IHandlerActivation fActivation;
    private TreeViewer viewer;
    private Button testButton;

    public CustomDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public CustomDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.validateData();
        this.setMessage(DEFAULT_MESSAGE);
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Control left = this.createTableSelectionComposite(composite);
        GridData gridData = (GridData)left.getLayoutData();
        gridData.widthHint = 160;
        Sash sash = this.createSash(composite);
        Control right = this.createQueryComposite(composite);
        this.addDragListerner(sash, composite, left, right);
        this.initDragAndDrop();
        return composite;
    }

    private void initDragAndDrop() {
        new HibernateDSDragSource(this.viewer);
        new HibernateDSDropSource(this.sourceViewer);
    }

    private void addDragListerner(Sash sash, Composite parent, final Control left, final Control right) {
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    return;
                }
                Sash sash = (Sash)event.widget;
                int shift = event.x - sash.getBounds().x;
                left.setSize(left.getSize().x + shift, left.getSize().y);
                right.setSize(right.getSize().x - shift, right.getSize().y);
                right.setLocation(right.getLocation().x + shift, right.getLocation().y);
                sash.setLocation(sash.getLocation().x + shift, sash.getLocation().y);
            }
        });
    }

    private Control createQueryComposite(Composite parent) {
        Composite composite = new Composite(parent, 0x2000004);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn lineNumbers = new LineNumberRulerColumn();
        ruler.addDecorator(0, (IVerticalRulerColumn)lineNumbers);
        this.sourceViewer = new SourceViewer(composite, (IVerticalRuler)ruler, 2816);
        this.sourceViewer.setInput((Object)parent);
        this.styledText = this.sourceViewer.getTextWidget();
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomDataSetWizardPage.this.validateData();
            }
        });
        this.styledText.setFont(JFaceResources.getTextFont());
        Control control = this.sourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        Document document = new Document();
        document.set(this.getInitialQueryString());
        HQLEditorDocumentSetupParticipant docSetupParticipant = new HQLEditorDocumentSetupParticipant();
        docSetupParticipant.setup((IDocument)document);
        this.sourceViewer.setEditable(true);
        this.sourceViewer.setDocument((IDocument)document);
        TextViewerUndoManager undoManager = new TextViewerUndoManager(10);
        this.sourceViewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.sourceViewer);
        this.attachMenus(this.sourceViewer);
        this.sourceViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    CustomDataSetWizardPage.this.sourceViewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    CustomDataSetWizardPage.this.sourceViewer.doOperation(2);
                }
                CustomDataSetWizardPage.this.validateData();
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CustomDataSetWizardPage.this.sourceViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.fService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
        this.fActivation = this.fService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
        QueryEditor editor = new QueryEditor(){

            public boolean askUserForConfiguration(String name) {
                return false;
            }

            public void executeQuery(ConsoleConfiguration cfg) {
            }

            public ConsoleConfiguration getConsoleConfiguration() {
                return CustomDataSetWizardPage.this.getInternalConsoleConfiguration();
            }

            public String getConsoleConfigurationName() {
                return CustomDataSetWizardPage.this.getConfigurationName();
            }

            public QueryInputModel getQueryInputModel() {
                return null;
            }

            public String getQueryString() {
                return null;
            }

            public void setConsoleConfigurationName(String text) {
            }
        };
        HQLSourceViewerConfiguration svc = new HQLSourceViewerConfiguration(editor);
        this.sourceViewer.configure((SourceViewerConfiguration)svc);
        this.testButton = new Button(composite, 0);
        this.testButton.setText(Messages.CustomDataSetWizardPage_Test_query);
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDataSetWizardPage.this.testQuery();
            }
        });
        return composite;
    }

    private void testQuery() {
        String title = Messages.CustomDataSetWizardPage_Test_query1;
        ConsoleConfiguration configuration = this.getInternalConsoleConfiguration();
        if (configuration == null || configuration.getSessionFactory() == null) {
            MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)NLS.bind((String)Messages.CustomDataSetWizardPage_Invalid_configuration, (Object)this.getConfigurationName()));
        }
        try {
            this.generateSQL(configuration.getSessionFactory(), this.getQueryText());
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)Messages.CustomDataSetWizardPage_The_query_is_valid);
        }
        catch (Exception e) {
            String message = Messages.CustomDataSetWizardPage_The_query_is_not_valid;
            Status status = new Status(4, "org.jboss.tools.birt.oda.ui", e.getLocalizedMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
        }
    }

    private String generateSQL(SessionFactory sessionFactory, String queryText) {
        SessionFactoryImpl sfimpl = (SessionFactoryImpl)sessionFactory;
        StringBuffer str = new StringBuffer(256);
        HQLQueryPlan plan = new HQLQueryPlan(queryText, false, Collections.EMPTY_MAP, (SessionFactoryImplementor)sfimpl);
        QueryTranslator[] translators = plan.getTranslators();
        int i = 0;
        while (i < translators.length) {
            QueryTranslator translator = translators[i];
            if (translator.isManipulationStatement()) {
                str.append("Manipulation of" + i + ":");
                Iterator iterator = translator.getQuerySpaces().iterator();
                while (iterator.hasNext()) {
                    Object qspace = iterator.next();
                    str.append(qspace);
                    if (!iterator.hasNext()) continue;
                    str.append(", ");
                }
            } else {
                Type[] returnTypes = translator.getReturnTypes();
                str.append(String.valueOf(i) + ": ");
                int j = 0;
                while (j < returnTypes.length) {
                    Type returnType = returnTypes[j];
                    str.append(returnType.getName());
                    if (j < returnTypes.length - 1) {
                        str.append(", ");
                    }
                    ++j;
                }
            }
            str.append("\n-----------------\n");
            for (String sql : translator.collectSqlStrings()) {
                str.append(QLFormatHelper.formatForScreen((String)sql));
                str.append("\n\n");
            }
            ++i;
        }
        return str.toString();
    }

    private final void attachMenus(SourceViewer viewer) {
        StyledText widget = viewer.getTextWidget();
        TextMenuManager menuManager = new TextMenuManager((TextViewer)viewer);
        widget.setMenu(menuManager.getContextMenu((Control)widget));
    }

    private String getConfigurationName() {
        DataSetDesign design = this.getInitializationDesign();
        DataSourceDesign dsDesign = design.getDataSourceDesign();
        Property property = dsDesign.getPublicProperties().findProperty("configuration");
        NameValuePair propertyValue = property.getNameValue();
        String name = propertyValue.getValue();
        return name;
    }

    private ConsoleConfiguration getInternalConsoleConfiguration() {
        return this.getConsoleConfiguration(this.getConfigurationName());
    }

    private Sash createSash(Composite composite) {
        Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        return sash;
    }

    private Control createTableSelectionComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1040);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        Label dataSourceLabel = new Label(composite, 16384);
        dataSourceLabel.setText(Messages.CustomDataSetWizardPage_Avaliable_Items);
        data = new GridData();
        dataSourceLabel.setLayoutData((Object)data);
        this.viewer = new MTreeViewer(composite, 770);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AnyAdaptableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new KnownConfigurationsProvider());
        ConsoleConfiguration configuration = this.getInternalConsoleConfiguration();
        if (configuration != null) {
            SessionFactory sessionFactory = configuration.getSessionFactory();
            if (sessionFactory == null) {
                configuration.build();
                configuration.buildSessionFactory();
                configuration.getSessionFactory();
            }
            this.viewer.setInput((Object)new LazySessionFactory(configuration));
        } else {
            this.viewer.setInput((Object)KnownConfigurations.getInstance());
        }
        return composite;
    }

    private ConsoleConfiguration getConsoleConfiguration(String name) {
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurations();
        int i = 0;
        while (i < configurations.length) {
            if (configurations[i].getName().equals(name)) {
                return configurations[i];
            }
            ++i;
        }
        return null;
    }

    private void setWidthHints(Composite pageContainer, Control left, Control right, Sash sash) {
        int leftWidth = left.computeSize((int)-1, (int)-1).x;
        int totalWidth = pageContainer.computeSize((int)-1, (int)-1).x;
        if ((double)leftWidth / (double)totalWidth > 0.4) {
            leftWidth = totalWidth * 40 / 100;
            GridData data = (GridData)left.getLayoutData();
            data.widthHint = leftWidth -= sash.computeSize((int)-1, (int)-1).x;
            data = (GridData)right.getLayoutData();
            data.widthHint = totalWidth - leftWidth;
        } else {
            GridData data = (GridData)left.getLayoutData();
            data.widthHint = leftWidth;
            data = (GridData)right.getLayoutData();
            data.widthHint = totalWidth - leftWidth;
        }
    }

    private String getInitialQueryString() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return "";
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null) {
            return "";
        }
        return queryText;
    }

    private String getQueryText() {
        return this.styledText.getText();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (!this.hasValidData()) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = this.styledText != null && this.getQueryText() != null && this.getQueryText().trim().length() > 0;
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage(Messages.CustomDataSetWizardPage_Requires_input_value, 3);
        }
        if (this.testButton != null) {
            this.testButton.setEnabled(isValid);
        }
        this.setPageComplete(isValid);
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection customConn = null;
            try {
                try {
                    HibernateDriver customDriver = new HibernateDriver();
                    customConn = customDriver.getConnection(null);
                    Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    customConn.open(connProps);
                    this.updateDesign(dataSetDesign, customConn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(customConn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(customConn);
                throw throwable;
            }
            this.closeConnection(customConn);
        }
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        if (this.fActivation != null) {
            this.fService.deactivateHandler(this.fActivation);
        }
        if (this.sourceViewer != null) {
            this.sourceViewer.getTextWidget().dispose();
            this.sourceViewer = null;
        }
        super.dispose();
    }
}

