/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.ui.impl;

import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.hibernate.console.node.BaseNode;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;

public class HibernateDSDropSource
implements DropTargetListener {
    private SourceViewer viewer;

    public HibernateDSDropSource(SourceViewer viewer) {
        this.viewer = viewer;
        int operations = 17;
        DropTarget target = new DropTarget((Control)viewer.getTextWidget(), operations);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this);
    }

    public void dragEnter(DropTargetEvent event) {
        this.viewer.getTextWidget().setFocus();
        if (event.detail == 16) {
            event.detail = 1;
        }
        if (event.detail != 1) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.dragEnter(event);
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void drop(DropTargetEvent event) {
        ISelection data;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (data = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.data;
            Object source = selection.getFirstElement();
            String text = null;
            if (source instanceof RootClass) {
                RootClass table = (RootClass)source;
                text = this.getShortName(table.getEntityName());
            } else if (source instanceof Property) {
                Property property = (Property)source;
                text = property.getName();
            } else if (source instanceof BaseNode) {
                BaseNode node = (BaseNode)source;
                text = this.getShortName(node.getName());
            }
            if (text == null) {
                return;
            }
            StyledText textWidget = this.viewer.getTextWidget();
            int selectionStart = textWidget.getSelection().x;
            textWidget.insert(text);
            textWidget.setSelection(selectionStart + text.length());
            textWidget.setFocus();
        }
    }

    private String getShortName(String name) {
        while (name.indexOf(".") > -1) {
            name = name.substring(name.indexOf(".") + 1);
        }
        return name;
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

