/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.esb.core.ESBCorePlugin;
import org.jboss.tools.esb.core.model.ESBConstants;
import org.jboss.tools.esb.core.model.converters.ConverterConstants;
import org.jboss.tools.esb.core.model.converters.IPropertyConverter;

public class SpecificActionLoader
implements ESBConstants {
    static final String ACTION_ENTITY = "ESBAction";
    static final String ACTIONS_FOLDER_ENTITY = "ESBActions";
    private static Map<String, String> classToEntity = new HashMap<String, String>();
    public static final SpecificActionLoader instance = new SpecificActionLoader();
    Map<String, IPropertyConverter> propertyConverters = new HashMap<String, IPropertyConverter>();

    SpecificActionLoader() {
        XMapping m;
        if (classToEntity.isEmpty() && (m = PreferenceModelUtilities.getPreferenceModel().getMetaData().getMapping("ESBSpecificActions")) != null) {
            String[] classes;
            String[] stringArray = classes = m.getKeys();
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String entity = m.getValue(c);
                classToEntity.put(c, entity);
                ++n2;
            }
        }
        this.propertyConverters.put("alias", ConverterConstants.ALIAS_CONVERTER);
        this.propertyConverters.put("route", ConverterConstants.ROUTE_CONVERTER);
        this.propertyConverters.put("path", ConverterConstants.OBJECT_PATHS_CONVERTER);
        this.propertyConverters.put("notification", ConverterConstants.NOTIFICATION_CONVERTER);
        this.propertyConverters.put("notification2", ConverterConstants.NOTIFICATION_CONVERTER_2);
        this.propertyConverters.put("bpmVar", ConverterConstants.BPM_VAR_CONVERTER);
        this.propertyConverters.put("httpclient", ConverterConstants.ENDPOINT_CONVERTER);
        this.propertyConverters.put("header", ConverterConstants.HEADER_CONVERTER);
        this.propertyConverters.put("namespace", ConverterConstants.NAMESPACES_CONVERTER);
        this.propertyConverters.put("fieldalias", ConverterConstants.FIELD_ALIAS_CONVERTER);
        this.propertyConverters.put("implicitcollection", ConverterConstants.IMPLICIT_COLLECTION_CONVERTER);
        this.propertyConverters.put("attributealias", ConverterConstants.ATTRIBUTE_ALIAS_CONVERTER);
        this.propertyConverters.put("converter", ConverterConstants.CONVERTER_CONVERTER);
        this.propertyConverters.put("routernamespace", ConverterConstants.ROUTER_NAMESPACES_CONVERTER);
        this.propertyConverters.put("arg", ConverterConstants.EJB_PARAM_CONVERTER);
    }

    public boolean isPreActionEntity(XModelObject object) {
        String entityName = object.getModelEntity().getName();
        return this.isPreActionEntity(entityName);
    }

    public boolean isPreActionEntity(String entity) {
        return entity.startsWith("ESBPreAction");
    }

    public boolean isActionsFolder(String entity) {
        return entity.startsWith(ACTIONS_FOLDER_ENTITY);
    }

    private String addSuffix(String entityName, XModelObject actions) {
        String[] stringArray = KNOWN_SUFFIXES;
        int n = KNOWN_SUFFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String suff = stringArray[n2];
            if (actions.getModelEntity().getChild(String.valueOf(entityName) + suff) != null) {
                return String.valueOf(entityName) + suff;
            }
            ++n2;
        }
        return entityName;
    }

    public void convertChildrenToSpecific(XModelObject actions) {
        if (!this.isActionsFolder(actions.getModelEntity().getName())) {
            return;
        }
        boolean modified = false;
        XModelObject[] as = actions.getChildren();
        int i = 0;
        while (i < as.length) {
            XModelObject action = this.convertBasicActionToSpecific(actions, as[i]);
            if (action != null) {
                as[i] = action;
                modified = true;
            }
            ++i;
        }
        if (modified) {
            ((RegularObjectImpl)actions).replaceChildren(as);
        }
    }

    public XModelObject convertBasicActionToSpecific(XModelObject actions, XModelObject basic) {
        String cls = basic.getAttributeValue("class");
        if (cls == null) {
            return null;
        }
        String entityName = classToEntity.get(cls);
        if (entityName == null) {
            return null;
        }
        entityName = this.addSuffix(entityName, actions);
        return this.convertBasicActionToSpecific(basic, entityName);
    }

    public XModelObject convertBasicActionToSpecific(XModelObject basic, String entityName) {
        XModelEntity entity = basic.getModelEntity().getMetaModel().getEntity(entityName);
        if (entity == null) {
            return null;
        }
        XModelObject action = basic.getModel().createModelObject(entityName, null);
        try {
            XModelObjectLoaderUtil.mergeAttributes((XModelObject)action, (XModelObject)basic);
        }
        catch (XModelException e) {
            ESBCorePlugin.log((Exception)((Object)e));
        }
        SpecificActionLoader.copyBasicPropertiesToSpecificAtttributes(basic, action);
        XChild[] ce = action.getModelEntity().getChildren();
        int i = 0;
        while (i < ce.length) {
            IPropertyConverter converter;
            XModelEntity childEntity;
            String childEntityName = ce[i].getName();
            if (!"ESBProperty".equals(childEntityName) && (childEntity = action.getModelEntity().getMetaModel().getEntity(childEntityName)) != null && (converter = this.getPropertyConverter(childEntity)) != null) {
                converter.toSpecific(basic, action);
            }
            ++i;
        }
        XModelObject[] cs = basic.getChildren("ESBProperty");
        int i2 = 0;
        while (i2 < cs.length) {
            action.addChild(cs[i2]);
            ++i2;
        }
        return action;
    }

    public XModelObject convertSpecificActionToBasic(XModelObject action) {
        String entityName = action.getModelEntity().getName();
        if (!this.isPreActionEntity(entityName)) {
            return action;
        }
        String basicActionEntity = this.addSuffix(ACTION_ENTITY, action.getParent());
        XModelObject result = action.getModel().createModelObject(basicActionEntity, null);
        try {
            XModelObjectLoaderUtil.mergeAttributes((XModelObject)result, (XModelObject)action);
        }
        catch (XModelException e) {
            ESBCorePlugin.log((Exception)((Object)e));
        }
        XModelEntity entity = action.getModelEntity();
        SpecificActionLoader.copySpecificAtttributesToBasicProperties(action, result);
        XChild[] ce = entity.getChildren();
        int i = 0;
        while (i < ce.length) {
            IPropertyConverter converter;
            XModelEntity childEntity;
            String childEntityName = ce[i].getName();
            if (!"ESBProperty".equals(childEntityName) && (childEntity = entity.getMetaModel().getEntity(childEntityName)) != null && (converter = this.getPropertyConverter(childEntity)) != null) {
                converter.toBasic(result, action);
            }
            ++i;
        }
        XModelObject[] cs = action.getChildren("ESBProperty");
        int i2 = 0;
        while (i2 < cs.length) {
            result.addChild(cs[i2].copy());
            ++i2;
        }
        return result;
    }

    IPropertyConverter getPropertyConverter(XModelEntity childEntity) {
        String converter = childEntity.getProperty("converter");
        return converter == null ? null : this.propertyConverters.get(converter);
    }

    public static void copyBasicPropertiesToSpecificAtttributes(XModelObject basic, XModelObject specific) {
        XModelEntity entity = specific.getModelEntity();
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            String name;
            XModelObject p;
            String pre = as[i].getProperty("pre");
            if (pre != null && pre.length() != 0 && "true".equals(pre) && (p = basic.getChildByPath(name = as[i].getXMLName())) != null) {
                String value = p.getAttributeValue("value");
                specific.setAttributeValue(as[i].getName(), value);
                specific.set(String.valueOf(as[i].getXMLName()) + ".#comment", p.getAttributeValue("comment"));
                p.removeFromParent();
            }
            ++i;
        }
    }

    public static void copySpecificAtttributesToBasicProperties(XModelObject specific, XModelObject basic) {
        XModelEntity entity = specific.getModelEntity();
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < as.length) {
            String value;
            String pre = as[i].getProperty("pre");
            if (pre != null && pre.length() != 0 && "true".equals(pre) && ((value = specific.getAttributeValue(as[i].getName())) != null && value.length() != 0 && !value.equals(as[i].getDefaultValue()) || "always".equals(as[i].getProperty("save")))) {
                XModelObject p = specific.getModel().createModelObject("ESBProperty", null);
                p.setAttributeValue("name", as[i].getXMLName());
                p.setAttributeValue("value", value);
                p.setAttributeValue("comment", specific.get(String.valueOf(as[i].getXMLName()) + ".#comment"));
                basic.addChild(p);
            }
            ++i;
        }
    }
}

