/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.facet;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.jboss.tools.esb.core.StatusUtils;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.messages.JBossFacetCoreMessages;

public class JBossClassPathCommand
extends AbstractDataModelOperation {
    IProject project;
    private IDataModel model;

    public JBossClassPathCommand(IProject project, IDataModel model) {
        this.project = project;
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeOverride(monitor);
    }

    public IStatus executeOverride(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            boolean isServerSupplied = this.model.getBooleanProperty("jboss.is.server.supplied");
            IPath esbContainerPath = null;
            if (isServerSupplied) {
                String serverRuntimeId = this.getProjectTargetRuntimeID(this.project);
                esbContainerPath = new Path("org.jboss.esb.runtime.classpath").append("server.supplied").append(serverRuntimeId);
            } else {
                String runtimeName = this.model.getStringProperty("jboss.runtime_id");
                String runtimeLocation = this.model.getStringProperty("jboss.runtime.home");
                String esbcontentFolder = this.model.getStringProperty("JBoss.Project.Content_Folder");
                this.project.setPersistentProperty(IJBossESBFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME, runtimeName);
                this.project.setPersistentProperty(IJBossESBFacetDataModelProperties.PERSISTENCE_PROPERTY_RNTIME_LOCATION, runtimeLocation);
                this.project.setPersistentProperty(IJBossESBFacetDataModelProperties.QNAME_ESB_CONTENT_FOLDER, esbcontentFolder);
                esbContainerPath = new Path("org.jboss.esb.runtime.classpath").append(runtimeName);
            }
            status = JBossClassPathCommand.addClassPath(this.project, esbContainerPath);
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus(JBossFacetCoreMessages.Error_Add_Facet_JBossESB, e);
        }
        return status;
    }

    private String getProjectTargetRuntimeID(IProject project) throws CoreException {
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
        IRuntime runtime = fp.getPrimaryRuntime();
        if (runtime == null) {
            return "";
        }
        return runtime.getProperty("id");
    }

    public static IStatus addClassPath(IProject project, IPath path) {
        IStatus status = Status.OK_STATUS;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry newClasspath = JavaCore.newContainerEntry((IPath)path);
            IClasspathEntry[] oldClasspathEntries = javaProject.readRawClasspath();
            boolean isFolderInClassPathAlready = false;
            int i = 0;
            while (i < oldClasspathEntries.length && !isFolderInClassPathAlready) {
                if (oldClasspathEntries[i].getPath().equals((Object)newClasspath.getPath())) {
                    isFolderInClassPathAlready = true;
                    break;
                }
                ++i;
            }
            if (!isFolderInClassPathAlready) {
                IClasspathEntry[] newClasspathEntries = new IClasspathEntry[oldClasspathEntries.length + 1];
                int i2 = 0;
                while (i2 < oldClasspathEntries.length) {
                    newClasspathEntries[i2] = oldClasspathEntries[i2];
                    ++i2;
                }
                newClasspathEntries[oldClasspathEntries.length] = newClasspath;
                javaProject.setRawClasspath(newClasspathEntries, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            status = StatusUtils.errorStatus(NLS.bind((String)JBossFacetCoreMessages.Error_Copy, (Object[])new String[]{e.getLocalizedMessage()}), e);
            return status;
        }
        return status;
    }
}

