/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.preference.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;
import org.jboss.tools.esb.core.runtime.JBossRuntimeManager;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.preference.controls.JBossRuntimeListFieldEditor;

public class JBossESBRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int COLUMNS = 3;
    JBossRuntimeListFieldEditor jbossRuntimes = new JBossRuntimeListFieldEditor("rtlist", JBossESBUIMessages.JBoss_Preference_Page_Runtimes, new ArrayList<JBossESBRuntime>(Arrays.asList(JBossRuntimeManager.getInstance().getRuntimes())));

    public JBossESBRuntimePreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        root.setLayout((Layout)gl);
        this.jbossRuntimes.doFillIntoGrid(root);
        return root;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        for (JBossESBRuntime rt : this.jbossRuntimes.getAddedJBossRuntimes()) {
            JBossRuntimeManager.getInstance().addRuntime(rt);
        }
        this.jbossRuntimes.getAddedJBossRuntimes().clear();
        for (JBossESBRuntime rt : this.jbossRuntimes.getRemoved()) {
            JBossRuntimeManager.getInstance().removeRuntime(rt);
        }
        this.jbossRuntimes.getRemoved().clear();
        JBossESBRuntime defaultRuntime = this.jbossRuntimes.getDefaultJBossRuntime();
        JBossESBRuntime[] jBossESBRuntimeArray = JBossRuntimeManager.getInstance().getRuntimes();
        int n = jBossESBRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JBossESBRuntime jbossWSRuntime = jBossESBRuntimeArray[n2];
            jbossWSRuntime.setDefault(false);
            ++n2;
        }
        if (defaultRuntime != null) {
            defaultRuntime.setDefault(true);
        }
        this.jbossRuntimes.setDefaultJBossRuntime(null);
        Map<JBossESBRuntime, JBossESBRuntime> changed = this.jbossRuntimes.getChangedJBossRuntimes();
        for (JBossESBRuntime c : changed.keySet()) {
            JBossESBRuntime o = changed.get(c);
            o.setHomeDir(c.getHomeDir());
            o.setVersion(c.getVersion());
            o.setConfiguration(c.getConfiguration());
            String oldName = o.getName();
            String newName = c.getName();
            if (!oldName.equals(newName)) {
                JBossRuntimeManager.getInstance().changeRuntimeName(oldName, newName);
            }
            o.setDefault(c.isDefault());
            o.setUserConfigClasspath(c.isUserConfigClasspath());
            o.setLibraries(c.getLibraries());
        }
        this.jbossRuntimes.getChangedJBossRuntimes().clear();
        JBossRuntimeManager.getInstance().save();
    }

    protected void performDefaults() {
        this.setValid(true);
        this.setMessage(null);
        this.performApply();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public JBossRuntimeListFieldEditor getJBossRuntimes() {
        return this.jbossRuntimes;
    }
}

