/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.preference.controls;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;
import org.jboss.tools.esb.core.runtime.JBossRuntimeManager;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.preference.controls.BaseFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.ButtonFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.ComboFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.CompositeEditor;
import org.jboss.tools.esb.project.ui.preference.controls.IFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.JBossLibraryListFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.LabelFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.TextFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRuntimeListFieldEditor
extends BaseFieldEditor {
    static final int GL_COLUMNS = 2;
    static final int GL_HINT_HEIGHT = 200;
    static final int TC_DEFAULT_WIDTH = 21;
    static final int TC_NAME_WIDTH = 100;
    static final int TC_VERSION_WIDTH = 50;
    static final int TC_PATH_WIDTH = 100;
    private CheckboxTableViewer tableView = null;
    private Composite root = null;
    private ActionPanel actionPanel;
    private Map<JBossESBRuntime, JBossESBRuntime> changed = new HashMap<JBossESBRuntime, JBossESBRuntime>();
    private JBossESBRuntime checkedElement = new JBossESBRuntime();
    private List<JBossESBRuntime> added = new ArrayList<JBossESBRuntime>();
    private List<JBossESBRuntime> removed = new ArrayList<JBossESBRuntime>();

    public JBossRuntimeListFieldEditor(String name, String label, Object defaultValue) {
        super(name, label, defaultValue);
    }

    public JBossESBRuntime getDefaultJBossRuntime() {
        return this.checkedElement;
    }

    public void setDefaultJBossRuntime(JBossESBRuntime rt) {
        this.checkedElement = rt;
    }

    public List<JBossESBRuntime> getAddedJBossRuntimes() {
        return this.added;
    }

    public Map<JBossESBRuntime, JBossESBRuntime> getChangedJBossRuntimes() {
        return this.changed;
    }

    public List<JBossESBRuntime> getRemoved() {
        return this.removed;
    }

    @Override
    public Object[] getEditorControls(Object composite) {
        this.root = new Composite((Composite)composite, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.root.setLayoutData((Object)gd);
        this.root.setLayout((Layout)new FormLayout());
        this.createTableView();
        this.createActionBar();
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0, 5);
        tableData.right = new FormAttachment((Control)this.actionPanel, -5);
        tableData.top = new FormAttachment(0, 5);
        tableData.bottom = new FormAttachment(100, -5);
        this.tableView.getControl().setLayoutData((Object)tableData);
        FormData actionsData = new FormData();
        actionsData.top = new FormAttachment(0, 5);
        actionsData.bottom = new FormAttachment(100, -5);
        actionsData.right = new FormAttachment(100, -5);
        this.actionPanel.setLayoutData(actionsData);
        return new Control[]{this.root};
    }

    protected void createTableView() {
        this.tableView = CheckboxTableViewer.newCheckList((Composite)this.root, (int)68100);
        TableColumn tc1 = new TableColumn(this.tableView.getTable(), 0x1000000);
        tc1.setWidth(21);
        tc1.setResizable(false);
        TableColumn tc2 = new TableColumn(this.tableView.getTable(), 16384);
        tc2.setWidth(100);
        tc2.setText(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Name);
        TableColumn tc3 = new TableColumn(this.tableView.getTable(), 16384);
        tc3.setWidth(50);
        tc3.setText(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Version);
        TableColumn tc4 = new TableColumn(this.tableView.getTable(), 16384);
        tc4.setWidth(100);
        tc4.setText(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Path);
        this.tableView.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                throw new IllegalArgumentException(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Inputelement_Must_Be_List);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }
        });
        this.tableView.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            private static final int TC_DEFAULT_NUMBER = 0;
            private static final int TC_NAME_NUMBER = 1;
            private static final int TC_VERSION_NUMBER = 2;
            private static final int TC_PATH_NUMBER = 3;

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                JBossESBRuntime rt = (JBossESBRuntime)element;
                if (columnIndex == 0) {
                    return "";
                }
                if (columnIndex == 1) {
                    return rt.getName();
                }
                if (columnIndex == 2) {
                    return rt.getVersion().toString();
                }
                if (columnIndex == 3) {
                    return rt.getHomeDir();
                }
                return "";
            }
        });
        this.tableView.setInput(this.getValue());
        this.tableView.getTable().setLinesVisible(true);
        this.tableView.getTable().setHeaderVisible(true);
        this.tableView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JBossESBRuntime selRt = (JBossESBRuntime)event.getElement();
                if (event.getChecked()) {
                    JBossESBRuntime deselRt = null;
                    Object[] selRts = JBossRuntimeListFieldEditor.this.tableView.getCheckedElements();
                    int i = 0;
                    while (i < selRts.length) {
                        JBossESBRuntime rt = (JBossESBRuntime)selRts[i];
                        if (rt != selRt) {
                            deselRt = rt;
                            break;
                        }
                        ++i;
                    }
                    if (deselRt != null) {
                        Object[] newChecked = new Object[selRts.length - 1];
                        JBossRuntimeListFieldEditor.this.checkedElement = null;
                        int i2 = 0;
                        Object[] objectArray = selRts;
                        int n = selRts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            JBossESBRuntime rt = (JBossESBRuntime)object;
                            if (rt == selRt) {
                                newChecked[i2] = rt;
                                JBossRuntimeListFieldEditor.this.checkedElement = rt;
                                ++i2;
                            }
                            ++n2;
                        }
                        JBossRuntimeListFieldEditor.this.tableView.setCheckedElements(newChecked);
                    } else {
                        JBossRuntimeListFieldEditor.this.checkedElement = (JBossESBRuntime)event.getElement();
                    }
                } else if (JBossRuntimeListFieldEditor.this.checkedElement == selRt) {
                    JBossRuntimeListFieldEditor.this.checkedElement = null;
                }
                JBossRuntimeListFieldEditor.this.pcs.firePropertyChange(JBossRuntimeListFieldEditor.this.getName(), null, JBossRuntimeListFieldEditor.this.getValue());
            }
        });
        for (JBossESBRuntime rt : (List)this.getValue()) {
            if (!rt.isDefault()) continue;
            this.tableView.setChecked((Object)rt, true);
            this.checkedElement = rt;
        }
    }

    protected void createActionBar() {
        this.actionPanel = new ActionPanel(this.root, new BaseAction[]{new AddAction(), new EditAction(), new RemoveAction()});
        this.tableView.addSelectionChangedListener((ISelectionChangedListener)this.actionPanel);
    }

    private void setDefaultRuntime() {
        List runtimes = (List)this.getValue();
        boolean checked = false;
        for (JBossESBRuntime jbossRuntime : runtimes) {
            if (this.checkedElement != jbossRuntime) continue;
            checked = true;
            this.tableView.setChecked((Object)this.checkedElement, true);
            break;
        }
        if (!(checked || runtimes.size() <= 0 || this.tableView.getCheckedElements() != null && this.tableView.getCheckedElements().length != 0)) {
            this.tableView.setChecked(runtimes.get(0), true);
            this.checkedElement = (JBossESBRuntime)runtimes.get(0);
        }
    }

    @Override
    public Object[] getEditorControls() {
        return new Control[]{this.root};
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    @Override
    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)JBossESBUIMessages.Error_JBoss_Basic_Editor_Composite);
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)JBossESBUIMessages.Error_JBoss_Basic_Editor_Support);
        Composite aComposite = (Composite)parent;
        this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        ((Control)this.getEditorControls()[0]).setLayoutData((Object)gd);
    }

    public static class ActionButton
    implements IPropertyChangeListener {
        private Button button;
        private BaseAction action;

        public ActionButton(Composite parent, int style, BaseAction action) {
            this.button = new Button(parent, style);
            this.action = action;
            GridData gd = new GridData(768, 2, false, false);
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this.button.setLayoutData((Object)gd);
            this.action.addPropertyChangeListener(this);
            this.button.setText(action.getText());
            this.button.setEnabled(action.isEnabled());
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ActionButton.this.action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public Control getControl() {
            return this.button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.button.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }

    public static class ActionPanel
    extends Composite
    implements ISelectionChangedListener {
        private BaseAction[] actions = null;

        public ActionPanel(Composite parent, int style, BaseAction[] actions) {
            super(parent, style);
            this.actions = actions;
            this.setLayout((Layout)new GridLayout(1, false));
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                new ActionButton(this, 8, action);
                ++n2;
            }
        }

        public ActionPanel(Composite parent, BaseAction[] actions) {
            this(parent, 0, actions);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                action.setSelection(event.getSelection());
                ++n2;
            }
        }
    }

    public class AddAction
    extends BaseAction {
        public AddAction() {
            super(JBossESBUIMessages.JBossRuntimeListFieldEditor_ActionAdd);
            this.setEnabled(true);
        }

        protected void updateEnablement() {
        }

        public void run() {
            JBossRuntimeNewWizard wiz = new JBossRuntimeNewWizard((List)JBossRuntimeListFieldEditor.this.getValue(), JBossRuntimeListFieldEditor.this.added);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            JBossRuntimeListFieldEditor.this.tableView.refresh();
            JBossRuntimeListFieldEditor.this.setDefaultRuntime();
        }
    }

    public abstract class BaseAction
    extends Action {
        JBossESBRuntime[] runtimes;

        public BaseAction(String name) {
            super(name);
            this.runtimes = new JBossESBRuntime[0];
            this.updateEnablement();
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                ArrayList<JBossESBRuntime> rts = new ArrayList<JBossESBRuntime>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object rt = objectArray[n2];
                    rts.add((JBossESBRuntime)rt);
                    ++n2;
                }
                this.runtimes = rts.toArray(new JBossESBRuntime[0]);
            } else {
                this.runtimes = new JBossESBRuntime[0];
            }
            this.updateEnablement();
        }

        protected abstract void updateEnablement();
    }

    public class EditAction
    extends BaseAction {
        public EditAction() {
            super(JBossESBUIMessages.JBossRuntimeListFieldEditor_ActionEdit);
        }

        protected void updateEnablement() {
            this.setEnabled(this.runtimes.length == 1);
        }

        public void run() {
            JBossESBRuntime selected = this.runtimes[0];
            JBossWSRuntimeEditWizard wiz = new JBossWSRuntimeEditWizard((List)JBossRuntimeListFieldEditor.this.getValue(), this.runtimes[0], JBossRuntimeListFieldEditor.this.added, JBossRuntimeListFieldEditor.this.changed);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            JBossRuntimeListFieldEditor.this.tableView.refresh();
            JBossESBRuntime c = null;
            if (JBossRuntimeListFieldEditor.this.changed.containsValue(selected) && (c = this.findChangedRuntime(selected)) != null) {
                JBossRuntimeListFieldEditor.this.tableView.setSelection((ISelection)new StructuredSelection((Object)c));
            }
            if (c != null && c.isDefault()) {
                JBossRuntimeListFieldEditor.this.checkedElement = c;
            }
            JBossRuntimeListFieldEditor.this.setDefaultRuntime();
        }

        private JBossESBRuntime findChangedRuntime(JBossESBRuntime source) {
            for (JBossESBRuntime r : JBossRuntimeListFieldEditor.this.changed.keySet()) {
                if (source != JBossRuntimeListFieldEditor.this.changed.get(r)) continue;
                return r;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBossESBRuntimeWizardPage
    extends WizardPage
    implements PropertyChangeListener {
        private static final String SRT_NAME = "name";
        private static final String SRT_VERSION = "version";
        private static final String SRT_HOMEDIR = "homeDir";
        private static final int GL_PARENT_COLUMNS = 1;
        private static final int GL_CONTENT_COLUMNS = 3;
        List<JBossESBRuntime> value = null;
        IFieldEditor name = this.createTextEditor("name", JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Name2, "");
        IFieldEditor version = this.createComboEditor("version", JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Version, this.getESBFacetVersions(), "");
        Combo configuration;
        IFieldEditor homeDir = this.createBrowseFolderEditor("homeDir", JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Home_Folder, "");
        JBossESBRuntime current = null;
        JBossESBRuntime source = null;
        IFieldEditor jars = null;

        public JBossESBRuntimeWizardPage(List<JBossESBRuntime> editedList, JBossESBRuntime source) {
            super(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_New_Runtime);
            this.setMessage(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Create_A_Runtime);
            this.setTitle(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Runtime);
            this.value = editedList;
            this.source = source;
        }

        public void createControl(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, false));
            GridData dg = new GridData();
            dg.horizontalAlignment = 4;
            dg.grabExcessHorizontalSpace = true;
            Composite root = new Composite(parent, 0);
            root.setLayoutData((Object)dg);
            GridLayout gl = new GridLayout(3, false);
            root.setLayout((Layout)gl);
            this.name.doFillIntoGrid(root);
            this.name.addPropertyChangeListener(this);
            this.version.doFillIntoGrid(root);
            this.version.addPropertyChangeListener(this);
            this.homeDir.doFillIntoGrid(root);
            this.homeDir.addPropertyChangeListener(this);
            new Label(root, 0).setText(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Configuration);
            Composite cfgComposite = new Composite(root, 0);
            cfgComposite.setLayout((Layout)new GridLayout(2, false));
            cfgComposite.setLayoutData((Object)new GridData(768));
            this.configuration = new Combo(cfgComposite, 8);
            GridData gd = new GridData();
            gd.widthHint = 150;
            this.configuration.setLayoutData((Object)gd);
            new Label(cfgComposite, 0).setText(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Configuration_Description);
            this.configuration.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    JBossESBRuntimeWizardPage.this.checkPageComplete();
                }
            });
            this.jars = new JBossLibraryListFieldEditor("", "", this.current);
            this.jars.doFillIntoGrid(root);
            this.jars.addPropertyChangeListener(this);
            this.setPageComplete(false);
            this.setControl((Control)root);
            this.updateConfigrations(this.homeDir.getValueAsString());
        }

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if (SRT_HOMEDIR.equals(evt.getPropertyName())) {
                this.updateConfigrations(this.homeDir.getValueAsString());
            }
            this.checkPageComplete();
        }

        private void checkPageComplete() {
            if (this.name.getValueAsString() == null || "".equals(this.name.getValueAsString().toString().trim())) {
                this.setErrorMessage(JBossESBUIMessages.Error_JBoss_Runtime_List_Field_Editor_Name_Cannot_Be_Empty);
                this.setPageComplete(false);
                return;
            }
            if (this.version.getValueAsString() == null || "".equals(this.version.getValueAsString())) {
                this.setErrorMessage(JBossESBUIMessages.Error_JBoss_Runtime_List_Field_Editor_Version_Cannot_Be_Empty);
                this.setPageComplete(false);
                return;
            }
            if (!this.name.getValueAsString().matches("[a-zA-Z_][a-zA-Z0-9_\\-\\. ]*")) {
                this.setErrorMessage(JBossESBUIMessages.Error_JBoss_Runtime_List_Field_Editor_Runtime_Name_Is_Not_Correct);
                this.setPageComplete(false);
                return;
            }
            for (JBossESBRuntime rt : this.value) {
                if (this.current != null && this.current.getName().equals(rt.getName()) || !rt.getName().equals(this.name.getValueAsString())) continue;
                this.setErrorMessage(NLS.bind((String)JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Runtime_Already_Exists, (Object)this.name.getValueAsString()));
                this.setPageComplete(false);
                return;
            }
            JBossESBRuntime jarJbws = (JBossESBRuntime)this.jars.getValue();
            if (this.current != null && this.current.getName().equals(this.name.getValueAsString()) && this.current.getHomeDir().equals(this.homeDir.getValueAsString()) && this.current.getVersion().equals(this.version.getValueAsString()) && this.current.isUserConfigClasspath() == jarJbws.isUserConfigClasspath() && this.current.getConfiguration().equals(this.configuration.getText()) && (!jarJbws.isUserConfigClasspath() || this.hasSameLibraies(this.current.getLibraries(), jarJbws.getLibraries()))) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
            if (jarJbws.isUserConfigClasspath() && jarJbws.getLibraries().size() == 0) {
                this.setErrorMessage(JBossESBUIMessages.JBossRuntimeListFieldEditor_ErrorMessageAtLeastOneJar);
                this.setPageComplete(false);
                return;
            }
            if (this.homeDir.getValueAsString() == null || "".equals(this.homeDir.getValueAsString().trim())) {
                this.setErrorMessage(JBossESBUIMessages.Error_JBoss_Runtime_List_Field_Editor_Path_To_Home_Diretory_Cannot_Be_Empty);
                this.setPageComplete(false);
                return;
            }
            if (!this.runtimeExist(this.homeDir.getValueAsString(), (String)this.version.getValue(), this.configuration.getText())) {
                final Combo vCombo = (Combo)this.version.getEditorControls()[1];
                String[] vStrings = vCombo.getItems();
                int i = 0;
                while (i < vStrings.length) {
                    boolean works = this.runtimeExist(this.homeDir.getValueAsString(), vStrings[i], this.configuration.getText());
                    if (works) {
                        final String newVersion = vStrings[i];
                        final int i2 = i;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                vCombo.select(i2);
                                JBossESBRuntimeWizardPage.this.version.setValue(newVersion);
                            }
                        });
                        return;
                    }
                    ++i;
                }
                this.setErrorMessage(NLS.bind((String)JBossESBUIMessages.Label_JBoss_Runtime_Load_Error, (Object)this.version.getValue()));
                this.setPageComplete(false);
                return;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }

        private boolean hasSameLibraies(List<String> lib1, List<String> lib2) {
            if (lib1.size() != lib2.size()) {
                return false;
            }
            for (String jar : lib1) {
                if (lib2.contains(jar)) continue;
                return false;
            }
            return true;
        }

        private List<String> getESBFacetVersions() {
            ArrayList<String> versions = new ArrayList<String>();
            IProjectFacet esbfacet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
            for (IProjectFacetVersion version : esbfacet.getVersions()) {
                versions.add(version.getVersionString());
            }
            versions.add("");
            Collections.sort(versions);
            Collections.reverse(versions);
            return versions;
        }

        private List<String> updateConfigrations(String location) {
            File serverDirectory;
            ArrayList<String> configList = new ArrayList<String>();
            Path locationPath = new Path(location);
            IPath asPath = locationPath.append("jboss-as").append("server");
            if (!asPath.toFile().exists()) {
                asPath = locationPath.append("server");
            }
            if ((serverDirectory = asPath.toFile()).exists()) {
                File[] types = serverDirectory.listFiles();
                int i = 0;
                while (i < types.length) {
                    File serviceDescriptor = new File(String.valueOf(types[i].getAbsolutePath()) + File.separator + "conf" + File.separator + "jboss-service.xml");
                    if (types[i].isDirectory() && serviceDescriptor.exists()) {
                        String configuration = types[i].getName();
                        configList.add(configuration);
                    }
                    ++i;
                }
                if (configList.size() > 0) {
                    this.getControl().setEnabled(true);
                }
            }
            if (this.configuration != null && !this.configuration.isDisposed()) {
                this.configuration.removeAll();
                for (String config : configList) {
                    this.configuration.add(config);
                    if (!"default".equals(config)) continue;
                    this.configuration.select(configList.indexOf(config));
                }
                if (this.source != null && this.source.getConfiguration() != null) {
                    this.configuration.setText(this.source.getConfiguration());
                }
            }
            this.updateDefaultVersion();
            return configList;
        }

        private void updateDefaultVersion() {
            String homeLocation = this.homeDir.getValueAsString();
            String config = this.configuration.getText();
            String defaultVersion = JBossRuntimeManager.getInstance().getVersion(homeLocation, config);
            this.version.setValue(defaultVersion);
        }

        public JBossESBRuntime getRuntime() {
            JBossESBRuntime newRt = new JBossESBRuntime();
            newRt.setName(this.name.getValueAsString());
            newRt.setVersion(this.version.getValueAsString());
            newRt.setHomeDir(this.homeDir.getValueAsString());
            newRt.setConfiguration(this.configuration.getText());
            JBossESBRuntime rt = (JBossESBRuntime)this.jars.getValue();
            newRt.setLibraries(rt.getLibraries());
            newRt.setUserConfigClasspath(rt.isUserConfigClasspath());
            return newRt;
        }

        public IFieldEditor createTextEditor(String name, String label, String defaultValue) {
            CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
            editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue)});
            return editor;
        }

        public IFieldEditor createComboEditor(String name, String label, List<String> values, String defaultValue) {
            CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
            editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new ComboFieldEditor(name, label, values, defaultValue, false)});
            return editor;
        }

        public IFieldEditor createBrowseFolderEditor(String name, String label, String defaultValue) {
            CompositeEditor editor = new CompositeEditor(name, label, defaultValue);
            editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label), new TextFieldEditor(name, label, defaultValue), new ButtonFieldEditor(name, this.createSelectFolderAction(JBossESBUIMessages.JBoss_SWT_Field_Editor_Factory_Browse), (Object)defaultValue)});
            return editor;
        }

        public ButtonFieldEditor.ButtonPressedAction createSelectFolderAction(String buttonName) {
            return new ButtonFieldEditor.ButtonPressedAction(buttonName){

                public void run() {
                    DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                    dialog.setMessage(JBossESBUIMessages.JBoss_SWT_Field_Editor_Factory_Select_Home_Folder);
                    dialog.setFilterPath(this.getFieldEditor().getValueAsString());
                    String directory = dialog.open();
                    if (directory != null) {
                        this.getFieldEditor().setValue(directory);
                    }
                }
            };
        }

        private boolean runtimeExist(String path, String version, String configuration) {
            File jbosswsHomeDir = new File(path);
            if (!jbosswsHomeDir.isDirectory()) {
                return false;
            }
            return JBossRuntimeManager.isValidESBStandaloneRuntimeDir((String)path, (String)version, (String)configuration) || JBossRuntimeManager.isValidESBServer((String)path, (String)version, (String)configuration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBossRuntimeNewWizard
    extends Wizard {
        JBossESBRuntimeWizardPage page1 = null;
        List<JBossESBRuntime> added = null;
        List<JBossESBRuntime> value = null;

        public JBossRuntimeNewWizard(List<JBossESBRuntime> exist, List<JBossESBRuntime> added) {
            this.setWindowTitle(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_New_Runtime);
            this.page1 = new JBossESBRuntimeWizardPage(exist, null);
            this.addPage((IWizardPage)this.page1);
            this.value = exist;
            this.added = added;
        }

        public boolean performFinish() {
            JBossESBRuntime rt = this.page1.getRuntime();
            this.added.add(rt);
            this.value.add(rt);
            return true;
        }

        protected JBossESBRuntime getRuntime() {
            return this.page1.getRuntime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBossWSRuntimeEditWizard
    extends Wizard {
        JBossESBRuntimeWizardPage page1 = null;
        List<JBossESBRuntime> added = null;
        Map<JBossESBRuntime, JBossESBRuntime> changed = null;
        List<JBossESBRuntime> value = null;
        JBossESBRuntime source = null;

        public JBossWSRuntimeEditWizard(List<JBossESBRuntime> existing, JBossESBRuntime source, List<JBossESBRuntime> added, Map<JBossESBRuntime, JBossESBRuntime> changed) {
            this.setWindowTitle(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Edit_Runtime);
            this.page1 = new JBossESBRuntimeWizardPage(existing, source);
            this.page1.setMessage(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Modify_Runtime);
            this.page1.setTitle(JBossESBUIMessages.JBoss_Runtime_List_Field_Editor_Edit_Runtime);
            this.addPage((IWizardPage)this.page1);
            this.value = existing;
            this.added = added;
            this.changed = changed;
            this.source = source;
            this.page1.name.setValue(source.getName());
            this.page1.version.setValue(source.getVersion());
            this.page1.homeDir.setValue(source.getHomeDir());
            this.page1.current = source;
        }

        public boolean performFinish() {
            JBossESBRuntime rt = this.page1.getRuntime();
            if (this.added.contains(this.source) || this.changed.containsKey(this.source)) {
                this.source.setName(rt.getName());
                this.source.setHomeDir(rt.getHomeDir());
                this.source.setVersion(rt.getVersion());
                this.source.setConfiguration(rt.getConfiguration());
                this.source.setUserConfigClasspath(rt.isUserConfigClasspath());
                this.source.setLibraries(rt.getLibraries());
            } else {
                int i;
                this.changed.put(rt, this.source);
                if (this.source.isDefault()) {
                    rt.setDefault(true);
                }
                if ((i = this.value.indexOf(this.source)) >= 0) {
                    this.value.set(i, rt);
                } else {
                    this.value.remove(this.source);
                    this.value.add(rt);
                }
            }
            return true;
        }
    }

    public class RemoveAction
    extends BaseAction {
        public RemoveAction() {
            super(JBossESBUIMessages.JBossRuntimeListFieldEditor_ActionRemove);
        }

        protected void updateEnablement() {
            this.setEnabled(this.runtimes.length > 0);
        }

        public void run() {
            JBossESBRuntime[] jBossESBRuntimeArray = this.runtimes;
            int n = this.runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                JBossESBRuntime rt = jBossESBRuntimeArray[n2];
                this.removeRuntime(rt);
                ++n2;
            }
            JBossRuntimeListFieldEditor.this.tableView.refresh();
            JBossRuntimeListFieldEditor.this.setDefaultRuntime();
        }

        private void removeRuntime(JBossESBRuntime r) {
            boolean used = JBossRuntimeManager.isRuntimeUsed((String)r.getName());
            String title = JBossESBUIMessages.JBoss_Runtime_Delete_Confirm_Title;
            String message = used ? NLS.bind((String)JBossESBUIMessages.JBoss_Runtime_Delete_Used_Confirm, (Object)r.getName()) : NLS.bind((String)JBossESBUIMessages.JBoss_Runtime_Delete_Not_Used_Confirm, (Object)r.getName());
            boolean b = MessageDialog.openConfirm((Shell)JBossRuntimeListFieldEditor.this.tableView.getControl().getShell(), (String)title, (String)message);
            if (b) {
                if (JBossRuntimeListFieldEditor.this.changed.containsKey(r)) {
                    r = (JBossESBRuntime)JBossRuntimeListFieldEditor.this.changed.remove(r);
                }
                JBossRuntimeListFieldEditor.this.removed.add(r);
                if (JBossRuntimeListFieldEditor.this.added.contains(r)) {
                    JBossRuntimeListFieldEditor.this.added.remove(r);
                }
                ((List)JBossRuntimeListFieldEditor.this.getValue()).remove(r);
            }
            if (JBossRuntimeListFieldEditor.this.checkedElement == r) {
                JBossRuntimeListFieldEditor.this.checkedElement = null;
            }
        }
    }
}

