/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.preference.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.preference.controls.BaseFieldEditor;
import org.jboss.tools.esb.project.ui.preference.controls.TextField;

public class TextFieldEditor
extends BaseFieldEditor
implements PropertyChangeListener {
    public static final int UNLIMITED = -1;
    protected int style = -1;
    protected TextField fTextField = null;
    protected int fWidthInChars = 0;

    public TextFieldEditor(String name, String aLabelText, String defaultvalue) {
        super(name, aLabelText, defaultvalue);
    }

    public TextFieldEditor(String name, String aLabelText, String defaultvalue, boolean editable) {
        super(name, aLabelText, defaultvalue);
        this.setEditable(editable);
    }

    public Object[] getEditorControls() {
        return new Control[]{this.getTextControl()};
    }

    public void doFillIntoGrid(Object aParent) {
        Assert.isTrue((boolean)(aParent instanceof Composite), (String)JBossESBUIMessages.Error_JBoss_Basic_Editor_Composite);
        Assert.isTrue((boolean)(((Composite)aParent).getLayout() instanceof GridLayout), (String)JBossESBUIMessages.Error_JBoss_Basic_Editor_Support);
        Composite aComposite = (Composite)aParent;
        this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)aParent).getLayout();
        this.getTextControl(aComposite);
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.fTextField.getTextControl().setLayoutData((Object)gd);
    }

    public Text getTextControl(Composite parent) {
        if (this.fTextField == null) {
            this.fTextField = new TextField(parent, this.getInitialStyle());
            Text textField = this.fTextField.getTextControl();
            textField.setFont(parent.getFont());
            textField.setText(this.getValue().toString());
            textField.setEditable(this.isEditable());
            textField.setEnabled(this.isEnabled());
            this.fTextField.addPropertyChangeListener(this);
        } else if (parent != null) {
            Assert.isTrue((parent == this.fTextField.getTextControl().getParent() ? 1 : 0) != 0);
        }
        return this.fTextField.getTextControl();
    }

    protected void updateWidgetValues() {
        this.setValueAsString(this.getValueAsString());
    }

    protected int getInitialStyle() {
        if (this.style >= 0) {
            return this.style;
        }
        return 2052;
    }

    private String checkCollection(Object value) {
        return value != null && ((Collection)value).size() > 0 ? this.prepareCollectionToString((Collection)value) : "";
    }

    private String prepareCollectionToString(Collection collection) {
        String stringValue = "";
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < objects.length) {
            stringValue = String.valueOf(stringValue) + objects[i];
            if (i < objects.length - 1) {
                stringValue = String.valueOf(stringValue) + " ";
            }
            ++i;
        }
        return stringValue;
    }

    private String checkSimple(Object value) {
        return value != null ? value.toString() : "";
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Text getTextControl() {
        return this.fTextField != null ? this.fTextField.getTextControl() : null;
    }

    public boolean setFocus() {
        boolean setfocus = false;
        if (this.fTextField != null && !this.fTextField.getTextControl().isDisposed()) {
            setfocus = this.fTextField.getTextControl().setFocus();
        }
        return setfocus;
    }

    public Object[] getEditorControls(Object composite) {
        return new Control[]{this.getTextControl((Composite)composite)};
    }

    public void save(Object object) {
    }

    public void setValue(Object newValue) {
        super.setValue(newValue);
        if (this.fTextField != null) {
            this.fTextField.removePropertyChangeListener(this);
            this.fTextField.getTextControl().setText(newValue.toString());
            this.fTextField.addPropertyChangeListener(this);
        }
    }

    public void setEditable(boolean aEditable) {
        super.setEditable(aEditable);
        if (this.getTextControl() != null) {
            this.getTextControl().setEditable(aEditable);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.setValue(evt.getNewValue());
    }
}

