/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUICore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;
import org.jboss.tools.esb.core.runtime.JBossRuntimeManager;
import org.jboss.tools.esb.project.ui.ESBProjectPlugin;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;

public class JBossESBRuntimeContainerPage
extends WizardPage
implements IClasspathContainerPage {
    private IClasspathEntry entry;
    private TableViewer runtimeViewer;
    private Object selectedRuntime;
    private Button manageRuntimes;

    public JBossESBRuntimeContainerPage() {
        super(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_Title);
        this.setTitle(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_Title);
        this.setDescription(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_Description);
    }

    public JBossESBRuntimeContainerPage(String pageName) {
        super(pageName);
    }

    public JBossESBRuntimeContainerPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new FormLayout());
        com.setLayoutData((Object)new GridData(1808));
        Table table = new Table(com, 2048);
        this.runtimeViewer = new TableViewer(table);
        this.runtimeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                JBossESBRuntimeContainerPage.this.selectedRuntime = selection.getFirstElement();
                JBossESBRuntimeContainerPage.this.setPageComplete(JBossESBRuntimeContainerPage.this.isPageComplete());
            }
        });
        this.runtimeViewer.addFilter((ViewerFilter)new ESBRuntimeFilter());
        TableLayout tablelayout = new TableLayout();
        table.setLayout((Layout)tablelayout);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        TableColumn tc1 = new TableColumn(table, 0);
        tc1.setText(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_Name);
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        TableColumn tc2 = new TableColumn(table, 0);
        tc2.setText(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_RuntimeType);
        tc1.pack();
        tc2.pack();
        table.setHeaderVisible(true);
        this.runtimeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.runtimeViewer.setLabelProvider((IBaseLabelProvider)new RuntimeLabelProvider());
        this.manageRuntimes = new Button(com, -1);
        this.manageRuntimes.setText(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_Manage_Runtimes_Button);
        this.manageRuntimes.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JBossESBRuntimeContainerPage.this.manageRuntimesPressed();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment(100, -5);
        this.manageRuntimes.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)this.manageRuntimes, -5);
        this.runtimeViewer.getTable().setLayoutData((Object)fd);
        this.runtimeViewer.setInput((Object)this.getAllAvailableESBRuntimes());
        this.setControl((Control)com);
    }

    protected void manageRuntimesPressed() {
        WorkbenchPreferenceDialog dialog = WorkbenchPreferenceDialog.createDialogOn((Shell)this.manageRuntimes.getShell(), (String)"org.jboss.tools.esb.project.runtime.preference");
        dialog.open();
        this.runtimeViewer.setInput((Object)this.getAllAvailableESBRuntimes());
    }

    public boolean finish() {
        StructuredSelection selection = (StructuredSelection)this.runtimeViewer.getSelection();
        Object obj = selection.getFirstElement();
        Path path = new Path("org.jboss.esb.runtime.classpath");
        if (obj instanceof IRuntime) {
            path = path.append("server.supplied");
            path = path.append(((IRuntime)obj).getId());
        } else if (obj instanceof JBossESBRuntime) {
            path = path.append(((JBossESBRuntime)obj).getName());
        }
        this.entry = JavaCore.newContainerEntry((IPath)path);
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.entry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.entry = containerEntry;
    }

    private List getAllAvailableESBRuntimes() {
        ArrayList<Object> runtimes = new ArrayList<Object>();
        JBossESBRuntime[] preRuntimes = JBossRuntimeManager.getInstance().getRuntimes();
        IRuntime[] serverRuntimes = ServerCore.getRuntimes();
        List<JBossESBRuntime> preList = Arrays.asList(preRuntimes);
        List<IRuntime> serverRuntimeList = Arrays.asList(serverRuntimes);
        runtimes.addAll(preList);
        runtimes.addAll(serverRuntimeList);
        return runtimes;
    }

    public boolean isPageComplete() {
        return this.selectedRuntime != null;
    }

    class ESBRuntimeFilter
    extends ViewerFilter {
        ESBRuntimeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IRuntime) {
                IPath location = ((IRuntime)element).getLocation();
                String runtimeType = ((IRuntime)element).getRuntimeType().getId();
                if (location == null) {
                    return false;
                }
                IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)((IRuntime)element).loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                if (jbossRuntime == null) {
                    return false;
                }
                return JBossRuntimeManager.isValidESBServer((String)location.toOSString(), (String)runtimeType, (String)jbossRuntime.getJBossConfiguration());
            }
            return true;
        }
    }

    class RuntimeLabelProvider
    implements ITableLabelProvider {
        private ILabelProvider serverLabel = ServerUICore.getLabelProvider();

        RuntimeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IRuntime) {
                    return this.serverLabel.getImage(element);
                }
                return ESBProjectPlugin.getDefault().getImageRegistry().get(JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_5);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof IRuntime) {
                        return this.serverLabel.getText(element);
                    }
                    if (!(element instanceof JBossESBRuntime)) break;
                    return ((JBossESBRuntime)element).getName();
                }
                case 1: {
                    if (element instanceof IRuntime) {
                        return JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_RuntimeType_ServerContained;
                    }
                    if (!(element instanceof JBossESBRuntime)) break;
                    return JBossESBUIMessages.JBoss_ESBRuntime_Classpath_Container_RuntimeType_ESBLibrariesOnly;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

