/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.ui.editor.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.ui.forms.ArrayToMap;
import org.jboss.tools.common.model.ui.forms.FormData;
import org.jboss.tools.common.model.ui.forms.IFormData;
import org.jboss.tools.common.model.ui.forms.IFormLayoutData;
import org.jboss.tools.common.model.ui.forms.ModelFormLayoutData;
import org.jboss.tools.common.model.util.ClassLoaderUtil;
import org.jboss.tools.esb.core.model.ESBConstants;
import org.jboss.tools.esb.ui.editor.form.ESBListsFormLayoutData;

public class ESBXMLFormLayoutData
implements IFormLayoutData,
ESBConstants {
    public static String EMPTY_DESCRIPTION;
    private static final IFormData[] FORM_LAYOUT_DEFINITIONS;
    private static Map<String, IFormData> FORM_LAYOUT_DEFINITION_MAP;
    private static ESBXMLFormLayoutData INSTANCE;

    static {
        ClassLoaderUtil.init();
        EMPTY_DESCRIPTION = "";
        FORM_LAYOUT_DEFINITIONS = new IFormData[0];
        FORM_LAYOUT_DEFINITION_MAP = Collections.synchronizedMap(new ArrayToMap(FORM_LAYOUT_DEFINITIONS));
        INSTANCE = new ESBXMLFormLayoutData();
    }

    public static IFormLayoutData getInstance() {
        return INSTANCE;
    }

    private ESBXMLFormLayoutData() {
    }

    public IFormData getFormData(String entityName) {
        IFormData data = FORM_LAYOUT_DEFINITION_MAP.get(entityName);
        if (data == null) {
            data = this.generateDefaultFormData(entityName);
        }
        return data;
    }

    private IFormData generateDefaultFormData(String entityName) {
        IFormData data = null;
        XModelEntity entity = XModelMetaDataImpl.getInstance().getEntity(entityName);
        if (entity != null) {
            data = this.generateDefaultFormData(entity);
        }
        if (data != null) {
            FORM_LAYOUT_DEFINITION_MAP.put(entityName, data);
        }
        return data;
    }

    public IFormData generateDefaultFormData(XModelEntity entity) {
        String entityName = entity.getName();
        ArrayList<IFormData> list = new ArrayList<IFormData>();
        IFormData g = ModelFormLayoutData.createGeneralFormData((XModelEntity)entity);
        if (entityName.equals("ESBAction101") || entityName.equals("ESBAction120")) {
            g = new FormData("org.jboss.tools.esb.ui.editor.form.ESBActionForm");
        }
        if (g != null) {
            list.add(g);
        }
        if (entityName.startsWith("ESBPreAction")) {
            if (entity.getChild("ESBPreRouteTo") != null) {
                list.add(ESBListsFormLayoutData.ESB_ROUTE_LIST_DEFINITION);
            }
            if (entity.getChild("ESBPreBPMVar") != null) {
                list.add(ESBListsFormLayoutData.BPM_VAR_LIST_DEFINITION);
            }
            if (entity.getChild("ESBPreRouterNamespace") != null) {
                list.add(ESBListsFormLayoutData.ROUTER_NAMESPACE_LIST_DEFINITION);
            }
            if (entity.getChild("ESBPreNotificationList") != null || entity.getChild("ESBPreNotificationList120") != null) {
                list.add(ESBListsFormLayoutData.ESB_NOTIFICATION_LIST_DEFINITION);
            }
        } else if (entity.getChild("ESBProperty") != null) {
            list.add(ESBListsFormLayoutData.ESB_PROPERTY_LIST_DEFINITION);
        } else if (entityName.startsWith("ESBListeners")) {
            list.add(ESBListsFormLayoutData.ESB_LISTENER_LIST_DEFINITION);
        } else if (entityName.equals("ESBActions101")) {
            list.add(ESBListsFormLayoutData.ESB_ACTION_101_LIST_DEFINITION);
        } else if (entityName.equals("ESBActions110")) {
            list.add(ESBListsFormLayoutData.ESB_ACTION_110_LIST_DEFINITION);
        } else if (entityName.equals("ESBActions120")) {
            list.add(ESBListsFormLayoutData.ESB_ACTION_120_LIST_DEFINITION);
        } else if (entityName.startsWith("ESBServices")) {
            list.add(ESBListsFormLayoutData.ESB_SERVICE_LIST_DEFINITION);
        } else if (entityName.startsWith("ESBService")) {
            list.add(ESBListsFormLayoutData.ESB_LISTENER_SUB_LIST_DEFINITION);
            list.add(ESBListsFormLayoutData.ESB_ACTION_SUB_LIST_DEFINITION);
        } else if (entityName.startsWith("ESBProviders")) {
            list.add(ESBListsFormLayoutData.ESB_PROVIDER_LIST_DEFINITION);
        } else if (entityName.startsWith("FileESB")) {
            list.add(ESBListsFormLayoutData.ESB_PROVIDER_SUB_LIST_DEFINITION);
            list.add(ESBListsFormLayoutData.ESB_SERVICE_SUB_LIST_DEFINITION);
        } else if (entityName.equals("ESBProperty")) {
            list.add(ModelFormLayoutData.TAG_LIST);
        } else if (entityName.equals("ESBPreNotificationList")) {
            list.add(ESBListsFormLayoutData.ESB_TARGET_LIST_DEFINITION);
        } else if (entityName.equals("ESBPreNotificationList120")) {
            list.add(ESBListsFormLayoutData.ESB_TARGET_120_LIST_DEFINITION);
        }
        if (entityName.equals("ESBScheduleProvider101")) {
            list.add(ESBListsFormLayoutData.ESB_SCHEDULE_LIST_DEFINITION);
        }
        if (entity.getChild("ESBBus") != null) {
            list.add(ESBListsFormLayoutData.ESB_BUS_LIST_DEFINITION);
        }
        int i = 0;
        while (i < entity.getChildren().length) {
            String ce = entity.getChildren()[i].getName();
            if (ESBListsFormLayoutData.singleChildLists.containsKey(ce)) {
                list.add(ESBListsFormLayoutData.singleChildLists.get(ce));
            }
            ++i;
        }
        IFormData a = ModelFormLayoutData.createAdvancedFormData((String)entityName);
        if (a != null) {
            list.add(a);
        }
        IFormData[] ds = list.toArray(new IFormData[0]);
        FormData data = new FormData(entityName, new String[0], ds);
        return data;
    }
}

