/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.common.model.ui.wizards.NewClassWizard;
import org.jboss.tools.common.model.ui.wizards.NewTypeWizardAdapter;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.esb.ui.ESBUIMessages;
import org.jboss.tools.esb.ui.ESBUiPlugin;

public class NewActionWizard
extends NewClassWizard
implements INewWizard {
    boolean openCreatedType = false;

    public NewActionWizard() {
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(ESBUIMessages.newESBActionWizardTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
    }

    public void addPages() {
        super.addPages();
        this.mainPage.setTitle(ESBUIMessages.newESBActionWizardPageTitle);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.mainPage.createType(monitor);
        if (this.mainPage.getCreatedType() != null) {
            this.modifyJavaSource();
        }
    }

    public boolean performFinish() {
        boolean b = super.performFinish();
        if (b && this.openCreatedType) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        JavaUI.openInEditor((IJavaElement)NewActionWizard.this.mainPage.getCreatedType());
                    }
                    catch (CoreException e) {
                        ESBUiPlugin.getDefault();
                        ESBUiPlugin.log(e);
                    }
                }
            });
        }
        return b;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject p = this.getProject(selection);
        this.adapter = new NewTypeWizardAdapter(p);
        this.adapter.setRawSuperClassName("org.jboss.soa.esb.actions.AbstractActionPipelineProcessor");
        IPackageFragment f = this.getPackageFragment(selection);
        if (f != null) {
            String name = "";
            IPackageFragment cf = f;
            while (cf != null) {
                name = name.length() == 0 ? cf.getElementName() : String.valueOf(cf.getElementName()) + "." + name;
                IPackageFragment iPackageFragment = cf = cf.getParent() instanceof IPackageFragment ? (IPackageFragment)cf.getParent() : null;
            }
            this.adapter.setRawPackageName(name);
        }
        this.adapter.setRawClassName("");
        this.openCreatedType = true;
    }

    IProject getProject(IStructuredSelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IProject) {
            return (IProject)o;
        }
        if (o instanceof IJavaElement) {
            IJavaElement e = (IJavaElement)o;
            return e.getJavaProject().getProject();
        }
        if (o instanceof IAdaptable) {
            return (IProject)((IAdaptable)o).getAdapter(IProject.class);
        }
        return null;
    }

    IPackageFragment getPackageFragment(IStructuredSelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IPackageFragment) {
            return (IPackageFragment)o;
        }
        return null;
    }

    void modifyJavaSource() {
        try {
            IType type = this.mainPage.getCreatedType();
            if (type == null) {
                return;
            }
            String name = type.getElementName();
            String sc = type.getSuperclassTypeSignature();
            if (sc != null) {
                sc = EclipseJavaUtil.resolveTypeAsString((IType)type, (String)sc);
            }
            if (type != null && "org.jboss.soa.esb.actions.AbstractActionPipelineProcessor".equals(sc)) {
                ICompilationUnit w = type.getCompilationUnit().getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                IBuffer b = w.getBuffer();
                String s = b.getContents();
                String lineDelimiter = "\r\n";
                String IMPORT = "import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;";
                int i1 = s.indexOf(IMPORT);
                if (i1 >= 0) {
                    String[] imports;
                    String content = "";
                    String[] stringArray = imports = new String[]{"import org.jboss.soa.esb.actions.ActionProcessingException;", "import org.jboss.soa.esb.helpers.ConfigTree;", "import org.jboss.soa.esb.message.Message;"};
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String is = stringArray[n2];
                        if (s.indexOf(is) < 0) {
                            content = String.valueOf(content) + lineDelimiter + is;
                        }
                        ++n2;
                    }
                    if (content.length() > 0) {
                        b.replace(i1 + IMPORT.length(), 0, content);
                    }
                }
                boolean hasOverrideAnnotation = (s = b.getContents()).indexOf("@Override") > 0;
                int i = s.indexOf(123);
                int j = s.lastIndexOf(125);
                if (i > 0 && j > i) {
                    String tab = "\t";
                    String content = String.valueOf(lineDelimiter) + tab + "protected ConfigTree _config;" + lineDelimiter + lineDelimiter + tab + "public " + name + "(ConfigTree config) {" + lineDelimiter + tab + tab + "_config = config;" + lineDelimiter + tab + "}" + lineDelimiter + lineDelimiter + (hasOverrideAnnotation ? String.valueOf(tab) + "@Override" + lineDelimiter : "") + tab + "public Message process(Message message) throws ActionProcessingException {" + lineDelimiter + tab + tab + "//ADD CUSTOM ACTION CODE HERE" + lineDelimiter + tab + tab + "return message;" + lineDelimiter + tab + "}" + lineDelimiter;
                    b.replace(i + 1, j - i - 1, content);
                    w.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

