/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.model;

import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ModelBuilder {
    public static final String NAMESPACE = "http://www.jboss.org/xsd/tools/smooks";
    public static final String REQUIRED = "#required";
    public static final String OPTIONAL = "#optional";
    private static final String HIDDEN_ELEMENT = "hidden";
    private Properties namespaces = new Properties();

    public abstract Document buildModel() throws ModelBuilderException;

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public static void hideFragment(Element fragment) {
        fragment.setAttributeNS(NAMESPACE, HIDDEN_ELEMENT, "true");
    }

    public static void unhideFragment(Element fragment) {
        fragment.removeAttributeNS(NAMESPACE, HIDDEN_ELEMENT);
    }

    public static boolean isHidden(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 2: {
                    return ModelBuilder.isHidden(node.getParentNode());
                }
                case 1: {
                    if (((Element)node).getAttributeNS(NAMESPACE, HIDDEN_ELEMENT).equals("true")) {
                        return true;
                    }
                    return ModelBuilder.isHidden(node.getParentNode());
                }
            }
        }
        return false;
    }

    public static boolean isRequired(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 2: {
                    return REQUIRED.equals(node.getTextContent()) || "http://www.w3.org/XML/1998/namespace".equals(node.getNamespaceURI());
                }
                case 1: {
                    if (ModelBuilder.getMinOccurs((Element)node) <= 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInReservedNamespace(Node node) {
        if (node != null) {
            return NAMESPACE.equals(node.getNamespaceURI());
        }
        return false;
    }

    protected Document createModelInstance() throws ModelBuilderException {
        DocumentBuilder builder;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ModelBuilderException("Error constructing DOM DocumentBuilder.", e);
        }
        return builder.newDocument();
    }

    public static void setMinMax(Element element, int minOccurs, int maxOccurs) {
        element.setAttributeNS(NAMESPACE, "smk:minOccurs", Integer.toString(minOccurs));
        element.setAttributeNS(NAMESPACE, "smk:maxOccurs", Integer.toString(maxOccurs));
    }

    public static Node getParentNode(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public static int getMinOccurs(Element element) {
        String minOccurs = element.getAttributeNS(NAMESPACE, "minOccurs");
        if (minOccurs.equals("")) {
            return 1;
        }
        return Integer.parseInt(minOccurs);
    }

    public static int getMaxOccurs(Element element) {
        String maxOccurs = element.getAttributeNS(NAMESPACE, "maxOccurs");
        if (maxOccurs.equals("")) {
            return 1;
        }
        return Integer.parseInt(maxOccurs);
    }

    public static boolean isCollection(Element element) {
        int maxOccurs = ModelBuilder.getMaxOccurs(element);
        return maxOccurs > 1 || maxOccurs == -1;
    }

    public static void setElementType(Element element, ElementType type) {
        element.setAttributeNS(NAMESPACE, "smk:elementType", type.toString());
    }

    public static ElementType getElementType(Element element) {
        String elementType = element.getAttributeNS(NAMESPACE, "elementType");
        if (elementType == null || elementType.length() == 0) {
            return null;
        }
        return ElementType.valueOf(elementType);
    }

    public static Element createCompositor(Document document) {
        return document.createElementNS(NAMESPACE, "smk:compositor");
    }

    public static boolean isCompositor(Node node) {
        return node.getNodeType() == 1 && DomUtils.getName((Element)((Element)node)).equals("compositor") && NAMESPACE.equals(node.getNamespaceURI());
    }

    public static void setEnforceCollectionSubMappingRules(Element element, boolean enforce) {
        element.setAttributeNS(NAMESPACE, "smk:enforceCollectionSubMappingRules", Boolean.toString(enforce));
    }

    public static boolean getEnforceCollectionSubMappingRules(Element element) {
        String enforce = element.getAttributeNS(NAMESPACE, "enforceCollectionSubMappingRules");
        if (enforce == null || enforce.length() == 0) {
            return true;
        }
        return !enforce.equals("false");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        simple,
        complex;

    }
}

