/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.model.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.model.xml.Messages;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSampleModelBuilder
extends ModelBuilder {
    private static DocumentBuilder docBuilder;
    private Document model;

    static {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(Messages.XMLSampleModelBuilder_UnexpectedXMLException, e);
        }
    }

    public XMLSampleModelBuilder(URI xmlSampleURI) throws IOException, ModelBuilderException {
        Assert.isNotNull((Object)xmlSampleURI, (String)"Null 'xmlSampleURI' arg in method call.");
        File xmlSampleFile = new File(xmlSampleURI.toFileString());
        if (!xmlSampleFile.exists()) {
            throw new IOException("XML Sample '" + xmlSampleFile.getAbsolutePath() + "' not found.");
        }
        if (!xmlSampleFile.isFile()) {
            throw new IOException("XML Sample '" + xmlSampleFile.getAbsolutePath() + "' is not a normal file.  Might be a directory etc.");
        }
        try {
            this.model = docBuilder.parse(xmlSampleFile);
        }
        catch (SAXException e) {
            throw new ModelBuilderException("Error parsing XML Sample file.", e);
        }
        Element documentElement = this.model.getDocumentElement();
        this.trimNonModelNodes(documentElement);
        this.configureModelElementTypes(documentElement);
        this.configureModelElementCardinality(documentElement);
        this.registerNamepsaces(documentElement);
    }

    private void trimNonModelNodes(Element element) {
        NodeList children = element.getChildNodes();
        ArrayList<Node> removeableChildren = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.trimNonModelNodes((Element)child);
            } else {
                removeableChildren.add(child);
            }
            ++i;
        }
        for (Node child : removeableChildren) {
            element.removeChild(child);
        }
    }

    private void configureModelElementTypes(Element element) {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        if (childCount > 0) {
            ModelBuilder.setElementType(element, ModelBuilder.ElementType.complex);
            int i = 0;
            while (i < childCount) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) {
                    throw new IllegalStateException("The configureModelElementTypes method can only be called after the model has been trimed of non-model Nodes.  Call trimNonModelNodes() before calling configureModelElementTypes().");
                }
                this.configureModelElementTypes((Element)child);
                ++i;
            }
        } else {
            ModelBuilder.setElementType(element, ModelBuilder.ElementType.simple);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureModelElementCardinality(Element element) {
        void var6_7;
        NodeList children = element.getChildNodes();
        ArrayList<Element> removeableChildren = new ArrayList<Element>();
        int childCount = children.getLength();
        HashMap childElementByNames = new HashMap();
        boolean bl = false;
        while (var6_7 < childCount) {
            Element childElement;
            Node child = children.item((int)var6_7);
            if (child.getNodeType() == 1) {
                childElement = (Element)child;
                String elementName = String.valueOf(DomUtils.getName((Element)childElement)) + ":" + childElement.getNamespaceURI();
                Element earlierOccurance = (Element)childElementByNames.get(elementName);
                ModelBuilder.setMinMax(childElement, 0, -1);
                if (earlierOccurance != null) {
                    ModelBuilder.setEnforceCollectionSubMappingRules(earlierOccurance, true);
                    removeableChildren.add(childElement);
                } else {
                    ModelBuilder.setEnforceCollectionSubMappingRules(childElement, false);
                }
            } else {
                throw new IllegalStateException("The configureModelElementTypes method can only be called after the model has been trimed of non-model Nodes.  Call trimNonModelNodes() before calling configureModelElementTypes().");
            }
            this.configureModelElementCardinality(childElement);
            ++var6_7;
        }
        for (Node node : removeableChildren) {
            element.removeChild(node);
        }
    }

    private void registerNamepsaces(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            this.registerNamespace(attributes.item(i));
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.registerNamespace(child);
                this.registerNamepsaces((Element)child);
            }
            ++i2;
        }
    }

    private void registerNamespace(Node node) {
        String nsPrefix = node.getPrefix();
        String nsURI = node.getNamespaceURI();
        if (nsPrefix != null && nsURI != null) {
            this.getNamespaces().setProperty(nsPrefix, nsURI);
        }
    }

    public Document buildModel() throws ModelBuilderException {
        return this.model;
    }
}

