/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.model.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDModelBuilder
extends ModelBuilder {
    private Map<String, XSDElementDeclaration> elements = new LinkedHashMap<String, XSDElementDeclaration>();
    private Map<String, XSDTypeDefinition> types = new LinkedHashMap<String, XSDTypeDefinition>();
    private Set<String> loadedSchemas = new HashSet<String>();
    private Stack<XSDTypeDefinition> elementExpandStack = new Stack();
    private String rootElementName;
    private Properties nsPrefixes = new Properties();

    public XSDModelBuilder(URI schemaURI) throws IOException, ModelBuilderException {
        this.loadSchema(schemaURI);
    }

    public Set<String> getRootElementNames() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public void setRootElementName(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    @Override
    public Document buildModel() throws ModelBuilderException {
        if (this.rootElementName == null) {
            throw new IllegalStateException("The 'rootElementName' property has not been set.");
        }
        XSDElementDeclaration rootElement = this.elements.get(this.rootElementName);
        if (rootElement == null) {
            throw new IllegalArgumentException("Unknown root element '" + this.rootElementName + "'.");
        }
        Document model = this.createModelInstance();
        this.expand(rootElement, 1, 1, model, model);
        return model;
    }

    /*
     * Unable to fully structure code
     */
    public void validate(Document message) throws SAXException, IOException {
        xsdSources = new StreamSource[this.loadedSchemas.size()];
        i = 0;
        try {
            for (String schemaPath : this.loadedSchemas) {
                schemaFile = new File(schemaPath);
                if (!schemaFile.exists()) {
                    throw new IOException("XSD '" + schemaFile.getAbsolutePath() + "' not found.");
                }
                xsdSources[i] = new StreamSource(new FileInputStream(schemaFile));
                ++i;
            }
            schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = schemaFactory.newSchema(xsdSources);
            validator = schema.newValidator();
            validator.validate(new DOMSource(message));
        }
        finally {
            var11_9 = xsdSources;
            var10_11 = xsdSources.length;
            var9_13 = 0;
            ** while (var9_13 < var10_11)
        }
lbl-1000:
        // 1 sources

        {
            schemaStream = var11_9[var9_13];
            try {
                schemaStream.getInputStream().close();
            }
            catch (Exception v0) {}
            ++var9_13;
            continue;
        }
lbl28:
        // 1 sources

    }

    private void loadSchema(URI schemaURI) throws IOException, ModelBuilderException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        Resource resource = resourceSet.getResource(schemaURI, true);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put(XSDResourceImpl.XSD_TRACK_LOCATION, true);
        resource.load(options);
        if (resource.getContents().isEmpty()) {
            throw new ModelBuilderException("Failed to load schema '" + schemaURI + "'.");
        }
        XSDSchema schema = (XSDSchema)resource.getContents().get(0);
        EList elementDeclarations = schema.getElementDeclarations();
        for (XSDElementDeclaration elementDeclaration : elementDeclarations) {
            if (elementDeclaration.isAbstract()) continue;
            this.elements.put(elementDeclaration.getName(), elementDeclaration);
        }
        EList typeDefs = schema.getTypeDefinitions();
        int i = 0;
        while (i < typeDefs.size()) {
            XSDTypeDefinition type = (XSDTypeDefinition)typeDefs.get(i);
            this.types.put(type.getName(), type);
            ++i;
        }
        EList schemaResources = resourceSet.getResources();
        for (Resource schemaRes : schemaResources) {
            this.loadedSchemas.add(schemaRes.getURI().toFileString());
        }
    }

    private void expand(XSDElementDeclaration elementDeclaration, int minOccurs, int maxOccurs, Node parent, Document document) {
        XSDTypeDefinition typeDef;
        if (elementDeclaration.isElementDeclarationReference()) {
            elementDeclaration = elementDeclaration.getResolvedElementDeclaration();
            typeDef = elementDeclaration.getTypeDefinition();
        } else {
            typeDef = elementDeclaration.getTypeDefinition();
        }
        String elementName = elementDeclaration.getName();
        if (elementDeclaration.isAbstract()) {
            if (typeDef != null) {
                this.addTypeImpls(typeDef, minOccurs, maxOccurs, parent, document);
            }
            return;
        }
        if (this.elementExpandStack.contains(typeDef)) {
            return;
        }
        this.elementExpandStack.push(typeDef);
        try {
            Element element;
            String elementNS = elementDeclaration.getTargetNamespace();
            if (elementNS == null || elementNS.equals("http://www.w3.org/2001/XMLSchema")) {
                element = document.createElement(elementName);
            } else {
                String nsPrefix = this.getPrefix(elementNS);
                element = document.createElementNS(elementNS, String.valueOf(nsPrefix) + ":" + elementName);
                this.getNamespaces().setProperty(nsPrefix, elementNS);
            }
            XSDModelBuilder.setMinMax(element, minOccurs, maxOccurs);
            parent.appendChild(element);
            if (typeDef instanceof XSDComplexTypeDefinition) {
                ModelBuilder.setElementType(element, ModelBuilder.ElementType.complex);
                this.processComplexType(document, element, (XSDComplexTypeDefinition)typeDef);
            } else if (typeDef instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition simpleTypeDef = (XSDSimpleTypeDefinition)typeDef;
                XSDTypeDefinition loadedType = this.types.get(simpleTypeDef.getName());
                if (loadedType instanceof XSDComplexTypeDefinition) {
                    ModelBuilder.setElementType(element, ModelBuilder.ElementType.complex);
                    this.processComplexType(document, element, (XSDComplexTypeDefinition)loadedType);
                } else {
                    ModelBuilder.setElementType(element, ModelBuilder.ElementType.simple);
                }
            } else if (typeDef != null) {
                System.out.println("?? " + typeDef);
            }
        }
        finally {
            this.elementExpandStack.pop();
        }
    }

    private String getPrefix(String elementNS) {
        String nsPrefix = this.nsPrefixes.getProperty(elementNS);
        if (nsPrefix == null) {
            nsPrefix = "ns" + this.nsPrefixes.size();
            this.nsPrefixes.setProperty(elementNS, nsPrefix);
        }
        return nsPrefix;
    }

    private void processComplexType(Document document, Element element, XSDComplexTypeDefinition complexTypeDef) {
        XSDParticleContent particleContent;
        XSDParticle particle = complexTypeDef.getComplexType();
        EList attributes = complexTypeDef.getAttributeContents();
        this.addAttributes(element, attributes);
        if (particle != null && (particleContent = particle.getContent()) instanceof XSDModelGroup) {
            this.processModelGroup((XSDModelGroup)particleContent, particle.getMinOccurs(), particle.getMaxOccurs(), element, document);
        }
    }

    private void processModelGroup(XSDModelGroup modelGroup, int minOccurs, int maxOccurs, Element element, Document document) {
        EList particles = modelGroup.getParticles();
        XSDCompositor compositor = modelGroup.getCompositor();
        String compositorType = compositor.getName();
        if (particles.size() > 1 && compositorType.equals("choice")) {
            Element compositorEl = ModelBuilder.createCompositor(document);
            compositorEl.setAttribute("type", compositorType);
            XSDModelBuilder.setMinMax(compositorEl, minOccurs, maxOccurs);
            element.appendChild(compositorEl);
            element = compositorEl;
        }
        for (XSDParticle particle : particles) {
            XSDParticleContent content = particle.getContent();
            if (content instanceof XSDElementDeclaration) {
                this.expand((XSDElementDeclaration)content, particle.getMinOccurs(), particle.getMaxOccurs(), element, document);
                continue;
            }
            if (!(content instanceof XSDModelGroup)) continue;
            this.processModelGroup((XSDModelGroup)content, particle.getMinOccurs(), particle.getMaxOccurs(), element, document);
        }
    }

    private void addTypeImpls(XSDTypeDefinition baseType, int minOccurs, int maxOccurs, Node parent, Document document) {
        Set<Map.Entry<String, XSDElementDeclaration>> elementEntrySet = this.elements.entrySet();
        for (Map.Entry<String, XSDElementDeclaration> elementEntry : elementEntrySet) {
            XSDElementDeclaration elementDecl = elementEntry.getValue();
            if (!this.isInstanceOf(baseType, elementDecl.getType())) continue;
            this.expand(elementDecl, minOccurs, maxOccurs, parent, document);
        }
    }

    private void addAttributes(Element element, EList attributes) {
        if (attributes != null) {
            int i = 0;
            while (i < attributes.size()) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)attributes.get(i);
                XSDAttributeDeclaration attributeDecl = attributeUse.getAttributeDeclaration();
                attributeDecl.getTypeDefinition();
                String name = attributeDecl.getName();
                String attributeNS = attributeDecl.getTargetNamespace();
                String value = "";
                XSDAttributeUseCategory use = attributeUse.getUse();
                value = use == XSDAttributeUseCategory.REQUIRED_LITERAL ? "#required" : (attributeUse.getValue() != null ? "#optional=" + attributeUse.getValue().toString() : "#optional");
                if (attributeNS == null || attributeNS.equals("http://www.w3.org/2001/XMLSchema")) {
                    element.setAttribute(name, value);
                } else {
                    String nsPrefix = this.getPrefix(attributeNS);
                    element.setAttributeNS(attributeNS, String.valueOf(nsPrefix) + ":" + name, value);
                    this.getNamespaces().setProperty(nsPrefix, attributeNS);
                }
                ++i;
            }
        }
    }

    private boolean isInstanceOf(XSDTypeDefinition baseType, XSDTypeDefinition type) {
        if (type == null) {
            return false;
        }
        if (type.equals(baseType)) {
            return true;
        }
        if (type.equals(type.getBaseType())) {
            return false;
        }
        return this.isInstanceOf(baseType, type.getBaseType());
    }
}

