/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.template;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.model.ModelNodeResolver;
import org.jboss.tools.smooks.templating.template.CollectionMapping;
import org.jboss.tools.smooks.templating.template.Mapping;
import org.jboss.tools.smooks.templating.template.ValueMapping;
import org.jboss.tools.smooks.templating.template.exception.InvalidMappingException;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;
import org.jboss.tools.smooks.templating.template.exception.UnmappedCollectionNodeException;
import org.jboss.tools.smooks.templating.template.util.FreeMarkerUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateBuilder {
    private ModelBuilder modelBuilder;
    private Document model;
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private XPathFactory xpathFactory = XPathFactory.newInstance();
    private XPathNamespaceContext namespaceContext;

    public TemplateBuilder(ModelBuilder modelBuilder) throws ModelBuilderException {
        Assert.isNotNull((Object)modelBuilder, (String)"modelBuilder");
        this.modelBuilder = modelBuilder;
        this.model = modelBuilder.buildModel();
        this.namespaceContext = new XPathNamespaceContext(modelBuilder.getNamespaces());
    }

    public abstract String buildTemplate() throws TemplateBuilderException;

    public Document getModel() {
        return this.model;
    }

    public Node getModelNode(String xpathExpr) throws XPathExpressionException {
        XPath xpath = this.xpathFactory.newXPath();
        xpath.setNamespaceContext(this.namespaceContext);
        return (Node)xpath.evaluate(xpathExpr, this.model, XPathConstants.NODE);
    }

    public ModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public ValueMapping addValueMapping(String srcPath, Node modelPath) throws InvalidMappingException {
        this.asserValidMappingNode(modelPath);
        this.assertCollectionsMapped(modelPath);
        ValueMapping mapping = new ValueMapping(srcPath, modelPath);
        this.mappings.add(mapping);
        this.addHideNodes(modelPath, mapping);
        return mapping;
    }

    public CollectionMapping addCollectionMapping(String srcCollectionPath, Element modelCollectionPath, String collectionItemName) throws InvalidMappingException {
        this.asserValidMappingNode(modelCollectionPath);
        this.assertCollectionsMapped(modelCollectionPath.getParentNode());
        CollectionMapping mapping = new CollectionMapping(srcCollectionPath, modelCollectionPath, collectionItemName);
        this.mappings.add(mapping);
        this.addHideNodes(modelCollectionPath, mapping);
        return mapping;
    }

    public List<Node> removeMapping(Mapping mapping) {
        ArrayList<Node> showNodes = new ArrayList<Node>();
        this.mappings.remove(mapping);
        List<Node> hideNodes = mapping.getHideNodes();
        if (hideNodes != null) {
            for (Node hiddenNode : hideNodes) {
                if (hiddenNode.getNodeType() != 1 || this.isOnMappingPath((Element)hiddenNode)) continue;
                ModelBuilder.unhideFragment((Element)hiddenNode);
                showNodes.add(hiddenNode);
            }
        }
        return showNodes;
    }

    private void addHideNodes(Node modelPath, Mapping mapping) {
        Node parent = ModelBuilder.getParentNode(modelPath);
        while (parent != null) {
            if (ModelBuilder.isCompositor(parent)) {
                Element compositor = (Element)parent;
                int maxOccurs = ModelBuilder.getMaxOccurs(compositor);
                int numElementsOnMappingPath = this.getNumElementsOnMappingPath(compositor);
                if (numElementsOnMappingPath == maxOccurs) {
                    this.hideUnmappedPaths(compositor, mapping);
                }
            }
            parent = ModelBuilder.getParentNode(parent);
        }
    }

    private void hideUnmappedPaths(Element compositor, Mapping mapping) {
        NodeList children = compositor.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Element nodeToHide;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && !this.isOnMappingPath(nodeToHide = (Element)child)) {
                mapping.addHideNode(nodeToHide);
                ModelBuilder.hideFragment(nodeToHide);
            }
            ++i;
        }
    }

    private int getNumElementsOnMappingPath(Element compositor) {
        NodeList children = compositor.getChildNodes();
        int numChildren = children.getLength();
        int count = 0;
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && this.isOnMappingPath((Element)child)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    private void asserValidMappingNode(Node mappingNode) throws InvalidMappingException {
        if (mappingNode == null) {
            throw new InvalidMappingException("Node is null.");
        }
        if (mappingNode.getNodeType() != 2 && mappingNode.getNodeType() != 1) {
            throw new InvalidMappingException("Unsupported XML target node mapping.  Support XML elements and attributes only.");
        }
        if ("http://www.jboss.org/xsd/tools/smooks".equals(mappingNode.getNamespaceURI())) {
            throw new InvalidMappingException("Unsupported XML target node mapping.  Cannot map to a reserved model node from the 'http://www.jboss.org/xsd/tools/smooks' namespace.");
        }
        if (ModelBuilder.isHidden(mappingNode)) {
            throw new InvalidMappingException("Illegal XML target node mapping for node '" + mappingNode + "'.  This node (or one of it's ancestors) is hidden.");
        }
    }

    private void assertCollectionsMapped(Node mappingNode) throws UnmappedCollectionNodeException {
        CollectionMapping parentCollectionMapping;
        Element collectionElement = this.getNearestCollectionElement(mappingNode);
        if (collectionElement != null && (parentCollectionMapping = this.getCollectionMapping(collectionElement)) == null && ModelBuilder.getEnforceCollectionSubMappingRules(collectionElement)) {
            throw new UnmappedCollectionNodeException(collectionElement);
        }
    }

    public Element getNearestCollectionElement(Node modelPath) {
        Node nextNode = modelPath;
        while (nextNode != null) {
            if (nextNode.getNodeType() == 1 && ModelBuilder.isCollection((Element)nextNode)) {
                return (Element)nextNode;
            }
            nextNode = ModelBuilder.getParentNode(nextNode);
        }
        return null;
    }

    protected CollectionMapping getCollectionMapping(Element collectionElement) {
        Mapping mapping = this.getMapping(collectionElement);
        if (mapping instanceof CollectionMapping) {
            return (CollectionMapping)mapping;
        }
        return null;
    }

    protected Mapping getMapping(Node node) {
        for (Mapping mapping : this.mappings) {
            if (mapping.getMappingNode() != node) continue;
            return mapping;
        }
        return null;
    }

    protected boolean assertAddNodeToTemplate(Element element) {
        if (ModelBuilder.isInReservedNamespace(element)) {
            return false;
        }
        if (ModelBuilder.isHidden(element)) {
            return false;
        }
        return ModelBuilder.getMinOccurs(element) != 0 || this.isOnMappingPath(element);
    }

    public boolean isOnMappingPath(Element element) {
        for (Mapping mapping : this.mappings) {
            Node pathNode = mapping.getMappingNode();
            while (pathNode != null) {
                if (element == pathNode) {
                    return true;
                }
                pathNode = ModelBuilder.getParentNode(pathNode);
            }
        }
        return false;
    }

    protected void addCollectionMapping(Element element, ModelNodeResolver modelNodeResolver) throws TemplateBuilderException {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        int i = 0;
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Node targetModelNode = modelNodeResolver.resolveNodeMapping(child);
                String srcPath = element.getAttributeNS("http://www.jboss.org/xsd/tools/smooks", "srcPath");
                String collectionItemName = element.getAttributeNS("http://www.jboss.org/xsd/tools/smooks", "collectionItemName");
                this.addCollectionMapping(srcPath, (Element)targetModelNode, collectionItemName);
                return;
            }
            ++i;
        }
        throw new TemplateBuilderException("Unexpected Exception.  Invalid <smk:list> collection node.  Has no child elements!");
    }

    protected void addValueMapping(Node modelNode, ModelNodeResolver modelNodeResolver, String dollarVariable) throws TemplateBuilderException, InvalidMappingException {
        Node targetModelNode = modelNodeResolver.resolveNodeMapping(modelNode);
        this.addValueMapping(targetModelNode, dollarVariable);
    }

    protected void addValueMapping(Node modelNode, String dollarVariable) throws TemplateBuilderException, InvalidMappingException {
        String srcPath = FreeMarkerUtil.extractJavaPath(dollarVariable);
        String rawFormatting = FreeMarkerUtil.extractRawFormatting(dollarVariable);
        ValueMapping mapping = this.addValueMapping(srcPath, modelNode);
        if (rawFormatting != null) {
            Properties encodeProperties = new Properties();
            encodeProperties.setProperty(ValueMapping.RAW_FORMATING_KEY, rawFormatting);
            mapping.setEncodeProperties(encodeProperties);
        }
    }

    public static void writeListStart(StringWriter writer, String srcPath, String collectionItemName) {
        writer.write("<smk:list smk:srcPath=\"" + srcPath + "\" smk:collectionItemName=\"" + collectionItemName + "\" xmlns:smk=\"" + "http://www.jboss.org/xsd/tools/smooks" + "\">");
    }

    public static void writeListEnd(StringWriter writer) {
        writer.write("</smk:list>");
    }

    public static boolean isListElement(Element element) {
        return ModelBuilder.isInReservedNamespace(element) && DomUtils.getName((Element)element).equals("list");
    }

    protected static void writeIndent(int indent, Writer writer) {
        try {
            int i = 0;
            while (i < indent * 4) {
                writer.write(32);
                ++i;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException writing template.", e);
        }
    }

    private class XPathNamespaceContext
    implements NamespaceContext {
        private Properties namespaces;

        private XPathNamespaceContext(Properties namespaces) {
            this.namespaces = namespaces;
        }

        public String getNamespaceURI(String prefix) {
            if (prefix.equals("smk")) {
                return "http://www.jboss.org/xsd/tools/smooks";
            }
            return this.namespaces.getProperty(prefix);
        }

        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

