/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.template.csv;

import au.com.bytecode.opencsv.CSVReader;
import freemarker.core.TemplateElement;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.template.CollectionMapping;
import org.jboss.tools.smooks.templating.template.Mapping;
import org.jboss.tools.smooks.templating.template.TemplateBuilder;
import org.jboss.tools.smooks.templating.template.ValueMapping;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;
import org.jboss.tools.smooks.templating.template.exception.UnmappedCollectionNodeException;
import org.jboss.tools.smooks.templating.template.util.FreeMarkerUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSVFreeMarkerTemplateBuilder
extends TemplateBuilder {
    private char separatorChar;
    private char quoteChar;
    private boolean includeFieldNames;

    public CSVFreeMarkerTemplateBuilder(ModelBuilder modelBuilder, char separatorChar, char quoteChar, boolean includeFieldNames) throws ModelBuilderException {
        super(modelBuilder);
        this.separatorChar = separatorChar;
        this.quoteChar = quoteChar;
        this.includeFieldNames = includeFieldNames;
    }

    public CSVFreeMarkerTemplateBuilder(ModelBuilder modelBuilder, char separatorChar, char quoteChar, boolean includeFieldNames, String ftlTemplate) throws ModelBuilderException, TemplateBuilderException {
        this(modelBuilder, separatorChar, quoteChar, includeFieldNames);
        this.addMappings(ftlTemplate);
    }

    private void addMappings(String ftlTemplate) throws TemplateBuilderException {
        Template template;
        try {
            template = new Template("csvTemplate", (Reader)new StringReader(ftlTemplate), new Configuration());
        }
        catch (IOException e) {
            throw new TemplateBuilderException("Failed to parse the Supplied FreeMarker template.", e);
        }
        TemplateElement listNode = this.findListNode(template.getRootTreeNode());
        if (listNode == null) {
            throw new TemplateBuilderException("Unable to recognize template as being a CSV template");
        }
        this.addCSVListMapping(listNode.getDescription());
        this.addCSVFieldMappings(listNode);
    }

    private TemplateElement findListNode(TemplateElement templateNode) throws TemplateBuilderException {
        if (templateNode.getNodeName().equals("IteratorBlock")) {
            String description = templateNode.getDescription();
            if (!description.startsWith("list")) {
                throw new TemplateBuilderException("Unsupported CSV template IteratorBlock type '" + description + "'.  Currently only support 'list' IteratorBlock nodes.");
            }
            return templateNode;
        }
        Enumeration children = templateNode.children();
        if (children != null && children.hasMoreElements()) {
            while (children.hasMoreElements()) {
                TemplateElement listNode = this.findListNode((TemplateElement)children.nextElement());
                if (listNode == null) continue;
                return listNode;
            }
        }
        return null;
    }

    private void addCSVListMapping(String description) throws TemplateBuilderException {
        String[] tokens = description.split(" +?");
        Element csvRecordElement = this.getModel().getDocumentElement();
        this.addCollectionMapping(tokens[1], csvRecordElement, tokens[3]);
    }

    private void addCSVFieldMappings(TemplateElement listElement) throws TemplateBuilderException {
        StringBuilder parseBuffer = new StringBuilder();
        Enumeration children = listElement.children();
        while (children != null && children.hasMoreElements()) {
            TemplateElement child = (TemplateElement)children.nextElement();
            parseBuffer.append(child.getCanonicalForm());
        }
        Element csvRecordElement = this.getModel().getDocumentElement();
        CSVReader csvReader = new CSVReader((Reader)new StringReader(parseBuffer.toString()), this.separatorChar, this.quoteChar);
        try {
            String[] fields = csvReader.readNext();
            int fieldIndex = 0;
            NodeList csvFieldModelNodes = csvRecordElement.getChildNodes();
            int i = 0;
            while (i < csvFieldModelNodes.getLength()) {
                Node node = csvFieldModelNodes.item(i);
                if (node.getNodeType() == 1) {
                    if (fieldIndex >= fields.length) {
                        throw new TemplateBuilderException("CSV Template fieldset size does not match that of the specified message model.  Check the supplied fieldset.  Check the specified 'separator' and 'quote' characters match those used in the template.");
                    }
                    if (FreeMarkerUtil.isDollarVariable(fields[fieldIndex])) {
                        this.addValueMapping(node, fields[fieldIndex]);
                    }
                    ++fieldIndex;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new TemplateBuilderException("Failed to parse CSV fields in CSV template.", e);
        }
    }

    public String buildTemplate() throws TemplateBuilderException {
        Node node;
        int i;
        int fieldIndex;
        Element recordElement = this.getModel().getDocumentElement();
        CollectionMapping collectionMapping = this.getCollectionMapping(recordElement);
        if (collectionMapping == null) {
            throw new UnmappedCollectionNodeException(recordElement);
        }
        StringBuilder template = new StringBuilder();
        NodeList nodeList = recordElement.getChildNodes();
        if (this.includeFieldNames) {
            fieldIndex = 0;
            i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    if (fieldIndex > 0) {
                        template.append(this.separatorChar);
                    }
                    template.append(this.quoteChar);
                    template.append(DomUtils.getName((Element)((Element)node)));
                    template.append(this.quoteChar);
                    ++fieldIndex;
                }
                ++i;
            }
            template.append('\n');
        }
        template.append("<#list " + collectionMapping.getSrcPath() + " as " + collectionMapping.getCollectionItemName() + ">\n");
        fieldIndex = 0;
        i = 0;
        while (i < nodeList.getLength()) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Mapping fieldMapping = this.getMapping(node);
                if (fieldIndex > 0) {
                    template.append(this.separatorChar);
                }
                if (fieldMapping != null) {
                    template.append(this.quoteChar);
                    template.append(FreeMarkerUtil.toFreeMarkerVariable((ValueMapping)fieldMapping));
                    template.append(this.quoteChar);
                }
                ++fieldIndex;
            }
            ++i;
        }
        template.append("\n</#list>");
        return template.toString();
    }
}

