/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.templating.template.util;

import java.util.Date;
import java.util.Properties;
import org.jboss.tools.smooks.templating.template.ValueMapping;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;

public class FreeMarkerUtil {
    public static String extractJavaPath(String dollarVariable) throws TemplateBuilderException {
        return FreeMarkerUtil.splitDollarVariable(dollarVariable)[0];
    }

    public static String extractRawFormatting(String dollarVariable) throws TemplateBuilderException {
        return FreeMarkerUtil.splitDollarVariable(dollarVariable)[1];
    }

    public static String[] splitDollarVariable(String dollarVariable) throws TemplateBuilderException {
        String[] splitTokens = new String[2];
        if (FreeMarkerUtil.isDollarVariable(dollarVariable = dollarVariable.trim())) {
            String withoutDollarBrace = dollarVariable.substring(2, dollarVariable.length() - 1);
            int questionMarkIdx = withoutDollarBrace.indexOf(63);
            if (questionMarkIdx != -1) {
                splitTokens[0] = withoutDollarBrace.substring(0, questionMarkIdx);
                splitTokens[1] = withoutDollarBrace.substring(questionMarkIdx + 1);
            } else {
                splitTokens[0] = withoutDollarBrace;
                splitTokens[1] = null;
            }
            if (splitTokens[0].endsWith("!")) {
                splitTokens[0] = splitTokens[0].substring(0, splitTokens[0].length() - 1);
            }
        } else {
            throw new TemplateBuilderException("Unsupported FreeMarker variable syntax '" + dollarVariable + "'.");
        }
        return splitTokens;
    }

    public static boolean isDollarVariable(String variable) {
        return variable.startsWith("${") && variable.endsWith("}");
    }

    public static String toFreeMarkerVariable(ValueMapping mapping) {
        StringBuilder builder = new StringBuilder();
        Properties encodeProperties = mapping.getEncodeProperties();
        if (encodeProperties == null) {
            encodeProperties = new Properties();
        }
        builder.append("${" + mapping.getSrcPath() + "!?");
        String rawFormatting = encodeProperties.getProperty(ValueMapping.RAW_FORMATING_KEY);
        if (rawFormatting != null) {
            builder.append(rawFormatting);
            builder.append("}");
        } else {
            Class<?> valueType = mapping.getValueType();
            if (valueType != null) {
                if (valueType == Date.class) {
                    String format = encodeProperties.getProperty("format");
                    if (format != null) {
                        builder.append("string('" + format + "')}");
                    } else {
                        builder.append("string.medium}");
                    }
                } else if (Number.class.isAssignableFrom(valueType)) {
                    builder.append("c}");
                } else if (valueType == Double.TYPE || valueType == Float.TYPE || valueType == Integer.TYPE || valueType == Long.TYPE || valueType == Short.TYPE) {
                    builder.append("c}");
                } else {
                    builder.append("string}");
                }
            } else {
                builder.append("string}");
            }
        }
        return builder.toString();
    }
}

