/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.csv.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.jboss.tools.smooks.model.csv.CsvDocumentRoot;
import org.jboss.tools.smooks.model.csv.CsvPackage;
import org.jboss.tools.smooks.model.csv.CsvReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvValidator
extends EObjectValidator {
    public static final CsvValidator INSTANCE = new CsvValidator();
    public static final String DIAGNOSTIC_SOURCE = "csv";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return CsvPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateCsvDocumentRoot((CsvDocumentRoot)value, diagnostics, context);
            }
            case 1: {
                return this.validateCsvReader((CsvReader)value, diagnostics, context);
            }
            case 2: {
                return this.validateChar((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCsvDocumentRoot(CsvDocumentRoot csvDocumentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(csvDocumentRoot, diagnostics, context);
    }

    public boolean validateCsvReader(CsvReader csvReader, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(csvReader, diagnostics, context);
    }

    public boolean validateChar(String char_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateChar_MinLength(char_, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateChar_MaxLength(char_, diagnostics, context);
        }
        return result;
    }

    public boolean validateChar_MinLength(String char_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = char_.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(CsvPackage.Literals.CHAR, char_, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateChar_MaxLength(String char_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = char_.length();
        boolean bl = result = length <= 1;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(CsvPackage.Literals.CHAR, char_, length, 1, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

