/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.csv12.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.jboss.tools.smooks.model.csv12.Binding;
import org.jboss.tools.smooks.model.csv12.CSV12DocumentRoot;
import org.jboss.tools.smooks.model.csv12.CSV12Reader;
import org.jboss.tools.smooks.model.csv12.Csv12Package;
import org.jboss.tools.smooks.model.csv12.MapBinding;

public class Csv12Validator
extends EObjectValidator {
    public static final Csv12Validator INSTANCE = new Csv12Validator();
    public static final String DIAGNOSTIC_SOURCE = "csv12";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return Csv12Package.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateBinding((Binding)value, diagnostics, context);
            }
            case 1: {
                return this.validateCSV12DocumentRoot((CSV12DocumentRoot)value, diagnostics, context);
            }
            case 2: {
                return this.validateMapBinding((MapBinding)value, diagnostics, context);
            }
            case 3: {
                return this.validateCSV12Reader((CSV12Reader)value, diagnostics, context);
            }
            case 4: {
                return this.validateChar((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateBinding(Binding binding, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(binding, diagnostics, context);
    }

    public boolean validateCSV12DocumentRoot(CSV12DocumentRoot csv12DocumentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(csv12DocumentRoot, diagnostics, context);
    }

    public boolean validateMapBinding(MapBinding mapBinding, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(mapBinding, diagnostics, context);
    }

    public boolean validateCSV12Reader(CSV12Reader csv12Reader, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(csv12Reader, diagnostics, context);
    }

    public boolean validateChar(String char_, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateChar_MinLength(char_, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateChar_MaxLength(char_, diagnostics, context);
        }
        return result;
    }

    public boolean validateChar_MinLength(String char_, DiagnosticChain diagnostics, Map context) {
        boolean result;
        int length = char_.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(Csv12Package.Literals.CHAR, char_, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateChar_MaxLength(String char_, DiagnosticChain diagnostics, Map context) {
        boolean result;
        int length = char_.length();
        boolean bl = result = length <= 1;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(Csv12Package.Literals.CHAR, char_, length, 1, diagnostics, context);
        }
        return result;
    }
}

