/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.jmsrouting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageType implements Enumerator
{
    TEXT_MESSAGE(0, "TextMessage", "TextMessage"),
    OBJECT_MESSAGE(1, "ObjectMessage", "ObjectMessage"),
    MAP_MESSAGE(2, "MapMessage", "MapMessage");

    public static final int TEXT_MESSAGE_VALUE = 0;
    public static final int OBJECT_MESSAGE_VALUE = 1;
    public static final int MAP_MESSAGE_VALUE = 2;
    private static final MessageType[] VALUES_ARRAY;
    public static final List<MessageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageType[]{TEXT_MESSAGE, OBJECT_MESSAGE, MAP_MESSAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageType get(int value) {
        switch (value) {
            case 0: {
                return TEXT_MESSAGE;
            }
            case 1: {
                return OBJECT_MESSAGE;
            }
            case 2: {
                return MAP_MESSAGE;
            }
        }
        return null;
    }

    private MessageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

