/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.smooks.configuration.Messages;
import org.jboss.tools.smooks.configuration.ProcessNodeType;
import org.jboss.tools.smooks.configuration.RuntimeDependency;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeMetadata {
    private Smooks metadataExtractor;
    private boolean isSmooksConfig;
    private boolean isValidSmooksConfig;
    private File configFile;
    private String inputType;
    private File inputFile;
    private Set<ProcessNodeType> processNodeTypes = new HashSet<ProcessNodeType>();
    private List<RuntimeDependency> dependencies = new ArrayList<RuntimeDependency>();

    public RuntimeMetadata() {
        this.metadataExtractor = new Smooks();
        this.metadataExtractor.addVisitor((Visitor)new SmooksConfigAsserter(), "/smooks-resource-list", "http://www.milyn.org/xsd/smooks-1.1.xsd");
        this.metadataExtractor.addVisitor((Visitor)new InputParamExtractor(), "/smooks-resource-list/params/param", "http://www.milyn.org/xsd/smooks-1.1.xsd");
        RuntimeDependency.addDependencyChecklist(this.metadataExtractor);
    }

    public boolean isSmooksConfig() {
        return this.isSmooksConfig;
    }

    public boolean isValidSmooksConfig() {
        return this.isValidSmooksConfig;
    }

    public String getErrorMessage() {
        if (this.isValidSmooksConfig) {
            throw new IllegalStateException(Messages.RuntimeMetadata_Error_Invalid_GetErrorMessage_Call);
        }
        if (this.configFile == null) {
            return Messages.RuntimeMetadata_Error_SmooksFile_Does_Not_Exist;
        }
        if (!this.configFile.exists()) {
            return Messages.RuntimeMetadata_Error_SmooksFile_Not_Found;
        }
        if (!this.configFile.isFile()) {
            return Messages.RuntimeMetadata_Error_SmooksFile_Not_Readable;
        }
        if (!this.isSmooksConfig) {
            return Messages.RuntimeMetadata_Error_SmooksFile_Not_Valid;
        }
        if (this.inputFile == null) {
            return Messages.RuntimeMetadata_Error_Input_Task_No_Input_File;
        }
        if (!this.inputFile.exists()) {
            return Messages.RuntimeMetadata_Error_Input_Task_Input_File_Not_Found;
        }
        if (!this.inputFile.isFile()) {
            return Messages.RuntimeMetadata_Error_Input_Task_Input_File_Cannot_Be_Read;
        }
        return "";
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public String getInputType() {
        return this.inputType;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public List<RuntimeDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<ProcessNodeType> getNodeTypes() {
        return this.processNodeTypes;
    }

    public String getNodeTypesString() {
        StringBuilder builder = new StringBuilder();
        for (ProcessNodeType nodeType : this.processNodeTypes) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(nodeType.toString());
        }
        return builder.toString();
    }

    public void setSmooksConfig(IResource smooksConfig) {
        this.reset();
        if (smooksConfig != null) {
            this.setSmooksConfig(new File(smooksConfig.getRawLocation().toOSString().trim()));
        }
    }

    public void setSmooksConfig(File file) {
        this.reset();
        if (file != null) {
            this.configFile = file;
            if (this.configFile.exists() && this.configFile.isFile()) {
                try {
                    this.digestSmooksConfig(new FileInputStream(this.configFile));
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setSmooksConfig(File file, InputStream inputStream) {
        if (inputStream == null) {
            this.setSmooksConfig(file);
        } else {
            this.configFile = file;
            if (this.configFile.exists() && this.configFile.isFile()) {
                this.digestSmooksConfig(inputStream);
            }
        }
    }

    private void digestSmooksConfig(InputStream inputStream) {
        block5: {
            ExecutionContext execContext = this.metadataExtractor.createExecutionContext();
            Properties inputParams = new Properties();
            try {
                String resolvedFilePath;
                String inputPath;
                execContext.setAttribute(InputParamExtractor.class, (Object)inputParams);
                execContext.setAttribute(RuntimeMetadata.class, (Object)this);
                this.metadataExtractor.filterSource(execContext, (Source)new StreamSource(inputStream), new Result[0]);
                this.inputType = inputParams.getProperty("inputType");
                if (this.inputType == null || (inputPath = inputParams.getProperty(this.inputType)) == null) break block5;
                try {
                    resolvedFilePath = SmooksUIUtils.parseFilePath(inputPath.trim());
                }
                catch (Exception exception) {
                    this.inputFile = new File(inputPath.trim());
                    return;
                }
                this.inputFile = new File(resolvedFilePath);
                if (this.inputFile.exists() && this.inputFile.isFile()) {
                    this.isValidSmooksConfig = true;
                }
            }
            catch (Exception exception) {}
        }
    }

    private void reset() {
        this.isSmooksConfig = false;
        this.isValidSmooksConfig = false;
        this.configFile = null;
        this.inputType = null;
        this.inputFile = null;
        this.processNodeTypes.clear();
    }

    private static class InputParamExtractor
    implements SAXVisitBefore,
    SAXVisitAfter {
        private InputParamExtractor() {
        }

        public void visitBefore(SAXElement paramElement, ExecutionContext execContext) throws SmooksException, IOException {
            paramElement.accumulateText();
        }

        public void visitAfter(SAXElement paramElement, ExecutionContext execContext) throws SmooksException, IOException {
            String paramName;
            Properties inputParams = (Properties)execContext.getAttribute(InputParamExtractor.class);
            if (inputParams != null && (paramName = paramElement.getAttribute("name")) != null) {
                if (paramName.equals("inputType")) {
                    inputParams.setProperty("inputType", paramElement.getTextContent());
                } else {
                    String paramType = paramElement.getAttribute("type");
                    if (paramType != null && paramType.equals("input.type.actived")) {
                        inputParams.setProperty(paramName, paramElement.getTextContent());
                    }
                }
            }
        }
    }

    private static class SmooksConfigAsserter
    implements SAXVisitBefore {
        private SmooksConfigAsserter() {
        }

        public void visitBefore(SAXElement paramElement, ExecutionContext execContext) throws SmooksException, IOException {
            RuntimeMetadata metadata = (RuntimeMetadata)execContext.getAttribute(RuntimeMetadata.class);
            metadata.isSmooksConfig = true;
        }
    }
}

