/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.actions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.actions.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

public class OpenEditorEditInnerContentsAction
extends Action {
    private static Map<Object, Map<String, OpenEditorEditInnerContentsAction>> elementTempFileMap = new HashMap<Object, Map<String, OpenEditorEditInnerContentsAction>>();
    private AnyType model;
    private int textType = SmooksUIUtils.VALUE_TYPE_TEXT;
    private String fileExtensionName = "txt";
    private String editorID = null;
    private IResource resource = null;
    private IEditorPart tempEditor = null;
    private TempFileChangeListener tempFileListener = null;
    private IPartListener tempEditorlistener = null;
    private EditingDomain editingDomain;
    private IFile tempFile;
    private Map<String, OpenEditorEditInnerContentsAction> actionMap;
    private Text relateText;

    public OpenEditorEditInnerContentsAction(EditingDomain domain, AnyType model, int textType, String fileExtensionName, String editorID) {
        this.model = model;
        this.editingDomain = domain;
        this.textType = textType;
        this.fileExtensionName = fileExtensionName;
        this.editorID = editorID;
        this.tempFileListener = new TempFileChangeListener();
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.setDescription(Messages.OpenEditorEditInnerContentsAction_OpenEditor_Des);
        this.setText(Messages.OpenEditorEditInnerContentsAction_OpenEditor_Label);
        this.actionMap = elementTempFileMap.get(model);
        if (this.actionMap != null) {
            OpenEditorEditInnerContentsAction oldAction = this.actionMap.get(this.getTypeKey());
            if (oldAction != null) {
                this.tempFile = oldAction.getTempFile();
                this.cleanOldActionListeners(oldAction);
                if (this.tempFile != null) {
                    this.tempEditorlistener = this.createNewPartListener();
                    SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.tempEditorlistener);
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.tempFileListener);
                }
            }
        } else {
            this.actionMap = new HashMap<String, OpenEditorEditInnerContentsAction>();
            elementTempFileMap.put(model, this.actionMap);
        }
        this.actionMap.put(this.getTypeKey(), this);
    }

    public OpenEditorEditInnerContentsAction(EditingDomain domain, AnyType model, int textType, String fileExtensionName) {
        this(domain, model, textType, fileExtensionName, null);
    }

    public TempFileChangeListener getTempFileListener() {
        return this.tempFileListener;
    }

    public void setTempFileListener(TempFileChangeListener tempFileListener) {
        this.tempFileListener = tempFileListener;
    }

    public IPartListener getTempEditorlistener() {
        return this.tempEditorlistener;
    }

    public void setTempEditorlistener(IPartListener tempEditorlistener) {
        this.tempEditorlistener = tempEditorlistener;
    }

    public IFile getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(IFile tempFile) {
        this.tempFile = tempFile;
    }

    public Text getRelateText() {
        return this.relateText;
    }

    public void setRelateText(Text relateText) {
        this.relateText = relateText;
    }

    private void setContent(AnyType model, String contents, int textType) {
        String editValue = null;
        if (textType == SmooksUIUtils.VALUE_TYPE_TEXT && model instanceof AnyType && !contents.equals(editValue = SmooksModelUtils.getAnyTypeText((AnyType)model))) {
            SmooksModelUtils.setTextToAnyType((AnyType)model, (String)contents);
        }
        if (textType == SmooksUIUtils.VALUE_TYPE_COMMENT && model instanceof AnyType && !contents.equals(editValue = SmooksModelUtils.getAnyTypeComment((AnyType)model))) {
            SmooksModelUtils.setCommentToSmooksType((EditingDomain)this.editingDomain, (AnyType)model, (String)contents);
        }
        if (textType == SmooksUIUtils.VALUE_TYPE_CDATA && model instanceof AnyType && !contents.equals(editValue = SmooksModelUtils.getAnyTypeCDATA((AnyType)model))) {
            SmooksModelUtils.setCDATAToSmooksType((EditingDomain)this.editingDomain, (AnyType)model, (String)contents);
        }
        if (this.getRelateText() != null && contents != null) {
            try {
                Text relateText = this.getRelateText();
                if (relateText != null) {
                    relateText.setText(contents);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private String getTypeKey() {
        if (this.textType == SmooksUIUtils.VALUE_TYPE_TEXT) {
            return "text";
        }
        if (this.textType == SmooksUIUtils.VALUE_TYPE_COMMENT) {
            return "comment";
        }
        if (this.textType == SmooksUIUtils.VALUE_TYPE_CDATA) {
            return "cdata";
        }
        return "";
    }

    private void cleanOldActionListeners(OpenEditorEditInnerContentsAction action) {
        IPartListener pl = action.getTempEditorlistener();
        TempFileChangeListener rl = action.getTempFileListener();
        if (pl != null) {
            SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener(pl);
        }
        if (rl != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)rl);
        }
    }

    private IPartListener createNewPartListener() {
        IPartListener partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (OpenEditorEditInnerContentsAction.this.tempEditor != null && part == OpenEditorEditInnerContentsAction.this.tempEditor) {
                    SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener(OpenEditorEditInnerContentsAction.this.tempEditorlistener);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)OpenEditorEditInnerContentsAction.this.tempFileListener);
                    try {
                        OpenEditorEditInnerContentsAction.this.tempFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        OpenEditorEditInnerContentsAction.this.tempFile.refreshLocal(0, null);
                        if (OpenEditorEditInnerContentsAction.this.actionMap != null) {
                            OpenEditorEditInnerContentsAction.this.actionMap.remove(OpenEditorEditInnerContentsAction.this.getTypeKey());
                        }
                        if (OpenEditorEditInnerContentsAction.this.actionMap.isEmpty()) {
                            elementTempFileMap.remove(OpenEditorEditInnerContentsAction.this.model);
                            OpenEditorEditInnerContentsAction.this.actionMap = null;
                        }
                        OpenEditorEditInnerContentsAction.this.tempFile = null;
                    }
                    catch (CoreException coreException) {}
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        return partListener;
    }

    public void run() {
        IWorkbenchWindow window = SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            if (this.tempFile != null && this.tempFile.exists()) {
                if (this.editorID != null) {
                    FileEditorInput editorInput1 = new FileEditorInput(this.tempFile);
                    this.tempEditor = window.getActivePage().openEditor((IEditorInput)editorInput1, this.editorID);
                } else {
                    this.tempEditor = IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)this.tempFile);
                }
                return;
            }
            if (this.tempEditorlistener != null) {
                SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener(this.tempEditorlistener);
            }
            if (this.tempFileListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.tempFileListener);
            }
            String editValue = null;
            if (this.textType == SmooksUIUtils.VALUE_TYPE_TEXT && this.model instanceof AnyType) {
                editValue = SmooksModelUtils.getAnyTypeText((AnyType)this.model);
            }
            if (this.textType == SmooksUIUtils.VALUE_TYPE_COMMENT && this.model instanceof AnyType) {
                editValue = SmooksModelUtils.getAnyTypeComment((AnyType)this.model);
            }
            if (this.textType == SmooksUIUtils.VALUE_TYPE_CDATA && this.model instanceof AnyType) {
                editValue = SmooksModelUtils.getAnyTypeCDATA((AnyType)this.model);
            }
            if (editValue != null) {
                this.resource = SmooksUIUtils.getResource((EObject)this.model);
                if (this.resource != null) {
                    IProject project = this.resource.getProject();
                    String name = this.generateFileName();
                    this.tempFile = project.getFile(String.valueOf(name) + "." + this.fileExtensionName);
                    int i = 0;
                    while (this.tempFile.exists()) {
                        name = String.valueOf(name) + String.valueOf(i);
                        this.tempFile = project.getFile(String.valueOf(name) + "." + this.fileExtensionName);
                        ++i;
                    }
                    this.tempFile.create((InputStream)new ByteArrayInputStream(editValue.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                    this.tempFile.setHidden(true);
                    FileEditorInput editorInput = new FileEditorInput(this.tempFile);
                    editorInput = new FileEditorInput(this.tempFile);
                    this.tempEditor = this.editorID != null ? window.getActivePage().openEditor((IEditorInput)editorInput, this.editorID) : IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)this.tempFile);
                    this.tempEditorlistener = this.createNewPartListener();
                    SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.tempEditorlistener);
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.tempFileListener);
                }
            }
        }
        catch (Exception exception) {}
    }

    private String generateFileName() {
        int number = (int)System.currentTimeMillis();
        return "tempFile_" + String.valueOf(number);
    }

    class DeltaPrinter
    implements IResourceDeltaVisitor {
        DeltaPrinter() {
        }

        private String getContents() throws IOException {
            File file = OpenEditorEditInnerContentsAction.this.tempFile.getLocation().toFile();
            FileReader fr = new FileReader(file);
            BufferedReader reader = new BufferedReader(fr);
            String line = reader.readLine();
            String contents = "";
            while (line != null) {
                contents = String.valueOf(contents) + line + "\n";
                line = reader.readLine();
            }
            return contents;
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    if (res instanceof IFile && ((IFile)res).getLocation().equals((Object)OpenEditorEditInnerContentsAction.this.tempFile.getLocation())) {
                        try {
                            OpenEditorEditInnerContentsAction.this.setContent(OpenEditorEditInnerContentsAction.this.model, this.getContents(), OpenEditorEditInnerContentsAction.this.textType);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    int n = delta.getFlags();
                }
            }
            return true;
        }
    }

    private class TempFileChangeListener
    implements IResourceChangeListener {
        private TempFileChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                switch (event.getType()) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter(), 8);
                        break;
                    }
                    case 8: {
                        event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter(), 8);
                        break;
                    }
                    case 16: {
                        event.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

