/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.validate.SmooksMarkerHelper;
import org.jboss.tools.smooks.configuration.validate.SmooksModelValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateSmooksAction
extends Action {
    private Resource resource = null;
    private EditingDomain editingDomain;
    private SmooksModelValidator validator = null;
    private SmooksMarkerHelper markerHelper = new SmooksMarkerHelper();

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    List<Diagnostic> lists = ValidateSmooksAction.this.validate(progressMonitor);
                    Resource resource = (Resource)ValidateSmooksAction.this.editingDomain.getResourceSet().getResources().get(0);
                    if (resource != null) {
                        ValidateSmooksAction.this.markerHelper.deleteMarkers(resource);
                    }
                    for (final Diagnostic diagnostic : lists) {
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (progressMonitor.isCanceled()) {
                                    ValidateSmooksAction.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                                } else {
                                    ValidateSmooksAction.this.handleDiagnostic(diagnostic);
                                }
                            }
                        });
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        if (this.markerHelper != null) {
            runnableWithProgress = this.markerHelper.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(exception);
        }
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 0) {
            return;
        }
        if (this.markerHelper != null && this.resource != null) {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                this.markerHelper.createMarkers(this.resource, childDiagnostic);
            }
        }
    }

    protected List<Diagnostic> validate(IProgressMonitor progressMonitor) {
        if (this.resource != null && this.editingDomain != null) {
            this.validator = new SmooksModelValidator((Collection<?>)this.resource.getContents(), this.editingDomain);
            return this.validator.validate(progressMonitor);
        }
        return Collections.emptyList();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }
}

