/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.smooks.configuration.editors.IFilePathProcessor;

public class ClassPathFileProcessor
implements IFilePathProcessor {
    public String processFileSystemPath(String filePath) {
        return filePath;
    }

    public String processWorkBenchPath(IFile file) {
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String path = null;
        if (javaProject != null) {
            try {
                IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
                int i = 0;
                while (i < classpathEntries.length) {
                    IClasspathEntry entry = classpathEntries[i];
                    IPath sourcePath = entry.getPath();
                    if (sourcePath.isPrefixOf(file.getFullPath())) {
                        IPath filePath = file.getFullPath();
                        String sp = sourcePath.toPortableString();
                        String fp = filePath.toPortableString();
                        path = fp.substring(sp.length(), fp.length());
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (path == null) {
            path = file.getFullPath().removeFirstSegments(1).toPortableString();
        }
        if (path.charAt(0) != '\\' && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }
}

