/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.smooks.configuration.editors.wizard.IViewerInitor;
import org.jboss.tools.smooks.configuration.editors.wizard.ViewerInitorStore;

public class CompoundStructuredDataContentProvider
implements ITreeContentProvider {
    private List<ITreeContentProvider> contentProviderList = new ArrayList<ITreeContentProvider>();

    public CompoundStructuredDataContentProvider() {
        Collection<IViewerInitor> lists = ViewerInitorStore.getInstance().getViewerInitorCollection();
        for (IViewerInitor viewerInitor : lists) {
            this.contentProviderList.add(viewerInitor.getTreeContentProvider());
        }
    }

    public Object[] getChildren(Object parentElement) {
        for (ITreeContentProvider provider : this.contentProviderList) {
            Object[] objs = provider.getChildren(parentElement);
            if (objs == null || objs.length == 0) continue;
            return objs;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        for (ITreeContentProvider provider : this.contentProviderList) {
            Object parent = provider.getParent(element);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        for (ITreeContentProvider provider : this.contentProviderList) {
            boolean parent = provider.hasChildren(element);
            if (!parent) continue;
            return parent;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        for (ITreeContentProvider provider : this.contentProviderList) {
            Object[] objs = provider.getElements(inputElement);
            if (objs == null || objs.length == 0) continue;
            return objs;
        }
        return new Object[0];
    }

    public void dispose() {
        for (ITreeContentProvider provider : this.contentProviderList) {
            provider.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

