/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.FormColors;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.IFieldMarker;

public class FieldMarkerComposite
extends Canvas
implements IFieldMarker,
PaintListener {
    private Image errorImage = null;
    private Image waringImage = null;
    private int type = 0;
    private DefaultToolTip toolTip = null;

    public FieldMarkerComposite(Composite parent, int style) {
        super(parent, style);
        this.setBackground(new Color(null, 255, 255, 255));
        this.errorImage = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/ovr16/error_co.gif");
        this.waringImage = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/ovr16/warning_co.gif");
        this.addPaintListener(this);
        this.toolTip = new DefaultToolTip((Control)this){

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                return super.createToolTipContentArea(event, parent);
            }

            public Point getLocation(Point tipSize, Event event) {
                Point point = super.getLocation(tipSize, event);
                point.y = ((Control)this.getToolTipArea(null)).toDisplay((int)0, (int)0).y - 24;
                point.x = ((Control)this.getToolTipArea(null)).toDisplay((int)0, (int)0).x;
                return point;
            }
        };
        this.toolTip.setBackgroundColor(new Color(null, 255, 255, 255));
        FormColors colors = new FormColors(this.getDisplay());
        this.toolTip.setForegroundColor(colors.getColor("org.eclipse.ui.forms.TITLE"));
        this.toolTip.setStyle(0);
    }

    public void setMarkerType(int type) {
        this.type = type;
        if (this.isDisposed()) {
            return;
        }
        this.redraw();
    }

    public int getMarkerType() {
        return this.type;
    }

    public void setMessage(String message) {
        this.toolTip.setText(message);
    }

    public String getMessage() {
        return this.getToolTipText();
    }

    public void clean() {
        this.setMarkerType(0);
        if (this.isDisposed()) {
            return;
        }
        this.setToolTipText(null);
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.fillRectangle(this.getBounds());
        if (this.type == 1) {
            gc.drawImage(this.errorImage, 0, 0);
        }
        if (this.type == 2) {
            gc.drawImage(this.waringImage, 0, 0);
        }
    }
}

