/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.core.resources.IFile;
import org.jboss.tools.smooks.configuration.editors.IFilePathProcessor;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractFileSelectionWizardPage;

public class FileSelectionWizardPage
extends AbstractFileSelectionWizardPage {
    private ProtableFileStringProcessor processor = new ProtableFileStringProcessor();
    private boolean processFilePath = true;

    public FileSelectionWizardPage(String pageName, Object[] initSelection, boolean processFilePath) {
        super(pageName, new String[0]);
        this.setFilePathProcessor(this.processor);
        this.setTitle(Messages.FileSelectionWizardPage_PageTitle);
        this.setDescription(Messages.FileSelectionWizardPage_PageDescription);
        this.processFilePath = processFilePath;
    }

    protected Object loadedTheObject(String path) throws Exception {
        return null;
    }

    protected String processFileSystemFilePath(String path) {
        String s;
        if (!this.processFilePath) {
            return super.processFileSystemFilePath(path);
        }
        if (this.getFilePathProcessor() != null && (s = this.getFilePathProcessor().processFileSystemPath(path)) != null) {
            return s;
        }
        return this.processor.processFileSystemPath(path);
    }

    protected String processWorkSpaceFilePath(IFile file) {
        String s;
        if (!this.processFilePath) {
            return super.processWorkSpaceFilePath(file);
        }
        if (this.getFilePathProcessor() != null && (s = this.getFilePathProcessor().processWorkBenchPath(file)) != null) {
            return s;
        }
        return this.processor.processWorkBenchPath(file);
    }

    private class ProtableFileStringProcessor
    implements IFilePathProcessor {
        private ProtableFileStringProcessor() {
        }

        public String processWorkBenchPath(IFile file) {
            String s = file.getFullPath().toPortableString();
            return s;
        }

        public String processFileSystemPath(String filePath) {
            return filePath;
        }
    }
}

