/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.IFieldMarker;
import org.jboss.tools.smooks.configuration.editors.IPropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.PropertyUICreatorManager;
import org.jboss.tools.smooks.configuration.editors.uitls.IModelProcsser;
import org.jboss.tools.smooks.configuration.editors.uitls.INumberParser;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.common.AbstractAnyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelPanelCreator {
    private Map<Object, Object> currentPropertyUIMap = new HashMap<Object, Object>();
    private EObject model;
    private IItemPropertySource propertySource;

    public IItemPropertySource getPropertySource() {
        return this.propertySource;
    }

    public void setPropertySource(IItemPropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public EObject getModel() {
        return this.model;
    }

    public void setModel(EObject model) {
        this.model = model;
    }

    public ModelPanelCreator() {
    }

    public ModelPanelCreator(EObject model, IItemPropertySource propertySource) {
        this.model = model;
        this.propertySource = propertySource;
    }

    protected void cleanCurrentPropertyUIMap() {
        this.currentPropertyUIMap.clear();
    }

    public Map<Object, Object> createModelPanel(FormToolkit formToolkit, Composite detailsComposite, ISmooksModelProvider provider, IEditorPart part) {
        return this.createModelPanel(this.model, formToolkit, detailsComposite, this.propertySource, provider, part);
    }

    public Map<Object, Object> createModelPanel(EObject model, FormToolkit formToolkit, Composite detailsComposite, IItemPropertySource itemPropertySource, ISmooksModelProvider provider, IEditorPart part) {
        AttributeFieldEditPart editPart;
        EAttribute attribute;
        IItemPropertyDescriptor pd;
        Object attribute2;
        List<AttributeFieldEditPart> list;
        this.cleanCurrentPropertyUIMap();
        IPropertyUICreator creator = PropertyUICreatorManager.getInstance().getPropertyUICreator(model);
        List propertyDes = itemPropertySource.getPropertyDescriptors((Object)model);
        if (creator != null && (list = creator.createExtendUIOnTop((AdapterFactoryEditingDomain)provider.getEditingDomain(), formToolkit, detailsComposite, model, provider, part)) != null) {
            for (AttributeFieldEditPart attributeFieldEditPart : list) {
                if (attributeFieldEditPart == null || (attribute2 = attributeFieldEditPart.getAttribute()) == null || attributeFieldEditPart == null) continue;
                this.currentPropertyUIMap.put(attribute2, attributeFieldEditPart);
            }
        }
        int i = 0;
        while (i < propertyDes.size()) {
            pd = (IItemPropertyDescriptor)propertyDes.get(i);
            attribute = (EAttribute)pd.getFeature((Object)model);
            if (attribute.isRequired() && (editPart = this.createAttributeUI(model, formToolkit, provider, part, detailsComposite, pd, creator)) != null && attribute != null) {
                this.currentPropertyUIMap.put(attribute, editPart);
            }
            ++i;
        }
        i = 0;
        while (i < propertyDes.size()) {
            pd = (IItemPropertyDescriptor)propertyDes.get(i);
            attribute = (EAttribute)pd.getFeature((Object)model);
            if (!attribute.isRequired() && (editPart = this.createAttributeUI(model, formToolkit, provider, part, detailsComposite, pd, creator)) != null && attribute != null) {
                this.currentPropertyUIMap.put(attribute, editPart);
            }
            ++i;
        }
        if (creator != null && (list = creator.createExtendUIOnBottom((AdapterFactoryEditingDomain)provider.getEditingDomain(), formToolkit, detailsComposite, model, provider, part)) != null) {
            for (AttributeFieldEditPart attributeFieldEditPart : list) {
                if (attributeFieldEditPart == null || (attribute2 = attributeFieldEditPart.getAttribute()) == null || attributeFieldEditPart == null) continue;
                this.currentPropertyUIMap.put(attribute2, attributeFieldEditPart);
            }
        }
        formToolkit.paintBordersFor(detailsComposite);
        detailsComposite.pack();
        this.markPropertyUI(provider.getDiagnosticList(), model);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        return map;
    }

    public void markPropertyUI(List<Diagnostic> diagnosticList) {
        this.markPropertyUI(diagnosticList, this.model);
    }

    public void markPropertyUI(List<Diagnostic> diagnosticList, EObject model) {
        for (AttributeFieldEditPart attributeFieldEditPart : this.currentPropertyUIMap.values()) {
            if (attributeFieldEditPart.getFieldMarker() == null) continue;
            attributeFieldEditPart.getFieldMarker().clean();
        }
        for (Diagnostic diagnostic : diagnosticList) {
            this.markErrorWarningPropertyUI(diagnostic, model);
        }
    }

    protected AttributeFieldEditPart createAttributeUI(EObject model, FormToolkit formToolkit, ISmooksModelProvider provider, IEditorPart part, Composite detailsComposite, IItemPropertyDescriptor propertyDescriptor, IPropertyUICreator creator) {
        IItemPropertyDescriptor itemPropertyDescriptor = propertyDescriptor;
        EAttribute feature = (EAttribute)itemPropertyDescriptor.getFeature((Object)model);
        AttributeFieldEditPart editPart = null;
        boolean createDefault = true;
        if (creator != null) {
            if (creator.ignoreProperty(feature)) {
                return null;
            }
            editPart = creator.createPropertyUI(formToolkit, detailsComposite, itemPropertyDescriptor, model, feature, provider, part);
            if (editPart != null) {
                createDefault = false;
            }
        }
        if (createDefault) {
            EClassifier typeClazz = feature.getEType();
            boolean hasCreated = false;
            Class instanceClass = typeClazz.getInstanceClass();
            if (typeClazz instanceof EEnum) {
                editPart = this.createEnumFieldEditor(formToolkit, model, detailsComposite, feature, (EEnum)typeClazz, formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (instanceClass == String.class) {
                editPart = this.createStringFieldEditor(model, detailsComposite, feature, formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                editPart = this.createBooleanFieldEditor(model, detailsComposite, feature, formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
                editPart = this.createIntegerFieldEditor(model, detailsComposite, feature, formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (Number.class.isAssignableFrom(instanceClass)) {
                editPart = this.createBigIntegerFieldEditor(model, detailsComposite, feature, formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
        }
        return editPart;
    }

    protected AttributeFieldEditPart createBigIntegerFieldEditor(Object model, Composite propertyComposite, EAttribute feature, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        return SmooksUIUtils.createNumberFieldEditor(null, propertyComposite, formToolKit, itemPropertyDescriptor, model, new INumberParser(){

            public Object transformText(String text) {
                return BigInteger.valueOf(Long.parseLong(text));
            }
        });
    }

    protected AttributeFieldEditPart createIntegerFieldEditor(Object model, Composite propertyComposite, EAttribute feature, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        return SmooksUIUtils.createNumberFieldEditor(null, propertyComposite, formToolKit, itemPropertyDescriptor, model, new INumberParser(){

            public Object transformText(String text) {
                return Integer.parseInt(text);
            }
        });
    }

    protected AttributeFieldEditPart createEnumFieldEditor(FormToolkit formToolkit, EObject model, Composite propertyComposite, EAttribute feature, final EEnum typeClass, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        EList literalList = typeClass.getELiterals();
        String[] items = new String[literalList.size()];
        int i = 0;
        while (i < literalList.size()) {
            EEnumLiteral enumLiteral = (EEnumLiteral)literalList.get(i);
            items[i] = enumLiteral.getName();
            ++i;
        }
        final IItemPropertyDescriptor fip = itemPropertyDescriptor;
        IModelProcsser processer = new IModelProcsser(){

            public Object unwrapValue(Object model) {
                if (model instanceof Enumerator) {
                    return ((Enumerator)model).getName();
                }
                Object editValue = SmooksUIUtils.getEditValue(fip, model);
                if (editValue instanceof Enumerator) {
                    return ((Enumerator)editValue).getName();
                }
                return null;
            }

            public Object wrapValue(Object model) {
                String name = model.toString();
                Object v = null;
                try {
                    Method method = typeClass.getInstanceClass().getMethod("get", String.class);
                    if (method != null) {
                        v = method.invoke(null, name);
                    }
                }
                catch (Throwable throwable) {}
                return v;
            }
        };
        return SmooksUIUtils.createChoiceFieldEditor(propertyComposite, formToolkit, itemPropertyDescriptor, model, items, processer, true);
    }

    protected AttributeFieldEditPart createBooleanFieldEditor(EObject model, Composite propertyComposite, EAttribute feature, FormToolkit formToolkit, IItemPropertyDescriptor itemPropertyDescriptor) {
        IModelProcsser processer = new IModelProcsser(){

            public Object unwrapValue(Object model) {
                if (model instanceof Boolean) {
                    if (((Boolean)model).booleanValue()) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "FALSE";
            }

            public Object wrapValue(Object model) {
                try {
                    return Boolean.parseBoolean(model.toString());
                }
                catch (Throwable throwable) {
                    return Boolean.FALSE;
                }
            }
        };
        return SmooksUIUtils.createChoiceFieldEditor(propertyComposite, formToolkit, itemPropertyDescriptor, model, new String[]{"TRUE", "FALSE"}, processer, true);
    }

    protected AttributeFieldEditPart createStringFieldEditor(EObject model, Composite propertyComposite, EAttribute feature, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        return SmooksUIUtils.createStringFieldEditor(propertyComposite, formToolKit, itemPropertyDescriptor, model, false, false, null);
    }

    protected void markErrorWarningPropertyUI(Diagnostic diagnostic, EObject currentModel) {
        if (diagnostic == null || diagnostic.getSeverity() == 0) {
            return;
        }
        List data = diagnostic.getData();
        for (Object object : data) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            if (eObject instanceof AbstractAnyType && eObject != currentModel) {
                return;
            }
            if (!(eObject instanceof EAttribute)) continue;
            AttributeFieldEditPart editPart = (AttributeFieldEditPart)this.currentPropertyUIMap.get(eObject);
            if (editPart == null) {
                return;
            }
            IFieldMarker marker = editPart.getFieldMarker();
            if (marker == null) {
                return;
            }
            if (diagnostic.getSeverity() == 4 && marker.getMarkerType() != 1) {
                marker.setMarkerType(1);
                marker.setMessage(diagnostic.getMessage());
            }
            if (diagnostic.getSeverity() != 2 || marker.getMarkerType() == 2 || marker.getMarkerType() == 1) continue;
            marker.setMarkerType(2);
            marker.setMessage(diagnostic.getMessage());
        }
        List children = diagnostic.getChildren();
        for (Diagnostic diagnostic2 : children) {
            this.markErrorWarningPropertyUI(diagnostic2, currentModel);
        }
    }
}

