/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.ModelPanelCreator;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;

public class NewOrModifySmooksElementDialog
extends Dialog {
    private EObject model;
    private FormToolkit toolkit;
    private ISmooksModelProvider modelProvider = null;
    private boolean modify = false;
    private EObject parentModel;
    private EStructuralFeature feature;
    private IEditorPart editorPart;

    public NewOrModifySmooksElementDialog(IShellProvider parentShell, EStructuralFeature feature, EObject model, EObject parentModel, FormToolkit toolkit, ISmooksModelProvider modelProvider, IEditorPart editorPart, boolean modify) {
        super(parentShell);
        this.feature = feature;
        this.model = model;
        this.toolkit = toolkit;
        this.modelProvider = modelProvider;
        this.modify = modify;
        this.editorPart = editorPart;
        this.parentModel = parentModel;
    }

    public NewOrModifySmooksElementDialog(Shell parentShell, EStructuralFeature feature, EObject model, EObject parentModel, FormToolkit toolkit, ISmooksModelProvider modelProvider, IEditorPart editorPart, boolean modify) {
        super(parentShell);
        this.feature = feature;
        this.model = model;
        this.toolkit = toolkit;
        this.modelProvider = modelProvider;
        this.modify = modify;
        this.editorPart = editorPart;
        this.parentModel = parentModel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String okLabel = IDialogConstants.OK_LABEL;
        if (this.modify) {
            okLabel = Messages.NewOrModifySmooksElementDialog_CloseButtonLabel;
        }
        this.createButton(parent, 0, okLabel, true);
        if (!this.modify) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        mainComposite.setBackground(this.toolkit.getColors().getBackground());
        Composite mc = new Composite(mainComposite, 0);
        mc.setBackground(this.toolkit.getColors().getBackground());
        GridData gd = new GridData(1808);
        gd.heightHint = 500;
        gd.widthHint = 400;
        mc.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 1;
        mc.setLayout((Layout)gl);
        ModelPanelCreator creator = new ModelPanelCreator();
        if (this.modelProvider != null && this.model instanceof EObject) {
            AdapterFactoryEditingDomain editDomain = (AdapterFactoryEditingDomain)this.modelProvider.getEditingDomain();
            IItemPropertySource propertySource = (IItemPropertySource)editDomain.getAdapterFactory().adapt((Notifier)this.model, IItemPropertySource.class);
            creator.createModelPanel(this.model, this.toolkit, mc, propertySource, this.modelProvider, this.editorPart);
        }
        return mainComposite;
    }

    protected void okPressed() {
        try {
            if (!this.modify && this.parentModel != null && this.modelProvider != null && this.feature != null) {
                EditingDomain editingDomain = this.modelProvider.getEditingDomain();
                Command command = null;
                if (this.feature instanceof EReference) {
                    command = ((EReference)this.feature).isMany() ? AddCommand.create((EditingDomain)editingDomain, (Object)this.parentModel, (Object)this.feature, (Object)this.model) : SetCommand.create((EditingDomain)editingDomain, (Object)this.parentModel, (Object)this.feature, (Object)this.model);
                }
                if (command != null) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }
}

