/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.FieldMarkerComposite;
import org.jboss.tools.smooks.configuration.editors.FileSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.IPropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.FieldAssistDisposer;
import org.jboss.tools.smooks.configuration.editors.uitls.FieldMarkerWrapper;
import org.jboss.tools.smooks.configuration.editors.uitls.IFieldDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.IModelProcsser;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUICreator
implements IPropertyUICreator {
    protected IModelProcsser fileFiledEditorModelProcess;
    protected IHyperlinkListener fileFiledEditorLinkListener;
    protected List<ViewerFilter> viewerFilters = null;

    @Override
    public AttributeFieldEditPart createPropertyUI(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        if (this.isBeanIDRefFieldFeature(feature)) {
            return this.createBeanIDRefFieldEditor(toolkit, parent, propertyDescriptor, model, feature, formEditor);
        }
        if (this.isSelectorFeature(feature)) {
            return this.createSelectorFieldEditor(toolkit, parent, propertyDescriptor, model, feature, formEditor, editorPart);
        }
        if (this.isJavaTypeFeature(feature)) {
            return this.createJavaTypeSearchEditor(toolkit, parent, propertyDescriptor, model, feature, formEditor);
        }
        if (this.isFileSelectionFeature(feature)) {
            return this.createFileSelectionFieldEditor(toolkit, parent, propertyDescriptor, model, feature, formEditor);
        }
        if (this.isConditionSelectionFeature(feature)) {
            return SmooksUIUtils.createConditionsChoiceFieldEditor(parent, toolkit, propertyDescriptor, model);
        }
        SmooksPackage.eINSTANCE.getAbstractReader_TargetProfile();
        return null;
    }

    protected boolean isConditionSelectionFeature(EAttribute feature) {
        return false;
    }

    public IHyperlinkListener getFileFiledEditorLinkListener() {
        return this.fileFiledEditorLinkListener;
    }

    public void setFileFiledEditorLinkListener(IHyperlinkListener fileFiledEditorLinkListener) {
        this.fileFiledEditorLinkListener = fileFiledEditorLinkListener;
    }

    public IModelProcsser getFileFiledEditorModelProcess() {
        return this.fileFiledEditorModelProcess;
    }

    public void setFileFiledEditorModelProcess(IModelProcsser fileFiledEditorModelProcess) {
        this.fileFiledEditorModelProcess = fileFiledEditorModelProcess;
    }

    public List<ViewerFilter> getFileDialogViewerFilters() {
        return this.viewerFilters;
    }

    public void setDialogViewerFilters(List<ViewerFilter> viewerFilters) {
        this.viewerFilters = viewerFilters;
    }

    public IResource getResource(EObject model) {
        return SmooksUIUtils.getResource(model);
    }

    public IJavaProject getJavaProject(EObject model) {
        return SmooksUIUtils.getJavaProject(model);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnBottom(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        return Collections.emptyList();
    }

    protected boolean isFileSelectionFeature(EAttribute attribute) {
        return false;
    }

    public AttributeFieldEditPart createFileSelectionFieldEditor(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor) {
        final ISmooksModelProvider provider = formEditor;
        IFieldDialog dialog = new IFieldDialog(){

            public Object open(Shell shell) {
                URI uri;
                FileSelectionWizard wizard = new FileSelectionWizard();
                EObject model = provider.getSmooksModel();
                if (model != null && (uri = model.eResource().getURI()).isPlatformResource()) {
                    String path = uri.toPlatformString(true);
                    IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                    if (workspaceResource instanceof IFile) {
                        workspaceResource = ((IFile)workspaceResource).getParent();
                    }
                    wizard.setInitSelections(new Object[]{workspaceResource});
                }
                wizard.setViewerFilters(PropertyUICreator.this.getFileDialogViewerFilters());
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() == 0) {
                    IModelProcsser p = this.getModelProcesser();
                    String path = wizard.getFilePath();
                    if (p != null) {
                        path = p.unwrapValue(path).toString();
                    }
                    return path;
                }
                return null;
            }

            public IModelProcsser getModelProcesser() {
                return PropertyUICreator.this.getFileFiledEditorModelProcess();
            }

            public void setModelProcesser(IModelProcsser processer) {
            }
        };
        return SmooksUIUtils.createDialogFieldEditor(parent, toolkit, propertyDescriptor, Messages.PropertyUICreator_browsebutton, dialog, (EObject)model, true, this.getFileFiledEditorLinkListener());
    }

    protected boolean isSelectorFeature(EAttribute attribute) {
        return false;
    }

    public AttributeFieldEditPart createSelectorFieldEditor(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        return SmooksUIUtils.createSelectorFieldEditor(toolkit, parent, propertyDescriptor, model, editorPart);
    }

    public boolean isJavaTypeFeature(EAttribute attribute) {
        return false;
    }

    public AttributeFieldEditPart createJavaTypeSearchEditor(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor) {
        if (model instanceof EObject) {
            return SmooksUIUtils.createJavaTypeSearchFieldEditor(parent, toolkit, propertyDescriptor, (EObject)model, formEditor);
        }
        return null;
    }

    protected boolean isBeanIDRefFieldFeature(EAttribute attribute) {
        return false;
    }

    public AttributeFieldEditPart createBeanIDRefFieldEditor(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor) {
        if (model instanceof EObject) {
            AttributeFieldEditPart editPart = new AttributeFieldEditPart();
            SmooksResourceListType smooksResourceList = this.getSmooksResourceList((EObject)model);
            if (smooksResourceList != null) {
                FieldMarkerWrapper wrapper = SmooksUIUtils.createFieldEditorLabel(null, parent, toolkit, propertyDescriptor, model, false);
                editPart.setFieldMarker(wrapper.getMarker());
                Composite tcom = toolkit.createComposite(parent);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginLeft = 0;
                layout.marginRight = 0;
                layout.horizontalSpacing = 0;
                tcom.setLayout((Layout)layout);
                FieldMarkerComposite notificationComposite = new FieldMarkerComposite(tcom, 0);
                GridData gd = new GridData();
                gd.heightHint = 8;
                gd.widthHint = 8;
                gd.horizontalAlignment = 1;
                gd.verticalAlignment = 1;
                notificationComposite.setLayoutData(gd);
                editPart.setFieldMarker(notificationComposite);
                final Combo combo = new Combo(tcom, 2048);
                editPart.setContentControl((Control)combo);
                gd = new GridData(768);
                combo.setLayoutData((Object)gd);
                tcom.setLayoutData((Object)gd);
                Object editValue = SmooksUIUtils.getEditValue(propertyDescriptor, model);
                if (editValue != null) {
                    combo.setText(editValue.toString());
                }
                List<String> list = SmooksUIUtils.getBeanIdStringList(smooksResourceList);
                for (String beanId : list) {
                    combo.add(beanId);
                }
                int selectIndex = list.indexOf(editValue);
                if (selectIndex != -1) {
                    combo.select(selectIndex);
                }
                final IItemPropertyDescriptor ip = propertyDescriptor;
                final Object cmodel = model;
                combo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (combo.getText() == null || combo.getText().length() == 0) {
                            ip.setPropertyValue(cmodel, null);
                            return;
                        }
                        Object editValue = SmooksUIUtils.getEditValue(ip, cmodel);
                        if (combo.getText().equals(editValue)) {
                            return;
                        }
                        ip.setPropertyValue(cmodel, (Object)combo.getText());
                    }
                });
                final FieldAssistDisposer disposer = SmooksUIUtils.addBeanIdRefAssistToCombo(combo, (EObject)model);
                combo.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        disposer.dispose();
                    }
                });
                return editPart;
            }
        }
        return null;
    }

    protected SmooksResourceListType getSmooksResourceList(EObject model) {
        EObject parent = model.eContainer();
        while (parent != null && !(parent instanceof SmooksResourceListType)) {
            parent = parent.eContainer();
        }
        if (parent instanceof SmooksResourceListType) {
            return (SmooksResourceListType)parent;
        }
        return null;
    }

    @Override
    public boolean ignoreProperty(EAttribute feature) {
        return false;
    }

    public IItemPropertyDescriptor getPropertyDescriptor(AdapterFactoryEditingDomain editingDomain, EAttribute attribute, Object model) {
        IItemPropertySource itemPropertySource = (IItemPropertySource)editingDomain.getAdapterFactory().adapt(model, IItemPropertySource.class);
        List list = itemPropertySource.getPropertyDescriptors(model);
        for (IItemPropertyDescriptor itemPropertyDescriptor : list) {
            if (itemPropertyDescriptor.getFeature(model) != attribute) continue;
            return itemPropertyDescriptor;
        }
        return null;
    }

    protected List<AttributeFieldEditPart> createElementSelectionSection(String sectionTitle, AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart, EAttribute nameAttribute, EAttribute namespaceAttribute) {
        IItemPropertySource itemPropertySource = (IItemPropertySource)editingdomain.getAdapterFactory().adapt(model, IItemPropertySource.class);
        List propertyDes = itemPropertySource.getPropertyDescriptors(model);
        IItemPropertyDescriptor createOnElementFeature = null;
        IItemPropertyDescriptor createOnElementFeatureNS = null;
        for (IItemPropertyDescriptor itemPropertyDescriptor : propertyDes) {
            if (itemPropertyDescriptor.getFeature(model) == nameAttribute) {
                createOnElementFeature = itemPropertyDescriptor;
            }
            if (itemPropertyDescriptor.getFeature(model) != namespaceAttribute) continue;
            createOnElementFeatureNS = itemPropertyDescriptor;
        }
        if (createOnElementFeature == null || createOnElementFeatureNS == null) {
            return Collections.emptyList();
        }
        return this.createElementSelectionSection(sectionTitle, editingdomain, toolkit, parent, model, formEditor, editorPart, createOnElementFeature, createOnElementFeatureNS);
    }

    protected List<AttributeFieldEditPart> createElementSelectionSection(String sectionTitle, AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart, IItemPropertyDescriptor createOnElementFeature, IItemPropertyDescriptor createOnElementFeatureNS) {
        FontData fd;
        Group group = new Group(parent, 0);
        if (sectionTitle != null) {
            sectionTitle = " " + sectionTitle + " ";
        }
        group.setText(sectionTitle);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite container = toolkit.createComposite((Composite)group);
        group.setBackground(container.getBackground());
        Font f = container.getFont();
        if (f != null && (fd = f.getFontData()[0]) != null) {
            group.setFont(new Font(null, new FontData(fd.getName(), fd.getHeight(), 1)));
        }
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 2;
        container.setLayout((Layout)glayout);
        String name = Messages.PropertyUICreator_namelabel;
        if (((EAttribute)createOnElementFeature.getFeature(model)).isRequired()) {
            name = String.valueOf(name) + "*";
        }
        AttributeFieldEditPart editPart1 = SmooksUIUtils.createSelectorFieldEditor(name, toolkit, container, createOnElementFeature, model, editorPart);
        editPart1.setAttribute(createOnElementFeature.getFeature(model));
        String namespace = Messages.PropertyUICreator_nslabel;
        if (((EAttribute)createOnElementFeatureNS.getFeature(model)).isRequired()) {
            namespace = String.valueOf(namespace) + "*";
        }
        AttributeFieldEditPart editPart2 = SmooksUIUtils.createStringFieldEditor(namespace, container, (EditingDomain)editingdomain, toolkit, createOnElementFeatureNS, model, false, false, false, 0, null, SmooksUIUtils.VALUE_TYPE_VALUE, null);
        editPart2.setAttribute(createOnElementFeatureNS.getFeature(model));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 8;
        Composite ccc = toolkit.createComposite(parent);
        ccc.setLayoutData((Object)gd);
        ArrayList<AttributeFieldEditPart> list = new ArrayList<AttributeFieldEditPart>();
        list.add(editPart1);
        list.add(editPart2);
        AttributeFieldEditPart dummyEditPart = new AttributeFieldEditPart();
        dummyEditPart.setAttribute(null);
        dummyEditPart.setContentControl((Control)container);
        list.add(dummyEditPart);
        return list;
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnTop(AdapterFactoryEditingDomain editingDomain, FormToolkit formToolkit, Composite detailsComposite, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        return null;
    }
}

