/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.jboss.tools.smooks.configuration.editors.CompoundStructuredDataContentProvider;
import org.jboss.tools.smooks.configuration.editors.CompoundStructuredDataLabelProvider;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.SelectorAttributes;
import org.jboss.tools.smooks.configuration.editors.StructuredDataSelectionWizardDailog;
import org.jboss.tools.smooks.configuration.editors.csv.CSVDataParser;
import org.jboss.tools.smooks.configuration.editors.edi.EDIDataParser;
import org.jboss.tools.smooks.configuration.editors.input.InputParameter;
import org.jboss.tools.smooks.configuration.editors.input.InputType;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.uitls.JsonInputDataParser;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.wizard.StructuredDataSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.XMLObjectAnalyzer;
import org.jboss.tools.smooks.configuration.editors.xml.XSDObjectAnalyzer;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorCreationDialog
extends Dialog {
    private TreeViewer viewer;
    private Object currentSelection;
    private Button onlyNameButton;
    private Button fullPathButton;
    private SelectorAttributes selectorAttributes = null;
    private IEditorPart editorPart = null;
    private static Throwable currentException = null;
    private FormToolkit toolkit;

    public SelectorCreationDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public static Throwable getCurrentException() {
        return currentException;
    }

    public SelectorCreationDialog(Shell parentShell, IEditorPart editorPart) {
        super(parentShell);
        this.selectorAttributes = new SelectorAttributes();
        this.editorPart = editorPart;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = 500;
        gd.widthHint = 450;
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        Label viewerLabel = new Label(composite, 0);
        viewerLabel.setText(Messages.SelectorCreationDialog_InputViewerlabel);
        this.toolkit = new FormToolkit(this.getShell().getDisplay());
        Hyperlink link = this.toolkit.createHyperlink(composite, Messages.SelectorCreationDialog_AddInputLinkLabel, 0);
        link.setBackground(composite.getBackground());
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                SelectorCreationDialog.this.showInputDataWizard();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 3;
        link.setLayoutData((Object)gd);
        this.viewer = new TreeViewer(composite, 2048);
        this.viewer.setContentProvider((IContentProvider)new CompoundStructuredDataContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CompoundStructuredDataLabelProvider());
        List<Object> inputList = this.generateInputData();
        this.viewer.setInput(inputList);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectorCreationDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectorCreationDialog.this.currentSelection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.viewer.getTree().setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(Messages.SelectorCreationDialog_SperatorCharlabel);
        final Combo speratorCombo = new Combo(composite, 2056);
        speratorCombo.add(" ");
        speratorCombo.add("/");
        speratorCombo.select(1);
        gd = new GridData(768);
        speratorCombo.setLayoutData((Object)gd);
        speratorCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectorCreationDialog.this.selectorAttributes.setSelectorSperator(speratorCombo.getText());
            }
        });
        Label l = new Label(composite, 0);
        l.setText(Messages.SelectorCreationDialog_PolicyLabel);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite com = new Composite(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        com.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        com.setLayout((Layout)gl);
        this.fullPathButton = new Button(com, 16);
        this.fullPathButton.setText(Messages.SelectorCreationDialog_FullPathPolicy);
        this.onlyNameButton = new Button(com, 16);
        this.onlyNameButton.setText(Messages.SelectorCreationDialog_OnlyNamePolicy);
        this.fullPathButton.setSelection(true);
        this.handleButtons();
        this.getShell().setText(Messages.SelectorCreationDialog_DialogTitle);
        SmooksUIUtils.expandSelectorViewer(inputList, this.viewer);
        return composite;
    }

    private void handleButtons() {
        this.fullPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectorCreationDialog.this.selectorAttributes.setSelectorPolicy("full_path");
            }
        });
        this.onlyNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectorCreationDialog.this.selectorAttributes.setSelectorPolicy("only_name");
            }
        });
    }

    public static List<Object> generateInputData(SmooksResourceListType smooksResourceListType) {
        currentException = null;
        ArrayList<Object> list = new ArrayList<Object>();
        if (smooksResourceListType != null) {
            IJavaProject project = SmooksUIUtils.getJavaProject((EObject)smooksResourceListType);
            try {
                List<InputType> inputLists = SmooksUIUtils.getInputTypeList(smooksResourceListType);
                for (InputType inputType : inputLists) {
                    TagList tl;
                    Object parser;
                    if (!inputType.isActived()) continue;
                    String type = inputType.getType();
                    String path = inputType.getPath();
                    if (type == null || path == null) continue;
                    path = path.trim();
                    if ("input.edi".equals(type) || "input.edi".equals(type)) {
                        parser = new EDIDataParser();
                        try {
                            tl = ((EDIDataParser)parser).parseEDIFile(path, smooksResourceListType);
                            if (tl != null) {
                                list.addAll(tl.getChildren());
                            }
                        }
                        catch (Throwable t) {
                            currentException = t;
                        }
                    }
                    if ("input.csv".equals(type) || "input.csv".equals(type)) {
                        parser = new CSVDataParser();
                        try {
                            tl = ((CSVDataParser)parser).parseCSV(path, smooksResourceListType);
                            if (tl != null) {
                                list.addAll(tl.getChildren());
                            }
                        }
                        catch (Throwable t) {
                            currentException = t;
                        }
                    }
                    if ("input.json".equals(type) || "input.json".equals(type)) {
                        try {
                            parser = new JsonInputDataParser();
                            IXMLStructuredObject tagList = ((JsonInputDataParser)parser).parseJsonFile(SmooksUIUtils.parseFilePath(path), smooksResourceListType);
                            if (tagList instanceof TagList) {
                                list.addAll(((TagList)tagList).getChildren());
                            } else {
                                list.add(tagList);
                            }
                        }
                        catch (Throwable tt) {
                            currentException = tt;
                        }
                    }
                    if ("input.java".equals(type)) {
                        try {
                            Class<?> clazz = SmooksUIUtils.loadClass(path, project);
                            JavaBeanModel model = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
                            if (model != null) {
                                list.add(model);
                            }
                        }
                        catch (Throwable t) {
                            currentException = t;
                        }
                    }
                    if ("input.xsd".equals(type)) {
                        try {
                            path = SmooksUIUtils.parseFilePath(path);
                            String rootElementName = null;
                            List<InputParameter> paramers = inputType.getParameters();
                            for (InputParameter paramType : paramers) {
                                String pn = paramType.getName();
                                if (!"rootElement".equals(pn)) continue;
                                rootElementName = paramType.getValue();
                                break;
                            }
                            if (rootElementName != null) {
                                rootElementName = rootElementName.trim();
                                list.add(new XSDObjectAnalyzer().loadElement(path, rootElementName));
                            }
                        }
                        catch (Throwable tt) {
                            currentException = tt;
                        }
                    }
                    if (!"input.xml".equals(type)) continue;
                    try {
                        path = SmooksUIUtils.parseFilePath(path);
                        TagList model = new XMLObjectAnalyzer().analyze(path, null, null);
                        if (model == null) continue;
                        if (model instanceof TagList) {
                            list.addAll(model.getChildren());
                            continue;
                        }
                        list.add(model);
                    }
                    catch (Throwable e) {
                        currentException = e;
                    }
                }
            }
            catch (Exception e) {
                currentException = e;
            }
        }
        return list;
    }

    public static List<Object> generateInputDataForSmooks10() {
        ArrayList<Object> list = new ArrayList<Object>();
        return list;
    }

    protected List<Object> generateInputData() {
        EObject obj = null;
        if (this.editorPart instanceof ISmooksModelProvider) {
            obj = ((ISmooksModelProvider)this.editorPart).getSmooksModel();
        } else {
            ISmooksModelProvider provider = (ISmooksModelProvider)this.editorPart.getAdapter(ISmooksModelProvider.class);
            if (provider != null) {
                obj = provider.getSmooksModel();
            }
        }
        if (obj == null) {
            List<Object> ll = Collections.emptyList();
            return ll;
        }
        SmooksResourceListType resourceList = null;
        if (obj instanceof DocumentRoot) {
            resourceList = ((DocumentRoot)obj).getSmooksResourceList();
        }
        return SelectorCreationDialog.generateInputData(resourceList);
    }

    protected void showInputDataWizard() {
        StructuredDataSelectionWizard wizard = new StructuredDataSelectionWizard();
        if (this.editorPart != null) {
            wizard.setInput(this.editorPart.getEditorInput());
            wizard.setSite(this.editorPart.getEditorSite());
        }
        wizard.setForcePreviousAndNextButtons(true);
        StructuredDataSelectionWizardDailog dialog = new StructuredDataSelectionWizardDailog(this.getShell(), (IWizard)wizard);
        if (dialog.show() == 0) {
            List<Object> input = this.generateInputData();
            this.viewer.setInput(input);
            SmooksUIUtils.expandSelectorViewer(input, this.viewer);
        }
    }

    public Object getCurrentSelection() {
        return this.currentSelection;
    }

    public SelectorAttributes getSelectorAttributes() {
        return this.selectorAttributes;
    }

    public boolean close() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        return super.close();
    }
}

