/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.SmooksConfigurationFormPage;
import org.jboss.tools.smooks.configuration.editors.SmooksConfigurationOverviewPage;
import org.jboss.tools.smooks.configuration.editors.SmooksConfigurationResourceConfigPage;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;
import org.jboss.tools.smooks.graphical.editors.SmooksProcessGraphicalEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksMultiFormEditor
extends AbstractSmooksFormEditor
implements ISelectionProvider,
ITabbedPropertySheetPageContributor {
    public static final String EDITOR_ID = "org.jboss.tools.smooks.configuration.editors.MultiPageEditor";
    private SmooksConfigurationFormPage configurationPage;
    private SmooksConfigurationOverviewPage optionsPage;
    private SmooksProcessGraphicalEditor processPage;
    private ISelection selection;
    private Collection<ISelectionChangedListener> selectionChangeListener = new ArrayList<ISelectionChangedListener>();
    private TabbedPropertySheetPage tabbedPropertySheetPage;

    @Override
    protected void addPages() {
        this.addProcessGraphicalEditor();
        this.optionsPage = this.createSmooksConfigurationOverviewPage();
        this.addValidateListener(this.optionsPage);
        this.addSourceSynchronizeListener(this.optionsPage);
        this.addSmooksEditorInitListener(this.optionsPage);
        try {
            int index = this.addPage((IFormPage)this.optionsPage);
            this.setPageText(index, Messages.SmooksMultiFormEditor_opetiontab_label);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        super.addPages();
    }

    private void addProcessGraphicalEditor() {
        this.processPage = new SmooksProcessGraphicalEditor(this, "process", Messages.SmooksMultiFormEditor_processpage_name, this);
        this.addSourceSynchronizeListener(this.processPage);
        this.addValidateListener(this.processPage);
        this.addSmooksEditorInitListener(this.processPage);
        try {
            int index = this.addPage((IFormPage)this.processPage);
            this.setPageText(index, Messages.SmooksMultiFormEditor_processtabel_label);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public IEditorPart getActiveEditor() {
        int index = this.getActivePage();
        if (index != -1) {
            IEditorPart part = this.getEditor(index);
            return part;
        }
        return null;
    }

    protected void pageChange(int newPageIndex) {
        IEditorActionBarContributor contributor;
        super.pageChange(newPageIndex);
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        if (activeEditor == null && newPageIndex == 0 && (contributor = this.getEditorSite().getActionBarContributor()) != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage((IEditorPart)this.processPage);
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object activeEditorPart;
        if (adapter == IPropertySheetPage.class) {
            this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            return this.tabbedPropertySheetPage;
        }
        if (adapter == GraphicalViewer.class && this.processPage != null && (activeEditorPart = this.processPage.getActiveEditorPage()) != null && activeEditorPart instanceof IEditorPart && activeEditorPart instanceof GraphicalEditor) {
            return ((IEditorPart)activeEditorPart).getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    private SmooksConfigurationOverviewPage createSmooksConfigurationOverviewPage() {
        return new SmooksConfigurationOverviewPage(this, "options_page", Messages.SmooksMultiFormEditor_optinepage_name, this);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this.processPage != null) {
            this.processPage.doSave(monitor);
        }
        super.doSave(monitor);
    }

    protected SmooksConfigurationFormPage createSmooksConfigurationFormPage() {
        return new SmooksConfigurationResourceConfigPage(this, "message_filter_page", "Design Page");
    }

    @Override
    public void activeRecentAffectedModel(Collection<?> collection) {
        Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty() && this.configurationPage != null) {
            ArrayList newList = new ArrayList();
            for (Object object : theSelection) {
                newList.add(object);
            }
            this.configurationPage.setSelectionToViewer(newList);
        }
    }

    @Override
    protected void createNewModelViaTextPage() {
        super.createNewModelViaTextPage();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListener.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListener.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection != null && selection.equals(this.selection)) {
            return;
        }
        this.selection = selection;
        for (ISelectionChangedListener l : this.selectionChangeListener) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void dispose() {
        try {
            super.dispose();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

