/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;

public class SmooksResourceChangeListener
implements IResourceChangeListener {
    public static final String SMOOKS_CONTENTTYPE_ID = "org.jboss.tools.smooks.ui.smooks.contentType";
    private IEditorPart currentEditPart = null;

    public SmooksResourceChangeListener(IEditorPart editorPart) {
        this.currentEditPart = editorPart;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            switch (event.getType()) {
                case 1: {
                    event.getDelta().accept((IResourceDeltaVisitor)new ChangePartNameVisitor());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ChangePartNameVisitor
    implements IResourceDeltaVisitor {
        ChangePartNameVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)SmooksResourceChangeListener.this.currentEditPart.getEditorInput()).getFile())) {
                return true;
            }
            IResource res = delta.getResource();
            if (res instanceof IFile) {
                IContentType contentType;
                block12: {
                    IContentDescription contentDescription;
                    IFile file;
                    block11: {
                        file = (IFile)res;
                        contentType = null;
                        contentDescription = file.getContentDescription();
                        if (contentDescription != null) break block11;
                        return true;
                    }
                    try {
                        contentType = contentDescription.getContentType();
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() != 274) break block12;
                        contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                    }
                }
                if (contentType == null || !SmooksResourceChangeListener.SMOOKS_CONTENTTYPE_ID.equals(contentType.getId())) {
                    return true;
                }
                int flags = delta.getFlags();
                switch (delta.getKind()) {
                    case 1: {
                        IPath newPath;
                        String newfileName;
                        if (flags != 4096) break;
                        IPath path = delta.getMovedFromPath();
                        String fileName = "";
                        if (path != null) {
                            fileName = path.lastSegment();
                        }
                        if (fileName.equals(newfileName = (newPath = res.getFullPath()).lastSegment())) {
                            return true;
                        }
                        final IPath fOldPath = path;
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                IWorkbenchWindow window = SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
                                if (window != null) {
                                    IEditorReference[] editorReferences = window.getActivePage().getEditorReferences();
                                    int i = 0;
                                    while (i < editorReferences.length) {
                                        IFile relatedFile;
                                        IEditorInput editorInput;
                                        IEditorReference iEditorReference = editorReferences[i];
                                        IEditorPart editorPart = iEditorReference.getEditor(false);
                                        if (editorPart == SmooksResourceChangeListener.this.currentEditPart && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && (relatedFile = ((IFileEditorInput)editorInput).getFile()) != null && relatedFile.getFullPath().equals((Object)fOldPath) && editorPart instanceof AbstractSmooksFormEditor) break;
                                        ++i;
                                    }
                                }
                            }
                        });
                        break;
                    }
                }
            }
            return true;
        }
    }
}

