/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.IFieldMarker;
import org.jboss.tools.smooks.configuration.editors.IPropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.PropertyUICreatorManager;
import org.jboss.tools.smooks.configuration.editors.uitls.IModelProcsser;
import org.jboss.tools.smooks.configuration.editors.uitls.INumberParser;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.common.AbstractAnyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksStuffPropertyDetailPage
implements IDetailsPage,
ISmooksModelValidateListener {
    private FormToolkit formToolkit = null;
    private IManagedForm managedForm;
    private ISelection selection;
    private IFormPart formPart;
    private Section section;
    private ISmooksModelProvider smooksModelProvider;
    private IEditorPart editorPart;
    private AdapterFactoryEditingDomain editingDomain = null;
    private IItemPropertySource itemPropertySource = null;
    private Map<Object, Object> currentPropertyUIMap = new HashMap<Object, Object>();
    private Object oldModel = null;
    private boolean isStale = false;
    private Composite propertyMainComposite;
    private Composite propertyComposite;

    public SmooksStuffPropertyDetailPage(IEditorPart editorPart, ISmooksModelProvider smooksModelProvider) {
        this.smooksModelProvider = smooksModelProvider;
        this.editorPart = editorPart;
        if (this.editorPart instanceof AbstractSmooksFormEditor) {
            ((AbstractSmooksFormEditor)this.editorPart).addValidateListener(this);
        }
        this.editingDomain = (AdapterFactoryEditingDomain)smooksModelProvider.getEditingDomain();
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.section = this.formToolkit.createSection(parent, 384);
        Composite client = this.formToolkit.createComposite((Composite)this.section);
        this.section.setLayout((Layout)new FillLayout());
        this.section.setClient((Control)client);
        this.createSectionContents(client);
    }

    private void createSectionContents(Composite client) {
        client.setLayout((Layout)new FillLayout());
        this.propertyMainComposite = new Composite(client, 0);
        this.propertyMainComposite.setLayout((Layout)new FillLayout());
        this.propertyComposite = new Composite(this.propertyMainComposite, 0);
    }

    protected void createStuffDetailsComposite(Composite detailsComposite) {
        try {
            AttributeFieldEditPart editPart;
            EAttribute attribute;
            IItemPropertyDescriptor pd;
            Object attribute2;
            List<AttributeFieldEditPart> list;
            this.cleanCurrentPropertyUIMap();
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            detailsComposite.setLayout((Layout)layout);
            IPropertyUICreator creator = PropertyUICreatorManager.getInstance().getPropertyUICreator(this.getModel());
            List propertyDes = this.itemPropertySource.getPropertyDescriptors(this.getModel());
            if (creator != null && (list = creator.createExtendUIOnTop((AdapterFactoryEditingDomain)this.smooksModelProvider.getEditingDomain(), this.formToolkit, detailsComposite, this.getModel(), this.smooksModelProvider, this.editorPart)) != null) {
                for (AttributeFieldEditPart attributeFieldEditPart : list) {
                    if (attributeFieldEditPart == null || (attribute2 = attributeFieldEditPart.getAttribute()) == null || attributeFieldEditPart == null) continue;
                    this.currentPropertyUIMap.put(attribute2, attributeFieldEditPart);
                }
            }
            int i = 0;
            while (i < propertyDes.size()) {
                pd = (IItemPropertyDescriptor)propertyDes.get(i);
                attribute = (EAttribute)pd.getFeature(this.getModel());
                if (attribute.isRequired() && (editPart = this.createAttributeUI(detailsComposite, pd, creator)) != null && attribute != null) {
                    this.currentPropertyUIMap.put(attribute, editPart);
                }
                ++i;
            }
            i = 0;
            while (i < propertyDes.size()) {
                pd = (IItemPropertyDescriptor)propertyDes.get(i);
                attribute = (EAttribute)pd.getFeature(this.getModel());
                if (!attribute.isRequired() && (editPart = this.createAttributeUI(detailsComposite, pd, creator)) != null && attribute != null) {
                    this.currentPropertyUIMap.put(attribute, editPart);
                }
                ++i;
            }
            if (creator != null && (list = creator.createExtendUIOnBottom((AdapterFactoryEditingDomain)this.smooksModelProvider.getEditingDomain(), this.formToolkit, detailsComposite, this.getModel(), this.smooksModelProvider, this.editorPart)) != null) {
                for (AttributeFieldEditPart attributeFieldEditPart : list) {
                    if (attributeFieldEditPart == null || (attribute2 = attributeFieldEditPart.getAttribute()) == null || attributeFieldEditPart == null) continue;
                    this.currentPropertyUIMap.put(attribute2, attributeFieldEditPart);
                }
            }
            this.formToolkit.paintBordersFor(detailsComposite);
            detailsComposite.pack();
            this.propertyMainComposite.layout();
            this.markPropertyUI(this.smooksModelProvider.getDiagnosticList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void markPropertyUI(List<Diagnostic> diagnosticList) {
        for (AttributeFieldEditPart attributeFieldEditPart : this.currentPropertyUIMap.values()) {
            if (attributeFieldEditPart.getFieldMarker() == null) continue;
            attributeFieldEditPart.getFieldMarker().clean();
        }
        for (Diagnostic diagnostic : diagnosticList) {
            this.markErrorWarningPropertyUI(diagnostic);
        }
    }

    protected void markErrorWarningPropertyUI(Diagnostic diagnostic) {
        if (diagnostic == null || diagnostic.getSeverity() == 0) {
            return;
        }
        List data = diagnostic.getData();
        for (Object object : data) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            if (eObject instanceof AbstractAnyType && eObject != this.getModel()) {
                return;
            }
            if (!(eObject instanceof EAttribute)) continue;
            AttributeFieldEditPart editPart = (AttributeFieldEditPart)this.currentPropertyUIMap.get(eObject);
            if (editPart == null) {
                return;
            }
            IFieldMarker marker = editPart.getFieldMarker();
            if (marker == null) {
                return;
            }
            if (diagnostic.getSeverity() == 4 && marker.getMarkerType() != 1) {
                marker.setMarkerType(1);
                marker.setMessage(diagnostic.getMessage());
            }
            if (diagnostic.getSeverity() != 2 || marker.getMarkerType() == 2 || marker.getMarkerType() == 1) continue;
            marker.setMarkerType(2);
            marker.setMessage(diagnostic.getMessage());
        }
        List children = diagnostic.getChildren();
        for (Diagnostic diagnostic2 : children) {
            this.markErrorWarningPropertyUI(diagnostic2);
        }
    }

    protected AttributeFieldEditPart createAttributeUI(Composite detailsComposite, IItemPropertyDescriptor propertyDescriptor, IPropertyUICreator creator) {
        IItemPropertyDescriptor itemPropertyDescriptor = propertyDescriptor;
        EAttribute feature = (EAttribute)itemPropertyDescriptor.getFeature(this.getModel());
        AttributeFieldEditPart editPart = null;
        boolean createDefault = true;
        if (creator != null) {
            if (creator.ignoreProperty(feature)) {
                return null;
            }
            editPart = creator.createPropertyUI(this.formToolkit, detailsComposite, itemPropertyDescriptor, this.getModel(), feature, this.smooksModelProvider, this.editorPart);
            if (editPart != null) {
                createDefault = false;
            }
        }
        if (createDefault) {
            EClassifier typeClazz = feature.getEType();
            boolean hasCreated = false;
            if (typeClazz instanceof EEnum) {
                editPart = this.createEnumFieldEditor(detailsComposite, feature, (EEnum)typeClazz, this.formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (typeClazz.getInstanceClass() == String.class) {
                editPart = this.createStringFieldEditor(detailsComposite, feature, this.formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (typeClazz.getInstanceClass() == Boolean.class || typeClazz.getInstanceClass() == Boolean.TYPE) {
                editPart = this.createBooleanFieldEditor(detailsComposite, feature, this.formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
            if (typeClazz.getInstanceClass() == Integer.class || typeClazz.getInstanceClass() == Integer.TYPE) {
                editPart = this.createIntegerFieldEditor(detailsComposite, feature, this.formToolkit, itemPropertyDescriptor);
                hasCreated = true;
            }
        }
        return editPart;
    }

    protected AttributeFieldEditPart createEnumFieldEditor(Composite propertyComposite, EAttribute feature, final EEnum typeClass, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        EList literalList = typeClass.getELiterals();
        String[] items = new String[literalList.size()];
        int i = 0;
        while (i < literalList.size()) {
            EEnumLiteral enumLiteral = (EEnumLiteral)literalList.get(i);
            items[i] = enumLiteral.getName();
            ++i;
        }
        final IItemPropertyDescriptor fip = itemPropertyDescriptor;
        IModelProcsser processer = new IModelProcsser(){

            public Object unwrapValue(Object model) {
                Object editValue = SmooksUIUtils.getEditValue(fip, SmooksStuffPropertyDetailPage.this.getModel());
                if (editValue instanceof Enumerator) {
                    return ((Enumerator)editValue).getName();
                }
                return null;
            }

            public Object wrapValue(Object model) {
                String name = model.toString();
                Object v = null;
                try {
                    Method method = typeClass.getInstanceClass().getMethod("get", String.class);
                    if (method != null) {
                        v = method.invoke(null, name);
                    }
                }
                catch (Throwable throwable) {}
                return v;
            }
        };
        return SmooksUIUtils.createChoiceFieldEditor(propertyComposite, this.formToolkit, itemPropertyDescriptor, this.getModel(), items, processer, true);
    }

    protected AttributeFieldEditPart createBooleanFieldEditor(Composite propertyComposite, EAttribute feature, FormToolkit formToolkit, IItemPropertyDescriptor itemPropertyDescriptor) {
        IModelProcsser processer = new IModelProcsser(){

            public Object unwrapValue(Object model) {
                if (model instanceof Boolean) {
                    if (((Boolean)model).booleanValue()) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "FALSE";
            }

            public Object wrapValue(Object model) {
                try {
                    return Boolean.parseBoolean(model.toString());
                }
                catch (Throwable throwable) {
                    return Boolean.FALSE;
                }
            }
        };
        return SmooksUIUtils.createChoiceFieldEditor(propertyComposite, formToolkit, itemPropertyDescriptor, this.getModel(), new String[]{"TRUE", "FALSE"}, processer, true);
    }

    protected AttributeFieldEditPart createStringFieldEditor(Composite propertyComposite, EAttribute feature, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        return SmooksUIUtils.createStringFieldEditor(propertyComposite, formToolKit, itemPropertyDescriptor, this.getModel(), false, false, null);
    }

    protected AttributeFieldEditPart createIntegerFieldEditor(Composite propertyComposite, EAttribute feature, FormToolkit formToolKit, IItemPropertyDescriptor itemPropertyDescriptor) {
        return SmooksUIUtils.createNumberFieldEditor(null, propertyComposite, formToolKit, itemPropertyDescriptor, this.getModel(), new INumberParser(){

            public Object transformText(String text) {
                return Integer.parseInt(text);
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object oldModel = this.getModel();
        this.setOldModel(oldModel);
        this.selection = selection;
        this.formPart = part;
        this.itemPropertySource = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt(this.getModel(), IItemPropertySource.class);
        if (this.getOldModel() == this.getModel()) {
            return;
        }
        if (this.getOldModel() != this.getModel()) {
            if (this.propertyComposite != null) {
                this.propertyComposite.dispose();
                this.propertyComposite = new Composite(this.propertyMainComposite, 0);
            }
            this.createStuffDetailsComposite(this.propertyComposite);
        }
        this.refreshWhenSelectionChanged();
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public IFormPart getFormPart() {
        return this.formPart;
    }

    public void initialize(IManagedForm form) {
        this.managedForm = form;
        if (this.managedForm != null) {
            this.formToolkit = this.managedForm.getToolkit();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return this.isStale;
    }

    public void refresh() {
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public Object getModel() {
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)this.selection).getFirstElement();
        }
        return null;
    }

    protected void refreshWhenSelectionChanged() {
        Object model = this.getModel();
        if (model instanceof EObject) {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.editingDomain.getAdapterFactory().adapt(model, IItemLabelProvider.class);
            String text = labelProvider.getText(model);
            if (text == null || text.length() == 0) {
                text = ((EObject)model).eClass().getName();
            }
            this.section.setText(text);
            this.section.layout();
        }
    }

    protected void cleanCurrentPropertyUIMap() {
        this.currentPropertyUIMap.clear();
    }

    public ISmooksModelProvider getSmooksModelProvider() {
        return this.smooksModelProvider;
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    protected Object getOldModel() {
        return this.oldModel;
    }

    protected void setOldModel(Object oldModel) {
        this.oldModel = oldModel;
    }

    public void setStale(boolean isStale) {
        this.isStale = isStale;
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        this.markPropertyUI(diagnosticResult);
    }

    @Override
    public void validateStart() {
    }
}

