/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.common.util.EList;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.XMLObjectAnalyzer;
import org.jboss.tools.smooks.model.csv12.CSV12Reader;
import org.jboss.tools.smooks.model.smooks.AbstractReader;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.csv.CSVReaderConfigurator;
import org.w3c.dom.Document;

public class CSVDataParser {
    public static final String LINK_CSV_READER = "linkCSVReader";
    public static final String SEPARATOR = "separator";
    public static final String QUOTECHAR = "quoteChar";
    public static final String SKIPLINES = "skiplines";
    public static final String ENCODING = "encoding";
    public static final String FIELDS = "fields";
    public static final String ROOT_ELEMENT_NAME = "rootElementName";
    public static final String RECORD_NAME = "recordName";

    public TagList parseCSV(String filePath, SmooksResourceListType resourceList) throws FileNotFoundException, InvocationTargetException, ParserConfigurationException {
        return this.parseCSV((InputStream)new FileInputStream(SmooksUIUtils.parseFilePath(filePath)), resourceList);
    }

    public TagList parseCSV(InputStream inputStream, Object readerObj) throws ParserConfigurationException {
        String fields = null;
        String separator = null;
        String quoteChar = null;
        String skiplines = null;
        String encoding = null;
        String rootName = null;
        String recordName = null;
        if (readerObj == null) {
            return null;
        }
        if (readerObj instanceof CSV12Reader) {
            CSV12Reader reader = (CSV12Reader)readerObj;
            fields = reader.getFields();
            separator = reader.getSeparator();
            skiplines = reader.getSkipLines().toString();
            quoteChar = reader.getQuote();
            encoding = reader.getEncoding();
            rootName = reader.getRootElementName();
            recordName = reader.getRecordElementName();
        }
        return this.parseCSV(inputStream, fields, rootName, recordName, separator, quoteChar, skiplines, encoding);
    }

    public TagList parseCSV(InputStream stream, SmooksResourceListType resourceList) throws ParserConfigurationException {
        EList readers = resourceList.getAbstractReader();
        int count = 0;
        int index = -1;
        for (AbstractReader abstractReader : readers) {
            if (!(abstractReader instanceof CSV12Reader)) continue;
            ++count;
            if (index != -1) continue;
            index = readers.indexOf(abstractReader);
        }
        if (index != -1) {
            return this.parseCSV(stream, readers.get(index));
        }
        return null;
    }

    public TagList parseCSV(String filePath, String fields, String rootName, String recordName, String separator, String quoteChar, String skiplines, String encoding) throws FileNotFoundException {
        return this.parseCSV(new FileInputStream(filePath), fields, rootName, recordName, separator, quoteChar, skiplines, encoding);
    }

    public TagList parseCSV(InputStream stream, String fields, String rootName, String recordName, String separator, String quoteChar, String skiplines, String encoding) {
        Smooks smooks = new Smooks();
        CSVReaderConfigurator readerConfigurator = new CSVReaderConfigurator(fields);
        if (separator != null && separator.length() >= 1) {
            readerConfigurator.setSeparatorChar(separator.toCharArray()[0]);
        }
        if (quoteChar != null && quoteChar.length() >= 1) {
            readerConfigurator.setQuoteChar(quoteChar.toCharArray()[0]);
        }
        if (skiplines != null) {
            try {
                readerConfigurator.setSkipLineCount(Integer.parseInt(skiplines));
            }
            catch (Throwable throwable) {}
        }
        if (rootName != null) {
            readerConfigurator.setRootElementName(rootName);
        }
        if (recordName != null) {
            readerConfigurator.setRecordElementName(recordName);
        }
        readerConfigurator.setEncoding(Charset.forName(encoding));
        smooks.setReaderConfig((ReaderConfigurator)readerConfigurator);
        DOMResult result = new DOMResult();
        smooks.filterSource((Source)new StreamSource(stream), new Result[]{result});
        Document document = (Document)result.getNode();
        XMLObjectAnalyzer analyzer = new XMLObjectAnalyzer();
        TagList tagList = analyzer.analyze(document, null, null);
        try {
            if (smooks != null) {
                smooks.close();
                smooks = null;
            }
            if (stream != null) {
                stream.close();
                stream = null;
            }
            result = null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return tagList;
    }
}

