/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.jboss.tools.smooks.configuration.editors.csv.CSVDataConfigurationWizardPage;
import org.jboss.tools.smooks.configuration.editors.csv.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractFileSelectionWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDataPathWizardPage
extends AbstractFileSelectionWizardPage {
    private CSVDataConfigurationWizardPage configPage;

    public CSVDataPathWizardPage(String pageName, boolean multiSelect, Object[] initSelections, List<ViewerFilter> filters, CSVDataConfigurationWizardPage configPage) {
        super(pageName, multiSelect, initSelections, filters);
        this.configPage = configPage;
    }

    public CSVDataPathWizardPage(String pageName, String[] fileExtensionNames, CSVDataConfigurationWizardPage configPage) {
        super(pageName, fileExtensionNames);
        this.setTitle(Messages.CSVDataPathWizardPage_WizardTitle);
        this.setDescription(Messages.CSVDataPathWizardPage_WizardDes);
        this.configPage = configPage;
    }

    @Override
    protected void hookFileTextModifyListener() {
        super.hookFileTextModifyListener();
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CSVDataPathWizardPage.this.configPage != null) {
                    CSVDataPathWizardPage.this.configPage.setFilePath(CSVDataPathWizardPage.this.fileText.getText());
                }
            }
        });
    }

    @Override
    protected Object loadedTheObject(String path) throws Exception {
        return null;
    }

    @Override
    protected void changeWizardPageStatus() {
        super.changeWizardPageStatus();
        String text = this.fileText.getText();
        String error = null;
        try {
            String filePath = SmooksUIUtils.parseFilePath(text);
            if (!new File(filePath).exists()) {
                error = String.valueOf(Messages.CSVDataPathWizardPage_CantFindFileErrorMessage) + filePath;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            error = Messages.CSVDataPathWizardPage_ErrorPathErrorMessage;
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

