/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.PropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.csv.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvReaderUICreator
extends PropertyUICreator {
    private List<FieldText> fieldsList = new ArrayList<FieldText>();

    @Override
    public AttributeFieldEditPart createPropertyUI(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor, IEditorPart part) {
        return super.createPropertyUI(toolkit, parent, propertyDescriptor, model, feature, formEditor, part);
    }

    @Override
    public boolean ignoreProperty(EAttribute feature) {
        return super.ignoreProperty(feature);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnBottom(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        this.createFiledsComposite(editingdomain, toolkit, parent, model, formEditor);
        return super.createExtendUIOnBottom(editingdomain, toolkit, parent, model, formEditor, editorPart);
    }

    private void createFiledsComposite(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor) {
        this.fieldsList.clear();
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        Group fieldsComposite = new Group(parent, 0);
        fieldsComposite.setBackground(toolkit.getColors().getBackground());
        fieldsComposite.setText(Messages.CsvReaderUICreator_FieldsLabel);
        fieldsComposite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        fieldsComposite.setLayout((Layout)gl);
        IItemPropertySource cfr_ignored_0 = (IItemPropertySource)editingdomain.getAdapterFactory().adapt(model, IItemPropertySource.class);
        final IItemPropertyDescriptor descriptor = null;
        final Object readOnlyMoel = model;
        String fields = (String)SmooksUIUtils.getEditValue(descriptor, model);
        gd = new GridData(1808);
        final TableViewer fieldsViewer = new TableViewer((Composite)fieldsComposite, 67586);
        fieldsViewer.getControl().setLayoutData((Object)gd);
        fieldsViewer.getTable().setLinesVisible(true);
        fieldsViewer.setContentProvider((IContentProvider)new FieldsContentProvider());
        fieldsViewer.setLabelProvider((IBaseLabelProvider)new FieldsLabelProvider());
        TextCellEditor fieldCellEditor = new TextCellEditor((Composite)fieldsViewer.getTable(), 2048);
        fieldsViewer.getTable().setLinesVisible(true);
        fieldsViewer.setCellEditors(new CellEditor[]{fieldCellEditor});
        fieldsViewer.setColumnProperties(new String[]{"field"});
        fieldsViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                Object el = null;
                if (element instanceof Item) {
                    el = ((Item)element).getData();
                }
                if (el == null) {
                    return;
                }
                if (el instanceof FieldText && value instanceof String && property.equals("field")) {
                    if (value.toString().equals(((FieldText)el).getText())) {
                        return;
                    }
                    ((FieldText)el).setText(value.toString());
                    fieldsViewer.refresh(el);
                    CsvReaderUICreator.this.setFieldsValue(readOnlyMoel, descriptor);
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof FieldText && property.equals("field")) {
                    return ((FieldText)element).getText();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return element instanceof FieldText && property.equals("field");
            }
        });
        if (fields == null) {
            fields = "";
        }
        this.fillFieldsList(fields);
        fieldsViewer.setInput(this.fieldsList);
        Composite buttonComposite = toolkit.createComposite((Composite)fieldsComposite);
        gd = new GridData(1040);
        gd.widthHint = 100;
        buttonComposite.setLayoutData((Object)gd);
        GridLayout bgl = new GridLayout();
        buttonComposite.setLayout((Layout)bgl);
        gd = new GridData(768);
        final Button addButton = new Button(buttonComposite, 0);
        addButton.setLayoutData((Object)gd);
        addButton.setText(Messages.CsvReaderUICreator_AddButtonLabel);
        Button removeButton = new Button(buttonComposite, 0);
        removeButton.setLayoutData((Object)gd);
        removeButton.setText(Messages.CsvReaderUICreator_RemoveButtonLabel);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                addButton.setEnabled(false);
                try {
                    try {
                        FieldText field = new FieldText("field");
                        CsvReaderUICreator.this.fieldsList.add(field);
                        fieldsViewer.refresh();
                        CsvReaderUICreator.this.setFieldsValue(readOnlyMoel, descriptor);
                    }
                    catch (Throwable throwable) {
                        addButton.setEnabled(true);
                    }
                }
                finally {
                    addButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s = (IStructuredSelection)fieldsViewer.getSelection();
                CsvReaderUICreator.this.fieldsList.removeAll(s.toList());
                fieldsViewer.refresh();
                CsvReaderUICreator.this.setFieldsValue(readOnlyMoel, descriptor);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setFieldsValue(Object model, IItemPropertyDescriptor ps) {
        String fieldsString = "";
        int i = 0;
        while (i < this.fieldsList.size()) {
            FieldText fieldText = this.fieldsList.get(i);
            fieldsString = String.valueOf(fieldsString) + fieldText.getText();
            if (i < this.fieldsList.size() - 1) {
                fieldsString = String.valueOf(fieldsString) + ",";
            }
            ++i;
        }
        ps.setPropertyValue(model, (Object)fieldsString);
    }

    private void fillFieldsList(String fieldsString) {
        if (fieldsString == null || fieldsString.length() == 0) {
            return;
        }
        String input = fieldsString.toString();
        if ((input = input.trim()).indexOf(",") != -1) {
            String[] fields = input.split(",");
            if (fields != null && fields.length > 0) {
                int i = 0;
                while (i < fields.length) {
                    String field = fields[i];
                    if (field != null) {
                        field = field.trim();
                        this.fieldsList.add(new FieldText(field));
                    }
                    ++i;
                }
            }
        } else {
            this.fieldsList.add(new FieldText(input));
        }
    }

    private class FieldText {
        private String text = null;

        public FieldText(String t) {
            this.setText(t);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    private class FieldsContentProvider
    implements IStructuredContentProvider {
        private FieldsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private class FieldsLabelProvider
    extends LabelProvider {
        private FieldsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof FieldText) {
                return ((FieldText)element).getText();
            }
            return super.getText(element);
        }
    }
}

