/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv12;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.model.csv12.CSV12Reader;
import org.jboss.tools.smooks.model.csv12.impl.CSV12ReaderImpl;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSV12DataConfigurationWizardPage
extends WizardPage {
    private SmooksResourceListType smooksResourceList;
    private Button newReaderConfigButton;
    private Button useAvailableReaderConfigButton;
    private Composite configComposite;
    private Text separatorText;
    private Text quoteCharText;
    private Text skipLinesText;
    private Text encodingText;
    private Composite fieldsComposite;
    private TableViewer fieldsViewer;
    private Button addButton;
    private Button removeButton;
    private Button createCSVReaderButton;
    private String filePath = null;
    private boolean useAvailabelReader = false;
    private boolean hasReader = false;
    private boolean createCSVReader = true;
    private String separator;
    private String skipLines;
    private String quoteChar;
    private String encoding;
    private String rootName;
    private String recordName;
    private List<FieldString> fieldsList = new ArrayList<FieldString>();
    private Text rootNameText;
    private Text recordNameText;
    private Combo indentText;
    protected String indent;

    public CSV12DataConfigurationWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public CSV12DataConfigurationWizardPage(String pageName) {
        super(pageName);
        this.setTitle("CSV Reader configurations (version 1.2)");
        this.setDescription("Set the configurations for parsing CSV file.");
    }

    public void createControl(Composite parent) {
        this.initValue();
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)gd);
        Composite radioButtonComposite = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        radioButtonComposite.setLayoutData((Object)gd);
        GridLayout rgl = new GridLayout();
        rgl.numColumns = 2;
        rgl.marginHeight = 0;
        rgl.marginWidth = 0;
        radioButtonComposite.setLayout((Layout)rgl);
        Composite spaceComposite = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 20;
        spaceComposite.setLayoutData((Object)gd);
        this.newReaderConfigButton = new Button(radioButtonComposite, 16);
        this.newReaderConfigButton.setText("Create new CSV reader configurations");
        this.newReaderConfigButton.setSelection(true);
        this.useAvailableReaderConfigButton = new Button(radioButtonComposite, 16);
        this.useAvailableReaderConfigButton.setText("Use available CSV reader configurations");
        this.configComposite = new Composite(mainComposite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.configComposite.setLayoutData((Object)gd);
        GridLayout cgl = new GridLayout();
        cgl.marginHeight = 0;
        cgl.marginWidth = 0;
        cgl.numColumns = 2;
        this.configComposite.setLayout((Layout)cgl);
        gd = new GridData(768);
        Label rootnameLabel = new Label(this.configComposite, 0);
        rootnameLabel.setText("Root Name");
        this.rootNameText = new Text(this.configComposite, 2048);
        this.rootNameText.setLayoutData((Object)gd);
        Label recordNameLabel = new Label(this.configComposite, 0);
        recordNameLabel.setText("Record Name");
        this.recordNameText = new Text(this.configComposite, 2048);
        this.recordNameText.setLayoutData((Object)gd);
        gd = new GridData(768);
        Label separatorLabel = new Label(this.configComposite, 0);
        separatorLabel.setText("Separator");
        this.separatorText = new Text(this.configComposite, 2048);
        this.separatorText.setLayoutData((Object)gd);
        Label quoteCharLabel = new Label(this.configComposite, 0);
        quoteCharLabel.setText("Quote Char");
        this.quoteCharText = new Text(this.configComposite, 2048);
        this.quoteCharText.setLayoutData((Object)gd);
        Label skiplineLabel = new Label(this.configComposite, 0);
        skiplineLabel.setText("Skip Lines");
        this.skipLinesText = new Text(this.configComposite, 2048);
        this.skipLinesText.setLayoutData((Object)gd);
        Label indentLabel = new Label(this.configComposite, 0);
        indentLabel.setText("Indent");
        this.indentText = new Combo(this.configComposite, 2056);
        this.indentText.add("");
        this.indentText.add("TRUE");
        this.indentText.add("FALSE");
        this.indentText.setLayoutData((Object)gd);
        Label encodingLabel = new Label(this.configComposite, 0);
        encodingLabel.setText("Encoding");
        this.encodingText = new Text(this.configComposite, 2048);
        this.encodingText.setLayoutData((Object)gd);
        this.encodingText.setText(this.encoding);
        Label keyMapLabel = new Label(this.configComposite, 0);
        keyMapLabel.setText("Fields List:");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        keyMapLabel.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fieldsComposite = new Composite(this.configComposite, 0);
        this.fieldsComposite.setLayoutData((Object)gd);
        GridLayout kgl = new GridLayout();
        kgl.numColumns = 2;
        this.fieldsComposite.setLayout((Layout)kgl);
        gd = new GridData(1808);
        gd.heightHint = 200;
        this.fieldsViewer = new TableViewer(this.fieldsComposite, 67586);
        this.fieldsViewer.getControl().setLayoutData((Object)gd);
        this.fieldsViewer.getTable().setLinesVisible(true);
        this.fieldsViewer.setContentProvider((IContentProvider)new FieldsContentProvider());
        this.fieldsViewer.setLabelProvider((IBaseLabelProvider)new FieldsLabelProvider());
        TextCellEditor fieldCellEditor = new TextCellEditor((Composite)this.fieldsViewer.getTable(), 2048);
        TableColumn fieldColumn = new TableColumn(this.fieldsViewer.getTable(), 0);
        fieldColumn.setText("Field");
        fieldColumn.setWidth(150);
        TableColumn exampleValueColumn = new TableColumn(this.fieldsViewer.getTable(), 0);
        exampleValueColumn.setText("Example Value");
        exampleValueColumn.setWidth(150);
        this.fieldsViewer.getTable().setHeaderVisible(true);
        this.fieldsViewer.getTable().setLinesVisible(true);
        this.fieldsViewer.setCellEditors(new CellEditor[]{fieldCellEditor});
        this.fieldsViewer.setColumnProperties(new String[]{"field"});
        this.fieldsViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                Object el = null;
                if (element instanceof Item) {
                    el = ((Item)element).getData();
                }
                if (el == null) {
                    return;
                }
                if (el instanceof FieldString && value instanceof String) {
                    if (property.equals("field")) {
                        ((FieldString)el).setText(value.toString());
                    }
                    CSV12DataConfigurationWizardPage.this.fieldsViewer.refresh(el);
                }
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }

            public Object getValue(Object element, String property) {
                if (element instanceof FieldString && property.equals("field")) {
                    return ((FieldString)element).getText();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return element instanceof FieldString && property.equals("field");
            }
        });
        this.fieldsViewer.setInput(this.fieldsList);
        Composite buttonComposite = new Composite(this.fieldsComposite, 0);
        gd = new GridData(1040);
        gd.widthHint = 0;
        buttonComposite.setLayoutData((Object)gd);
        buttonComposite.setVisible(false);
        GridLayout bgl = new GridLayout();
        buttonComposite.setLayout((Layout)bgl);
        gd = new GridData(768);
        this.addButton = new Button(buttonComposite, 0);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.setText("Add");
        this.removeButton = new Button(buttonComposite, 0);
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setText("Remove");
        this.createCSVReaderButton = new Button(this.configComposite, 32);
        this.createCSVReaderButton.setText("Create a CSV Reader");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.createCSVReaderButton.setLayoutData((Object)gd);
        this.createCSVReaderButton.setSelection(this.createCSVReader);
        if (this.hasReader) {
            this.useAvailableReaderConfigButton.setSelection(true);
            this.newReaderConfigButton.setSelection(false);
            this.createCSVReaderButton.setEnabled(false);
            this.setConfigCompositeStates(false);
        }
        this.changePageStatus();
        this.hookControls();
        this.setControl((Control)mainComposite);
    }

    private void hookControls() {
        this.newReaderConfigButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CSV12DataConfigurationWizardPage.this.newReaderConfigButton.getSelection()) {
                    CSV12DataConfigurationWizardPage.this.setConfigCompositeStates(true);
                    CSV12DataConfigurationWizardPage.this.useAvailabelReader = false;
                    CSV12DataConfigurationWizardPage.this.changePageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useAvailableReaderConfigButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CSV12DataConfigurationWizardPage.this.useAvailableReaderConfigButton.getSelection()) {
                    CSV12DataConfigurationWizardPage.this.setConfigCompositeStates(false);
                    CSV12DataConfigurationWizardPage.this.useAvailabelReader = true;
                    CSV12DataConfigurationWizardPage.this.changePageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.separatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.separator = CSV12DataConfigurationWizardPage.this.separatorText.getText();
                CSV12DataConfigurationWizardPage.this.resetViewerContent();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.quoteCharText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.quoteChar = CSV12DataConfigurationWizardPage.this.quoteCharText.getText();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.rootNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.rootName = CSV12DataConfigurationWizardPage.this.rootNameText.getText();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.recordNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.recordName = CSV12DataConfigurationWizardPage.this.recordNameText.getText();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.skipLinesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.skipLines = CSV12DataConfigurationWizardPage.this.skipLinesText.getText();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.encodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.encoding = CSV12DataConfigurationWizardPage.this.encodingText.getText();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.indentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSV12DataConfigurationWizardPage.this.indent = CSV12DataConfigurationWizardPage.this.indentText.getText();
                CSV12DataConfigurationWizardPage.this.changePageStatus();
            }
        });
        this.createCSVReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CSV12DataConfigurationWizardPage.this.createCSVReader = CSV12DataConfigurationWizardPage.this.createCSVReaderButton.getSelection();
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FieldString field = new FieldString("field");
                CSV12DataConfigurationWizardPage.this.fieldsList.add(field);
                CSV12DataConfigurationWizardPage.this.fieldsViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s = (IStructuredSelection)CSV12DataConfigurationWizardPage.this.fieldsViewer.getSelection();
                CSV12DataConfigurationWizardPage.this.fieldsList.removeAll(s.toList());
                CSV12DataConfigurationWizardPage.this.fieldsViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void resetViewerContent() {
        try {
            this.fieldsList.clear();
            if (this.filePath != null && this.separator != null && this.separator.length() == 1) {
                String[] exampleValues;
                this.filePath = SmooksUIUtils.parseFilePath(this.filePath);
                FileReader fr = new FileReader(this.filePath);
                BufferedReader br = new BufferedReader(fr);
                String content = br.readLine();
                if (content != null && (exampleValues = content.split(this.separator)) != null) {
                    ArrayList<FieldString> list = new ArrayList<FieldString>();
                    int i = 0;
                    while (i < exampleValues.length) {
                        String s = exampleValues[i];
                        if (s != null) {
                            if (s.length() == 0) {
                                s = "<Null>";
                            }
                            FieldString fs = new FieldString("");
                            fs.setExampleValue(s);
                            list.add(fs);
                        }
                        ++i;
                    }
                    if (!list.isEmpty()) {
                        this.fieldsList.addAll(list);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.setErrorMessage("Occurs an error when parse CSV file");
        }
        this.fieldsViewer.refresh();
    }

    private void changePageStatus() {
        if (this.useAvailabelReader) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return;
        }
        String error = null;
        if (this.separator == null || this.separator.length() == 0) {
            error = "Sperator can't be null";
        }
        if (this.separator != null && this.separator.length() > 1) {
            error = "Sperator needs only one char";
        }
        if (this.quoteChar == null || this.quoteChar.length() == 0) {
            error = "QuoteChar can't be null";
        }
        if (this.quoteChar != null && this.quoteChar.length() > 1) {
            error = "QuoteChar needs only one char";
        }
        if (this.encoding == null || this.encoding.length() == 0) {
            error = "Encoding can't be null";
        }
        if (this.skipLines != null && this.skipLines.length() != 0) {
            try {
                Integer.parseInt(this.skipLines);
            }
            catch (Throwable throwable) {
                error = "Skip lines text must be the number";
            }
        }
        for (FieldString field : this.fieldsList) {
            if (field.getText() != null && field.getText().length() != 0) continue;
            error = "Fields can't be null";
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private void setConfigCompositeStates(boolean enabled) {
        this.configComposite.setEnabled(enabled);
        Control[] controls = this.configComposite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c == this.createCSVReaderButton && this.hasReader) {
                c.setEnabled(false);
            } else {
                if (c == this.fieldsComposite) {
                    Control[] cs = ((Composite)c).getChildren();
                    int j = 0;
                    while (j < cs.length) {
                        Control cc = cs[j];
                        cc.setEnabled(enabled);
                        ++j;
                    }
                }
                c.setEnabled(enabled);
            }
            ++i;
        }
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public List<FieldString> getFieldsList() {
        return this.fieldsList;
    }

    public void setFieldsList(List<FieldString> fieldsList) {
        this.fieldsList = fieldsList;
    }

    public boolean isUseAvailabelReader() {
        return this.useAvailabelReader;
    }

    public void setUseAvailabelReader(boolean useAvailabelReader) {
        this.useAvailabelReader = useAvailabelReader;
    }

    public boolean isCreateCSVReader() {
        return this.createCSVReader;
    }

    public void setCreateCSVReader(boolean createCSVReader) {
        this.createCSVReader = createCSVReader;
    }

    public String getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(String skipLines) {
        this.skipLines = skipLines;
    }

    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    private void initValue() {
        this.indent = null;
        this.useAvailabelReader = false;
        this.filePath = null;
        this.hasReader = false;
        this.rootName = null;
        this.recordName = null;
        if (SmooksUIUtils.hasReaderAlready(CSV12Reader.class, this.smooksResourceList) || SmooksUIUtils.hasReaderAlready(CSV12ReaderImpl.class, this.smooksResourceList)) {
            this.hasReader = true;
        }
        this.createCSVReader = true;
        this.encoding = "UTF-8";
        this.separator = null;
        this.skipLines = null;
        this.quoteChar = null;
        this.fieldsList.clear();
        if (this.hasReader) {
            this.createCSVReader = false;
            this.useAvailabelReader = true;
        }
    }

    public SmooksResourceListType getSmooksResourceList() {
        return this.smooksResourceList;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setSmooksResourceList(SmooksResourceListType smooksResourceList) {
        this.smooksResourceList = smooksResourceList;
    }

    public class FieldString {
        private String text = null;
        private String exampleValue;

        public String getExampleValue() {
            return this.exampleValue;
        }

        public void setExampleValue(String exampleValue) {
            this.exampleValue = exampleValue;
        }

        public FieldString(String text) {
            this.setText(text);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    private class FieldsContentProvider
    implements IStructuredContentProvider {
        private FieldsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FieldsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    ITableColorProvider {
        private Font font = null;

        public void dispose() {
            if (this.font != null) {
                this.font.dispose();
            }
            super.dispose();
        }

        public FieldsLabelProvider() {
            FontData fd = new FontData();
            fd.setName("Arial");
            this.font = new Font(null, fd);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof FieldString) {
                switch (columnIndex) {
                    case 0: {
                        return ((FieldString)element).getText();
                    }
                    case 1: {
                        return ((FieldString)element).getExampleValue();
                    }
                }
                return ((FieldString)element).getText();
            }
            return this.getText(element);
        }

        public Font getFont(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.font;
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ColorConstants.lightGray;
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ColorConstants.darkGray;
            }
            return null;
        }
    }
}

